/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted;

import com.oracle.svm.core.util.VMError;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;

public final class ProgressReporterCHelper {
    private static final int DEFAULT_CHARACTERS_PER_LINE = 80;
    static final int MAX_CHARACTERS_PER_LINE = 120;

    private static void loadCHelperLibrary() {
        Path javaHome = Paths.get(System.getProperty("java.home"), new String[0]);
        String libName = System.mapLibraryName("reporterchelper");
        Path libRSSHelperPath = javaHome.resolve(Paths.get("lib", "svm", "builder", "lib", libName));
        if (Files.exists(libRSSHelperPath, new LinkOption[0])) {
            System.load(libRSSHelperPath.toString());
        } else {
            System.load(Paths.get(System.getProperty("substratevm.reporterchelper.path"), libName).toString());
        }
    }

    private ProgressReporterCHelper() {
    }

    public static int getTerminalWindowColumnsClamped() {
        return Math.min(Math.max(80, ProgressReporterCHelper.getTerminalWindowColumns()), 120);
    }

    public static int getTerminalWindowColumns() {
        try {
            return ProgressReporterCHelper.getTerminalWindowColumns0();
        }
        catch (UnsatisfiedLinkError e) {
            throw VMError.shouldNotReachHere("ProgressReporterCHelper.getTerminalWindowColumns0 native method not available");
        }
    }

    public static long getPeakRSS() {
        try {
            return ProgressReporterCHelper.getPeakRSS0();
        }
        catch (UnsatisfiedLinkError e) {
            throw VMError.shouldNotReachHere("ProgressReporterCHelper.getPeakRSS0 native method not available");
        }
    }

    private static native long getPeakRSS0();

    private static native int getTerminalWindowColumns0();

    static {
        ProgressReporterCHelper.loadCHelperLibrary();
    }
}

