/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jfr;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.jfr.HasJfrSupport;
import java.util.concurrent.TimeUnit;

public final class JfrTicks {
    private static long initialTicks;

    private JfrTicks() {
    }

    public static void initialize() {
        initialTicks = System.nanoTime();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static long elapsedTicks() {
        if (HasJfrSupport.get() && initialTicks > 0L) {
            return System.nanoTime() - initialTicks;
        }
        return 0L;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static long duration(long startTicks) {
        return JfrTicks.elapsedTicks() - startTicks;
    }

    public static long getTicksFrequency() {
        return TimeUnit.SECONDS.toNanos(1L);
    }

    public static long currentTimeNanos() {
        return TimeUnit.MILLISECONDS.toNanos(System.currentTimeMillis());
    }
}

