/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk;

import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.jdk.ResourcesHelper;
import com.oracle.svm.core.jdk.Target_java_lang_ClassLoader;
import java.io.IOException;
import java.io.InputStream;
import java.lang.module.ModuleReference;
import java.net.URL;
import java.util.Enumeration;
import java.util.List;
import jdk.internal.loader.BuiltinClassLoader;

@TargetClass(value=BuiltinClassLoader.class)
final class Target_jdk_internal_loader_BuiltinClassLoader {
    Target_jdk_internal_loader_BuiltinClassLoader() {
    }

    @Substitute
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        throw new ClassNotFoundException(name);
    }

    @Substitute
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Target_java_lang_ClassLoader self = SubstrateUtil.cast(this, Target_java_lang_ClassLoader.class);
        Class<?> clazz = self.findLoadedClass(name);
        if (clazz == null) {
            throw new ClassNotFoundException(name);
        }
        return clazz;
    }

    @Substitute
    public URL findResource(String mn, String name) {
        Module module = ModuleLayer.boot().findModule(mn).orElse(null);
        return ResourcesHelper.nameToResourceURL(module, name);
    }

    @Substitute
    public InputStream findResourceAsStream(String mn, String name) throws IOException {
        return ResourcesHelper.nameToResourceInputStream(name);
    }

    @Substitute
    public URL findResource(String name) {
        return ResourcesHelper.nameToResourceURL(name);
    }

    @Substitute
    public Enumeration<URL> findResources(String name) {
        return ResourcesHelper.nameToResourceEnumerationURLs(name);
    }

    @Substitute
    private List<URL> findMiscResource(String name) {
        return ResourcesHelper.nameToResourceListURLs(name);
    }

    @Substitute
    private URL findResource(ModuleReference mref, String name) {
        Module module = ModuleLayer.boot().findModule(mref.descriptor().name()).orElse(null);
        return ResourcesHelper.nameToResourceURL(module, name);
    }

    @Substitute
    private URL findResourceOnClassPath(String name) {
        return ResourcesHelper.nameToResourceURL(name);
    }

    @Substitute
    private Enumeration<URL> findResourcesOnClassPath(String name) {
        return ResourcesHelper.nameToResourceEnumerationURLs(name);
    }
}

