/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.cpufeature;

import com.oracle.svm.core.cpufeature.RuntimeCPUFeatureCheckImpl;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import jdk.vm.ci.amd64.AMD64;
import jdk.vm.ci.code.Architecture;
import org.graalvm.compiler.graph.Node;

public final class RuntimeCPUFeatureCheck {
    public static Set<? extends Enum<?>> getSupportedFeatures(Architecture arch) {
        if (arch instanceof AMD64) {
            return EnumSet.of(AMD64.CPUFeature.AVX, AMD64.CPUFeature.AVX2, AMD64.CPUFeature.AVX512F, AMD64.CPUFeature.AVX512BW);
        }
        return Collections.emptySet();
    }

    public static Set<? extends Enum<?>> getDefaultDisabledFeatures(Architecture arch) {
        if (arch instanceof AMD64) {
            return EnumSet.of(AMD64.CPUFeature.AVX512F, AMD64.CPUFeature.AVX512BW);
        }
        return Collections.emptySet();
    }

    @Node.NodeIntrinsic(value=RuntimeCPUFeatureCheckImpl.class)
    public static native <T extends Enum<T>> boolean isSupported(@Node.ConstantNodeParameter Enum<T> var0);

    @Node.NodeIntrinsic(value=RuntimeCPUFeatureCheckImpl.class)
    public static native <T extends Enum<T>> boolean isSupported(@Node.ConstantNodeParameter Enum<T> var0, @Node.ConstantNodeParameter Enum<T> var1);

    @Node.NodeIntrinsic(value=RuntimeCPUFeatureCheckImpl.class)
    public static native <T extends Enum<T>> boolean isSupported(@Node.ConstantNodeParameter Enum<T> var0, @Node.ConstantNodeParameter Enum<T> var1, @Node.ConstantNodeParameter Enum<T> var2);
}

