/*
 * Copyright (c) 2019, 2021, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

#ifndef SVM_SHARED_STRUCTS_HPP
#define SVM_SHARED_STRUCTS_HPP

#include <sys/types.h>

// forward declaration of the SVM CodeInfo
typedef struct CodeInfo CodeInfo;

struct HeapOptions {
  size_t max_heap_size;
  size_t heap_address_space_size;
  size_t physical_memory_size;
};

struct GCConstants {
  void* card_table_address;
  void* gc_total_collections_address;
  int tlab_top_offset;
  int tlab_end_offset;
  int satb_queue_marking_offset;
  int satb_queue_buffer_offset;
  int satb_queue_index_offset;
  int card_queue_buffer_offset;
  int card_queue_index_offset;
  int card_table_shift;
  int log_of_heap_region_grain_bytes;
  int java_thread_size;
  int vm_operation_data_size;
  int vm_operation_wrapper_data_size;
  char dirty_card_value;
  char young_card_value;
};

struct GCRegionBoundaries {
  u_char *bottom;
  u_char *top;
};

struct GCRegionInfo {
  u_char *bottom;
  u_char *top;
  u_char *end;
  u_char *top_at_mark_start;
  u_char *parsable_bottom;
  int pinned_object_count;
  char in_collection_set;
  char remembered_set_state;
  char region_type;
};

struct GCInternalState {
  unsigned int total_collections;
  unsigned int full_collections;

  void* card_table_start;
  size_t card_table_size;

  void* block_offset_table_start;
  size_t block_offset_table_size;};

// data structures for frames that are currently on the stack
struct StackFrame {
  u_char *stack_pointer;
  u_char *encoded_reference_map;
  size_t reference_map_index;
};

struct StackFrames {
  size_t count;
  struct StackFrame frames[0]; // variable-sized array
};

struct StackFramesPerThread {
  size_t count;
  struct StackFrames *threads[0]; // variable-sized array
};

// data structures for JIT-compiled code that is currently on the stack
struct CodeInfos {
  size_t count;
  struct CodeInfo *code_infos[0]; // variable-sized array
};

struct CodeInfosPerThread {
  size_t count;
  struct CodeInfos *threads[0]; // variable-sized array
};

#endif // SVM_SHARED_STRUCTS_HPP
