/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.flow;

import com.oracle.graal.pointsto.PointsToAnalysis;
import com.oracle.graal.pointsto.api.PointstoOptions;
import com.oracle.graal.pointsto.flow.FormalReturnTypeFlow;
import com.oracle.graal.pointsto.flow.InvokeTypeFlow;
import com.oracle.graal.pointsto.flow.MethodFlowsGraph;
import com.oracle.graal.pointsto.flow.MethodFlowsGraphClone;
import com.oracle.graal.pointsto.flow.MethodFlowsGraphInfo;
import com.oracle.graal.pointsto.flow.MethodTypeFlow;
import com.oracle.graal.pointsto.flow.TypeFlow;
import com.oracle.graal.pointsto.flow.context.AnalysisContext;
import com.oracle.graal.pointsto.flow.context.bytecode.BytecodeAnalysisContext;
import com.oracle.graal.pointsto.flow.context.bytecode.BytecodeAnalysisContextPolicy;
import com.oracle.graal.pointsto.flow.context.bytecode.BytecodeSensitiveAnalysisPolicy;
import com.oracle.graal.pointsto.meta.PointsToAnalysisMethod;
import com.oracle.graal.pointsto.typestate.TypeState;
import com.oracle.graal.pointsto.util.AnalysisError;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.graalvm.compiler.options.OptionValues;

public class CallSiteSensitiveMethodTypeFlow
extends MethodTypeFlow {
    private final ConcurrentMap<AnalysisContext, MethodFlowsGraph> clonedMethodFlows;
    private final int localCallingContextDepth;

    public CallSiteSensitiveMethodTypeFlow(OptionValues options, PointsToAnalysisMethod method) {
        super(method);
        this.localCallingContextDepth = (Integer)PointstoOptions.MaxCallingContextDepth.getValue(options);
        this.clonedMethodFlows = new ConcurrentHashMap<AnalysisContext, MethodFlowsGraph>(4, 0.75f, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MethodFlowsGraphInfo addContext(PointsToAnalysis bb, AnalysisContext calleeContext, InvokeTypeFlow reason) {
        this.ensureFlowsGraphCreated(bb, reason);
        this.flowsGraph.ensureLinearized();
        BytecodeAnalysisContextPolicy contextPolicy = ((BytecodeSensitiveAnalysisPolicy)bb.analysisPolicy()).getContextPolicy();
        BytecodeAnalysisContext newContext = contextPolicy.peel((BytecodeAnalysisContext)calleeContext, this.localCallingContextDepth);
        MethodFlowsGraphClone methodFlows = (MethodFlowsGraphClone)this.clonedMethodFlows.get(newContext);
        if (methodFlows == null) {
            CallSiteSensitiveMethodTypeFlow callSiteSensitiveMethodTypeFlow = this;
            synchronized (callSiteSensitiveMethodTypeFlow) {
                methodFlows = (MethodFlowsGraphClone)this.clonedMethodFlows.computeIfAbsent(newContext, k -> {
                    MethodFlowsGraphClone newFlows = new MethodFlowsGraphClone(this.method, this.flowsGraph, newContext);
                    newFlows.cloneOriginalFlows(bb);
                    newFlows.linkCloneFlows(bb);
                    if (this.flowsGraph.method.getReturnsAllInstantiatedTypes()) {
                        FormalReturnTypeFlow newReturnFlow = newFlows.getReturnFlow();
                        newReturnFlow.getDeclaredType().getTypeFlow(bb, true).addUse(bb, newReturnFlow);
                    }
                    return newFlows;
                });
            }
        }
        return methodFlows;
    }

    @Override
    protected void initFlowsGraph(PointsToAnalysis bb, List<TypeFlow<?>> postInitFlows) {
    }

    public int getLocalCallingContextDepth() {
        return this.localCallingContextDepth;
    }

    @Override
    public Collection<MethodFlowsGraph> getFlows() {
        this.ensureFlowsGraphSealed();
        return this.clonedMethodFlows.values();
    }

    @Override
    public TypeState foldTypeFlow(PointsToAnalysis bb, TypeFlow<?> originalTypeFlow) {
        if (originalTypeFlow == null) {
            return null;
        }
        TypeState result = TypeState.forEmpty();
        for (MethodFlowsGraph methodFlows : this.clonedMethodFlows.values()) {
            TypeFlow<?> clonedTypeFlow = methodFlows.lookupCloneOf(bb, originalTypeFlow);
            TypeState cloneState = clonedTypeFlow.getState();
            TypeState cloneStateCopy = bb.analysisPolicy().forContextInsensitiveTypeState(bb, cloneState);
            result = TypeState.forUnion(bb, result, cloneStateCopy);
        }
        return result;
    }

    @Override
    public boolean isSaturated(PointsToAnalysis bb, TypeFlow<?> originalTypeFlow) {
        boolean saturated = false;
        for (MethodFlowsGraph methodFlows : this.clonedMethodFlows.values()) {
            TypeFlow<?> clonedTypeFlow = methodFlows.lookupCloneOf(bb, originalTypeFlow);
            saturated |= clonedTypeFlow.isSaturated();
        }
        return saturated;
    }

    @Override
    public synchronized void setAsStubFlow() {
        AnalysisError.shouldNotReachHere("The code below is untested. We want to keep it as a blueprint of how an implementation looks like. If this code path is reached, it needs to be checked for correctness first.");
        super.setAsStubFlow();
    }

    @Override
    public synchronized boolean updateFlowsGraph(PointsToAnalysis bb, MethodFlowsGraph.GraphKind newGraphKind, InvokeTypeFlow newParsingReason, boolean forceReparse) {
        AnalysisError.shouldNotReachHere("The code below is untested. We want to keep it as a blueprint of how an implementation looks like. If this code path is reached, it needs to be checked for correctness first.");
        boolean updated = super.updateFlowsGraph(bb, newGraphKind, newParsingReason, forceReparse);
        if (updated) {
            this.clonedMethodFlows.forEach((k, clonedFlowsGraph) -> {
                MethodFlowsGraphClone clone = (MethodFlowsGraphClone)clonedFlowsGraph;
                clone.removeInternalFlows(bb);
                clone.recloneOriginalFlows(bb);
                clone.linkCloneFlows(bb);
            });
        }
        return updated;
    }

    @Override
    public String toString() {
        return "CallSiteSensitiveMethodTypeFlow<" + String.valueOf(this.method) + ">";
    }
}

