/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.driver;

import com.oracle.svm.core.util.ExitStatus;
import com.oracle.svm.driver.NativeImage;
import com.sun.management.OperatingSystemMXBean;
import java.lang.management.ManagementFactory;
import java.util.List;

class MemoryUtil {
    private static final long KiB_TO_BYTES = 1024L;
    private static final long MiB_TO_BYTES = 0x100000L;
    private static final long GiB_TO_BYTES = 0x40000000L;
    private static final long MIN_HEAP_BYTES = 0x20000000L;
    private static final long DEDICATED_MODE_THRESHOLD = 0x200000000L;
    private static final double DEDICATED_MODE_TOTAL_MEMORY_RATIO = 0.85;
    private static final long MAX_HEAP_BYTES = 32000000000L;

    MemoryUtil() {
    }

    public static List<String> determineMemoryFlags() {
        return List.of("-XX:MaxRAMPercentage=" + MemoryUtil.determineReasonableMaxRAMPercentage(), "-XX:GCTimeRatio=9", "-XX:+ExitOnOutOfMemoryError");
    }

    private static double determineReasonableMaxRAMPercentage() {
        OperatingSystemMXBean osBean = (OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean();
        double totalMemorySize = osBean.getTotalMemorySize();
        double reasonableMaxMemorySize = osBean.getFreeMemorySize();
        if (reasonableMaxMemorySize < 8.589934592E9) {
            reasonableMaxMemorySize = totalMemorySize * 0.85;
        }
        if (reasonableMaxMemorySize < 5.36870912E8) {
            throw new NativeImage.NativeImageError("There is not enough memory available on the system (got %sMiB, need at least %sMiB). Consider freeing up memory if builds are slow, for example, by closing applications that you do not need.".formatted(reasonableMaxMemorySize / 1048576.0, 512L), null, ExitStatus.OUT_OF_MEMORY.getValue());
        }
        reasonableMaxMemorySize = Math.min(reasonableMaxMemorySize, 3.2E10);
        return reasonableMaxMemorySize / totalMemorySize * 100.0;
    }
}

