/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jipher.internal.key;

import com.oracle.jipher.internal.common.Util;
import com.oracle.jipher.internal.key.JceOsslKey;
import com.oracle.jipher.internal.openssl.DerHelper;
import com.oracle.jipher.internal.openssl.OpenSslException;
import com.oracle.jipher.internal.openssl.Pkey;
import com.oracle.jipher.provider.DHFIPSParameterSpec;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import javax.crypto.interfaces.DHPrivateKey;
import javax.crypto.spec.DHParameterSpec;

public final class JceDhPrivateKey
extends JceOsslKey
implements DHPrivateKey {
    static final String ALG = "DH";
    private final BigInteger priv;
    private final DHParameterSpec params;

    public JceDhPrivateKey(Pkey pkey, BigInteger priv, DHParameterSpec params) {
        super(ALG, pkey);
        this.priv = priv;
        this.params = params;
    }

    public JceDhPrivateKey(Pkey pkey) throws InvalidKeyException {
        super(ALG, pkey);
        byte[] privVal = this.pkey.getDhPrivateKey();
        try {
            this.priv = new BigInteger(1, privVal);
        }
        finally {
            Util.clearArray(privVal);
        }
        byte[][] vals = this.pkey.getDhParams();
        BigInteger p = new BigInteger(1, vals[0]);
        BigInteger g = new BigInteger(1, vals[2]);
        this.params = vals[1] == null ? new DHParameterSpec(p, g) : new DHFIPSParameterSpec(p, new BigInteger(1, vals[1]), g);
    }

    @Override
    public BigInteger getX() {
        return this.priv;
    }

    @Override
    public DHParameterSpec getParams() {
        return this.params;
    }

    @Override
    public void destroy() {
        this.pkey.free();
    }

    @Override
    byte[] derEncode() throws InvalidKeyException {
        try {
            return DerHelper.privDerEncode(this.pkey);
        }
        catch (OpenSslException e) {
            throw new InvalidKeyException(e);
        }
    }
}

