/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.enterprise.configure.command;

import com.oracle.svm.configure.ConfigurationUsageException;
import com.oracle.svm.configure.command.ConfigurationCommand;
import com.oracle.svm.enterprise.profiling.loaders.ProfilingDetachedLoader;
import com.oracle.svm.enterprise.profiling.profiles.ProfilingBaseProfile;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.graalvm.compiler.nodes.ProfileData;

public final class ConfigurationMergePGOProfilesCommand
extends ConfigurationCommand {
    public String getName() {
        return "merge-pgo-profiles";
    }

    public void apply(Iterator<String> argumentsIterator) throws IOException {
        URI outputFilePath = null;
        HashSet<URI> inputFilePaths = new HashSet<URI>();
        long normalizationValue = 0L;
        block17: while (argumentsIterator.hasNext()) {
            String argument = argumentsIterator.next();
            String[] optionValue = argument.split("=");
            if (optionValue.length != 2) {
                throw new ConfigurationUsageException(String.format("Format is not valid: %s. Options should be in format --<option>=<value>. ", argument));
            }
            String option = optionValue[0];
            String value = optionValue[1];
            switch (option) {
                case "--input-dir": {
                    Path inputDir = ConfigurationMergePGOProfilesCommand.requirePath((String)option, (String)value);
                    File dir = new File(inputDir.toUri());
                    if (!Files.isDirectory(inputDir, new LinkOption[0])) {
                        throw new ConfigurationUsageException("--input-dir expects a path to a directory, but file path is given: " + String.valueOf(inputDir) + ". Please use a directory path or use --input-file to select a path to a file.");
                    }
                    File[] files = dir.listFiles();
                    assert (files != null);
                    for (File inputFile : files) {
                        if (!inputFile.getName().endsWith(".iprof")) continue;
                        inputFilePaths.add(inputFile.toURI());
                    }
                    continue block17;
                }
                case "--output-file": {
                    outputFilePath = ConfigurationMergePGOProfilesCommand.getOrCreateFile((String)option, (String)value).toUri();
                    break;
                }
                case "--input-file": {
                    Path inputFile = ConfigurationMergePGOProfilesCommand.requirePath((String)option, (String)value);
                    if (!Files.isRegularFile(inputFile, new LinkOption[0])) {
                        throw new ConfigurationUsageException("Cannot find input file: " + String.valueOf(inputFile));
                    }
                    inputFilePaths.add(inputFile.toUri());
                    break;
                }
                case "--normalization-value": {
                    normalizationValue = Long.parseLong(value);
                    break;
                }
                default: {
                    throw new ConfigurationUsageException("Unknown option: " + option);
                }
            }
        }
        if (inputFilePaths.isEmpty()) {
            throw new ConfigurationUsageException("An input file is not specified. Please specify the input file(s) using --input-file option.");
        }
        if (outputFilePath == null) {
            throw new ConfigurationUsageException("An output file is not specified. Please specify the output file using --output-file option.");
        }
        ProfilingDetachedLoader loader = new ProfilingDetachedLoader();
        Path outputPath = Path.of(outputFilePath);
        List inputPaths = inputFilePaths.stream().map(Path::of).collect(Collectors.toList());
        ProfilingBaseProfile profile = loader.loadProfile(inputPaths, normalizationValue, ProfileData.ProfileSource.UNKNOWN);
        try (FileOutputStream stream = new FileOutputStream(outputPath.toFile());){
            profile.dump((OutputStream)stream);
        }
    }

    protected String getDescription0() {
        return "        combine multiple profile files into a single one.\n    --input-dir=<path>\n                          reads all profiles (*.iprof) stored in <path> directory (not subdirectories).\n    --output-file=<path>\n                          specifies a file to which the merged profiles are written.\n    --input-file=<path>\n                          reads a profile (*.iprof) from given <path>.\n".replaceAll("\n", System.lineSeparator());
    }
}

