/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.enterprise.buildreport.data;

import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.svm.core.SubstrateControlFlowIntegrity;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.core.util.json.JsonWriter;
import com.oracle.svm.enterprise.hosted.h;
import com.oracle.svm.enterprise.hosted.pgo.d;
import com.oracle.svm.enterprise.hosted.pgo.features.PGOFeature;
import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.hosted.HeapBreakdownProvider;
import com.oracle.svm.hosted.Log4ShellFeature;
import com.oracle.svm.hosted.ProgressReporter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.file.Path;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import org.graalvm.compiler.api.replacements.Fold;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.hosted.Feature;

@Platforms(value={Platform.HOSTED_ONLY.class})
public final class a {
    private final Map<Integer, com.oracle.svm.enterprise.buildreport.data.elements.b> k = new HashMap<Integer, com.oracle.svm.enterprise.buildreport.data.elements.b>();
    private final Map<Integer, com.oracle.svm.enterprise.buildreport.data.elements.a> l = new HashMap<Integer, com.oracle.svm.enterprise.buildreport.data.elements.a>();
    private final b m = new b(){

        @Override
        public boolean f() {
            return h.f();
        }

        @Override
        public h.b g() {
            return ImageSingletons.contains(h.b.class) ? (h.b)ImageSingletons.lookup(h.b.class) : null;
        }

        @Override
        public boolean h() {
            return SubstrateControlFlowIntegrity.enabled();
        }

        @Override
        public String i() {
            return ImageSingletons.contains(Log4ShellFeature.class) ? ((Log4ShellFeature)ImageSingletons.lookup(Log4ShellFeature.class)).getUserWarning() : null;
        }
    };
    private a n = new a(){

        @Override
        public long j() {
            return HeapBreakdownProvider.singleton().getTotalHeapSize();
        }

        @Override
        public List<HeapBreakdownProvider.HeapBreakdownEntry> k() {
            return HeapBreakdownProvider.singleton().getSortedBreakdownEntries();
        }
    };
    private String o;

    @Fold
    public static a instance() {
        return (a)ImageSingletons.lookup(a.class);
    }

    public static void a(a a2) {
        if (!ImageSingletons.contains(a.class)) {
            return;
        }
        a.instance().n = a2;
    }

    public void a(Feature.BeforeCompilationAccess beforeCompilationAccess) {
        ((FeatureImpl.BeforeCompilationAccessImpl)beforeCompilationAccess).getUniverse().getMethods().forEach(hostedMethod -> {
            int n2;
            Object object;
            AnalysisMethod analysisMethod = hostedMethod.getWrapped();
            if (analysisMethod.isReachable()) {
                object = new com.oracle.svm.enterprise.buildreport.data.elements.a(analysisMethod);
                this.l.put(analysisMethod.getId(), (com.oracle.svm.enterprise.buildreport.data.elements.a)object);
            }
            if (!this.k.containsKey(n2 = (object = analysisMethod.getDeclaringClass()).getId())) {
                this.k.put(n2, new com.oracle.svm.enterprise.buildreport.data.elements.b((AnalysisType)object));
            }
        });
    }

    public void d() {
        try {
            d d2 = (d)ImageSingletons.lookup(d.class);
            List<Path> list = PGOFeature.getProfileFiles();
            StringJoiner stringJoiner = new StringJoiner(", ");
            if (list != null) {
                for (Path path : list) {
                    stringJoiner.add(com.oracle.svm.enterprise.buildreport.a.a.relativize(path).toString());
                }
            }
            this.o = com.oracle.svm.enterprise.buildreport.flamegraph.a.a(d2, stringJoiner.toString());
        }
        catch (IOException | IllegalStateException exception) {
            throw VMError.shouldNotReachHere((String)"Failed to generate flame graph for build report", (Throwable)exception);
        }
    }

    public String e() throws IOException {
        StringWriter stringWriter = new StringWriter();
        JsonWriter jsonWriter = new JsonWriter((Writer)stringWriter);
        jsonWriter.append("var data=");
        this.a(jsonWriter);
        jsonWriter.append(";");
        return stringWriter.toString();
    }

    public void a(JsonWriter jsonWriter) throws IOException {
        jsonWriter.appendObjectStart();
        jsonWriter.appendKeyValue("name", SubstrateOptions.Name.getValue()).appendSeparator();
        jsonWriter.appendKeyValue("datetime", (Object)new SimpleDateFormat("yyyy/MM/dd HH:mm:ss").format(new Date())).appendSeparator();
        a.b(jsonWriter);
        jsonWriter.appendSeparator();
        this.c(jsonWriter);
        jsonWriter.appendSeparator();
        this.d(jsonWriter);
        jsonWriter.appendSeparator();
        this.e(jsonWriter);
        jsonWriter.appendSeparator();
        this.f(jsonWriter);
        jsonWriter.appendSeparator();
        a.h(jsonWriter);
        jsonWriter.appendSeparator();
        this.i(jsonWriter);
        jsonWriter.appendObjectEnd();
        jsonWriter.flush();
    }

    private static void b(JsonWriter jsonWriter) throws IOException {
        jsonWriter.quote("buildOutput").appendFieldSeparator();
        ProgressReporter.singleton().jsonHelper.print(jsonWriter);
    }

    private void c(JsonWriter jsonWriter) throws IOException {
        jsonWriter.quote("securityReport").appendFieldSeparator().appendObjectStart();
        jsonWriter.appendKeyValue("deserialization", (Object)this.m.f()).appendSeparator();
        h.b b2 = this.m.g();
        if (b2 != null) {
            jsonWriter.quote("sbomStatistics").appendFieldSeparator().appendObjectStart();
            jsonWriter.appendKeyValue("numberOfComponents", (Object)b2.dr()).appendSeparator();
            jsonWriter.appendKeyValue("embeddedByteSize", (Object)b2.dq());
            jsonWriter.appendObjectEnd();
            jsonWriter.appendSeparator();
        }
        jsonWriter.appendKeyValue("controlFlowIntegrity", (Object)this.m.h()).appendSeparator();
        jsonWriter.appendKeyValue("log4Warning", (Object)this.m.i());
        jsonWriter.appendObjectEnd();
    }

    private void d(JsonWriter jsonWriter) throws IOException {
        jsonWriter.quote("types").appendFieldSeparator().appendArrayStart();
        ArrayList<com.oracle.svm.enterprise.buildreport.data.elements.b> arrayList = new ArrayList<com.oracle.svm.enterprise.buildreport.data.elements.b>(this.k.values());
        for (int i2 = 0; i2 < arrayList.size(); ++i2) {
            ((com.oracle.svm.enterprise.buildreport.data.elements.b)arrayList.get(i2)).j(jsonWriter);
            if (i2 >= arrayList.size() - 1) continue;
            jsonWriter.appendSeparator();
        }
        jsonWriter.appendArrayEnd();
    }

    private void e(JsonWriter jsonWriter) throws IOException {
        jsonWriter.quote("methods").appendFieldSeparator().appendArrayStart();
        ArrayList<com.oracle.svm.enterprise.buildreport.data.elements.a> arrayList = new ArrayList<com.oracle.svm.enterprise.buildreport.data.elements.a>(this.l.values());
        for (int i2 = 0; i2 < arrayList.size(); ++i2) {
            ((com.oracle.svm.enterprise.buildreport.data.elements.a)arrayList.get(i2)).j(jsonWriter);
            if (i2 >= arrayList.size() - 1) continue;
            jsonWriter.appendSeparator();
        }
        jsonWriter.appendArrayEnd();
    }

    private void f(JsonWriter jsonWriter) throws IOException {
        jsonWriter.quote("heap").appendFieldSeparator().appendObjectStart();
        jsonWriter.appendKeyValue("total", (Object)this.n.j()).appendSeparator();
        this.g(jsonWriter);
        jsonWriter.appendObjectEnd();
    }

    private void g(JsonWriter jsonWriter) throws IOException {
        jsonWriter.quote("items").appendFieldSeparator().appendArrayStart();
        c c2 = new c();
        Iterator<HeapBreakdownProvider.HeapBreakdownEntry> iterator = this.n.k().iterator();
        while (iterator.hasNext()) {
            HeapBreakdownProvider.HeapBreakdownEntry heapBreakdownEntry = iterator.next();
            jsonWriter.appendObjectStart();
            jsonWriter.appendKeyValue("name", (Object)heapBreakdownEntry.getLabel().renderToString((ProgressReporter.LinkStrategy)c2)).appendSeparator();
            jsonWriter.appendKeyValue("count", (Object)heapBreakdownEntry.getCount()).appendSeparator();
            jsonWriter.appendKeyValue("size", (Object)heapBreakdownEntry.getByteSize());
            jsonWriter.appendObjectEnd();
            if (!iterator.hasNext()) continue;
            jsonWriter.appendSeparator();
        }
        jsonWriter.appendArrayEnd();
    }

    private static void h(JsonWriter jsonWriter) throws IOException {
        if (!ImageSingletons.contains(com.oracle.svm.enterprise.sbom.c.class)) {
            return;
        }
        com.oracle.svm.enterprise.sbom.c c2 = (com.oracle.svm.enterprise.sbom.c)ImageSingletons.lookup(com.oracle.svm.enterprise.sbom.c.class);
        String string = new com.oracle.svm.enterprise.sbom.b().a(c2.hS());
        jsonWriter.quote("sbom").appendFieldSeparator();
        jsonWriter.append(string);
    }

    private void i(JsonWriter jsonWriter) throws IOException {
        if (this.o == null) {
            return;
        }
        jsonWriter.appendKeyValue("samplerOutput", (Object)Base64.getEncoder().encodeToString(this.o.getBytes()));
    }

    public static interface b {
        public boolean f();

        public h.b g();

        public boolean h();

        public String i();
    }

    public static interface a {
        public List<HeapBreakdownProvider.HeapBreakdownEntry> k();

        public long j();
    }

    private static final class c
    implements ProgressReporter.LinkStrategy {
        static final String r = "<a href=\"%s\" target=\"_blank\">%s</a>";

        private c() {
        }

        public void link(ProgressReporter.AbstractPrinter<?> abstractPrinter, String string, String string2) {
            abstractPrinter.a("<a href=\"" + string2 + "\" target=\"_blank\">").a(string).a("</a>");
        }

        public String asDocLink(String string, String string2) {
            return String.format(r, "https://github.com/oracle/graal/blob/master/docs/reference-manual/native-image/BuildOutput.md" + string2, string);
        }
    }
}

