/*
 * Decompiled with CFR 0.152.
 */
package ai.onnxruntime;

import ai.onnxruntime.OnnxJavaType;
import java.lang.reflect.Array;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import java.util.ArrayList;
import java.util.Arrays;

public final class OrtUtil {
    private OrtUtil() {
    }

    public static int[] transformShape(long[] lArray) {
        if (lArray.length == 0 || lArray.length > 8) {
            throw new IllegalArgumentException("Arrays with less than 1 and greater than 8 dimensions are not supported.");
        }
        int[] nArray = new int[lArray.length];
        for (int i2 = 0; i2 < lArray.length; ++i2) {
            long l2 = lArray[i2];
            if (l2 < 1L || l2 > Integer.MAX_VALUE) {
                throw new IllegalArgumentException("Invalid shape for a Java array, expected positive entries smaller than Integer.MAX_VALUE. Found " + Arrays.toString(lArray));
            }
            nArray[i2] = (int)l2;
        }
        return nArray;
    }

    public static long[] transformShape(int[] nArray) {
        if (nArray.length == 0 || nArray.length > 8) {
            throw new IllegalArgumentException("Arrays with less than 1 and greater than 8 dimensions are not supported.");
        }
        long[] lArray = new long[nArray.length];
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            long l2 = nArray[i2];
            if (l2 < 1L) {
                throw new IllegalArgumentException("Invalid shape for a Java array, expected positive entries smaller than Integer.MAX_VALUE. Found " + Arrays.toString(nArray));
            }
            lArray[i2] = l2;
        }
        return lArray;
    }

    public static Object newBooleanArray(long[] lArray) {
        int[] nArray = OrtUtil.transformShape(lArray);
        return Array.newInstance(Boolean.TYPE, nArray);
    }

    public static Object newByteArray(long[] lArray) {
        int[] nArray = OrtUtil.transformShape(lArray);
        return Array.newInstance(Byte.TYPE, nArray);
    }

    public static Object newShortArray(long[] lArray) {
        int[] nArray = OrtUtil.transformShape(lArray);
        return Array.newInstance(Short.TYPE, nArray);
    }

    public static Object newIntArray(long[] lArray) {
        int[] nArray = OrtUtil.transformShape(lArray);
        return Array.newInstance(Integer.TYPE, nArray);
    }

    public static Object newLongArray(long[] lArray) {
        int[] nArray = OrtUtil.transformShape(lArray);
        return Array.newInstance(Long.TYPE, nArray);
    }

    public static Object newFloatArray(long[] lArray) {
        int[] nArray = OrtUtil.transformShape(lArray);
        return Array.newInstance(Float.TYPE, nArray);
    }

    public static Object newDoubleArray(long[] lArray) {
        int[] nArray = OrtUtil.transformShape(lArray);
        return Array.newInstance(Double.TYPE, nArray);
    }

    public static Object newStringArray(long[] lArray) {
        int[] nArray = OrtUtil.transformShape(lArray);
        return Array.newInstance(String.class, nArray);
    }

    public static Object reshape(boolean[] blArray, long[] lArray) {
        Object object = OrtUtil.newBooleanArray(lArray);
        OrtUtil.reshape(blArray, object, 0);
        return object;
    }

    public static Object reshape(byte[] byArray, long[] lArray) {
        Object object = OrtUtil.newByteArray(lArray);
        OrtUtil.reshape(byArray, object, 0);
        return object;
    }

    public static Object reshape(short[] sArray, long[] lArray) {
        Object object = OrtUtil.newShortArray(lArray);
        OrtUtil.reshape(sArray, object, 0);
        return object;
    }

    public static Object reshape(int[] nArray, long[] lArray) {
        Object object = OrtUtil.newIntArray(lArray);
        OrtUtil.reshape(nArray, object, 0);
        return object;
    }

    public static Object reshape(long[] lArray, long[] lArray2) {
        Object object = OrtUtil.newLongArray(lArray2);
        OrtUtil.reshape(lArray, object, 0);
        return object;
    }

    public static Object reshape(float[] fArray, long[] lArray) {
        Object object = OrtUtil.newFloatArray(lArray);
        OrtUtil.reshape(fArray, object, 0);
        return object;
    }

    public static Object reshape(double[] dArray, long[] lArray) {
        Object object = OrtUtil.newDoubleArray(lArray);
        OrtUtil.reshape(dArray, object, 0);
        return object;
    }

    public static Object reshape(String[] stringArray, long[] lArray) {
        Object object = OrtUtil.newStringArray(lArray);
        OrtUtil.reshape(stringArray, object, 0);
        return object;
    }

    private static int reshape(Object object, Object object2, int n2) {
        if (object2.getClass().isArray()) {
            Object[] objectArray;
            for (Object object3 : objectArray = (Object[])object2) {
                Class<?> clazz = object3.getClass();
                if (clazz.isArray()) {
                    Class<?> clazz2 = clazz.getComponentType();
                    if (clazz2.isPrimitive() || clazz2 == String.class) {
                        int n3 = Array.getLength(object3);
                        System.arraycopy(object, n2, object3, 0, n3);
                        n2 += n3;
                        continue;
                    }
                    n2 = OrtUtil.reshape(object, object3, n2);
                    continue;
                }
                throw new IllegalStateException("Found element type when expecting an array. Class " + clazz);
            }
        } else {
            throw new IllegalStateException("Found element type when expecting an array. Class " + object2.getClass());
        }
        return n2;
    }

    public static long elementCount(long[] lArray) {
        long l2 = 1L;
        for (int i2 = 0; i2 < lArray.length; ++i2) {
            if (lArray[i2] > 0L) {
                l2 *= lArray[i2];
                continue;
            }
            throw new IllegalArgumentException("Received non-positive value in shape " + Arrays.toString(lArray) + " .");
        }
        return l2;
    }

    public static boolean validateShape(long[] lArray) {
        boolean bl2 = true;
        for (int i2 = 0; i2 < lArray.length; ++i2) {
            bl2 &= lArray[i2] > 0L;
            bl2 &= (long)((int)lArray[i2]) == lArray[i2];
        }
        return bl2 && lArray.length <= 8;
    }

    public static String[] flattenString(Object object) {
        if (object instanceof String[]) {
            return (String[])object;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        OrtUtil.flattenString((Object[])object, arrayList);
        return arrayList.toArray(new String[0]);
    }

    private static void flattenString(Object[] objectArray, ArrayList<String> arrayList) {
        for (Object object : objectArray) {
            Class<?> clazz = object.getClass();
            if (clazz.isArray()) {
                if (clazz.getComponentType().isArray()) {
                    OrtUtil.flattenString((Object[])object, arrayList);
                    continue;
                }
                if (clazz.getComponentType().equals(String.class)) {
                    arrayList.addAll(Arrays.asList((String[])object));
                    continue;
                }
                throw new IllegalStateException("Found a non-String, non-array element type, " + clazz);
            }
            throw new IllegalStateException("Found an element type where there should have been an array. Class = " + clazz);
        }
    }

    static Object convertBoxedPrimitiveToArray(OnnxJavaType onnxJavaType, Object object) {
        switch (onnxJavaType) {
            case FLOAT: {
                float[] fArray = new float[]{((Float)object).floatValue()};
                return fArray;
            }
            case DOUBLE: {
                double[] dArray = new double[]{(Double)object};
                return dArray;
            }
            case UINT8: 
            case INT8: {
                byte[] byArray = new byte[]{(Byte)object};
                return byArray;
            }
            case INT16: {
                short[] sArray = new short[]{(Short)object};
                return sArray;
            }
            case INT32: {
                int[] nArray = new int[]{(Integer)object};
                return nArray;
            }
            case INT64: {
                long[] lArray = new long[]{(Long)object};
                return lArray;
            }
            case BOOL: {
                boolean[] blArray = new boolean[]{(Boolean)object};
                return blArray;
            }
        }
        return null;
    }

    static int capacityFromSize(int n2) {
        return (int)((double)n2 / 0.75 + 1.0);
    }

    static BufferTuple prepareBuffer(Buffer buffer, OnnxJavaType onnxJavaType) {
        int n2;
        Buffer buffer2;
        long l2 = (long)buffer.remaining() * (long)onnxJavaType.size;
        if (l2 > (long)(Integer.MAX_VALUE - 8 * onnxJavaType.size)) {
            throw new IllegalStateException("Cannot allocate a direct buffer of the requested size and type, size " + buffer.remaining() + ", type = " + (Object)((Object)onnxJavaType));
        }
        int n3 = buffer.remaining() * onnxJavaType.size;
        if (buffer.isDirect()) {
            buffer2 = buffer;
            n2 = buffer.position() * onnxJavaType.size;
        } else {
            int n4 = buffer.position();
            ByteBuffer byteBuffer = ByteBuffer.allocateDirect(n3).order(ByteOrder.nativeOrder());
            switch (onnxJavaType) {
                case FLOAT: {
                    buffer2 = byteBuffer.asFloatBuffer().put((FloatBuffer)buffer);
                    break;
                }
                case DOUBLE: {
                    buffer2 = byteBuffer.asDoubleBuffer().put((DoubleBuffer)buffer);
                    break;
                }
                case UINT8: 
                case INT8: {
                    buffer2 = byteBuffer.put((ByteBuffer)buffer);
                    break;
                }
                case INT16: {
                    buffer2 = byteBuffer.asShortBuffer().put((ShortBuffer)buffer);
                    break;
                }
                case INT32: {
                    buffer2 = byteBuffer.asIntBuffer().put((IntBuffer)buffer);
                    break;
                }
                case INT64: {
                    buffer2 = byteBuffer.asLongBuffer().put((LongBuffer)buffer);
                    break;
                }
                default: {
                    throw new IllegalStateException("Impossible to reach here, managed to cast a buffer as an incorrect type");
                }
            }
            buffer.position(n4);
            buffer2.rewind();
            n2 = 0;
        }
        return new BufferTuple(buffer2, n2, n3, buffer.remaining(), buffer2 != buffer);
    }

    static final class BufferTuple {
        final Buffer data;
        final int pos;
        final long byteSize;
        final long size;
        final boolean isCopy;

        BufferTuple(Buffer buffer, int n2, long l2, long l3, boolean bl2) {
            this.data = buffer;
            this.pos = n2;
            this.byteSize = l2;
            this.size = l3;
            this.isCopy = bl2;
        }
    }
}

