/*
 * Decompiled with CFR 0.152.
 */
package ai.onnxruntime;

import ai.onnxruntime.OnnxRuntime;
import ai.onnxruntime.OrtException;
import ai.onnxruntime.OrtProvider;
import java.io.IOException;

public abstract class OrtProviderOptions
implements AutoCloseable {
    protected final long nativeHandle;

    protected OrtProviderOptions(long l2) {
        this.nativeHandle = l2;
    }

    protected static long getApiHandle() {
        return OnnxRuntime.ortApiHandle;
    }

    public abstract OrtProvider getProvider();

    @Override
    public void close() {
        this.close(OnnxRuntime.ortApiHandle, this.nativeHandle);
    }

    protected abstract void close(long var1, long var3);

    protected static long loadLibraryAndCreate(OrtProvider ortProvider, OrtProviderSupplier ortProviderSupplier) throws OrtException {
        switch (ortProvider) {
            case CUDA: {
                if (OnnxRuntime.extractCUDA()) break;
                throw new OrtException(OrtException.OrtErrorCode.ORT_EP_FAIL, "Failed to find CUDA shared provider");
            }
            case DNNL: {
                if (OnnxRuntime.extractDNNL()) break;
                throw new OrtException(OrtException.OrtErrorCode.ORT_EP_FAIL, "Failed to find DNNL shared provider");
            }
            case OPEN_VINO: {
                if (OnnxRuntime.extractOpenVINO()) break;
                throw new OrtException(OrtException.OrtErrorCode.ORT_EP_FAIL, "Failed to find OpenVINO shared provider");
            }
            case ROCM: {
                if (OnnxRuntime.extractROCM()) break;
                throw new OrtException(OrtException.OrtErrorCode.ORT_EP_FAIL, "Failed to find ROCm shared provider");
            }
            case TENSOR_RT: {
                if (OnnxRuntime.extractTensorRT()) break;
                throw new OrtException(OrtException.OrtErrorCode.ORT_EP_FAIL, "Failed to find TensorRT shared provider");
            }
        }
        return ortProviderSupplier.create();
    }

    static {
        try {
            OnnxRuntime.init();
        }
        catch (IOException iOException) {
            throw new RuntimeException("Failed to load onnx-runtime library", iOException);
        }
    }

    @FunctionalInterface
    public static interface OrtProviderSupplier {
        public long create() throws OrtException;
    }
}

