/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.graal.hosted;

import com.oracle.graal.pointsto.constraints.UnsupportedFeatureException;
import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.meta.AnalysisUniverse;
import com.oracle.svm.common.meta.MultiMethod;
import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.graal.nodes.SubstrateFieldLocationIdentity;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.option.HostedOptionKey;
import com.oracle.svm.core.util.HostedStringDeduplication;
import com.oracle.svm.core.util.ObservableImageHeapMapProvider;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.graal.SubstrateGraalRuntime;
import com.oracle.svm.graal.hosted.SubstrateProviders;
import com.oracle.svm.graal.meta.SubstrateField;
import com.oracle.svm.graal.meta.SubstrateMethod;
import com.oracle.svm.graal.meta.SubstrateSignature;
import com.oracle.svm.graal.meta.SubstrateType;
import com.oracle.svm.graal.meta.SubstrateUniverseFactory;
import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.hosted.SVMHost;
import com.oracle.svm.hosted.ameta.AnalysisConstantFieldProvider;
import com.oracle.svm.hosted.ameta.AnalysisConstantReflectionProvider;
import com.oracle.svm.hosted.meta.HostedConstantFieldProvider;
import com.oracle.svm.hosted.meta.HostedField;
import com.oracle.svm.hosted.meta.HostedMethod;
import com.oracle.svm.hosted.meta.HostedType;
import com.oracle.svm.hosted.meta.HostedUniverse;
import com.oracle.svm.util.ReflectionUtil;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import jdk.vm.ci.code.Architecture;
import jdk.vm.ci.hotspot.HotSpotJVMCIRuntime;
import jdk.vm.ci.hotspot.HotSpotObjectConstant;
import jdk.vm.ci.hotspot.HotSpotResolvedJavaField;
import jdk.vm.ci.hotspot.HotSpotResolvedJavaMethod;
import jdk.vm.ci.hotspot.HotSpotResolvedJavaType;
import jdk.vm.ci.hotspot.HotSpotSignature;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaField;
import jdk.vm.ci.meta.JavaMethod;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import jdk.vm.ci.meta.Signature;
import org.graalvm.compiler.api.replacements.SnippetReflectionProvider;
import org.graalvm.compiler.api.runtime.GraalRuntime;
import org.graalvm.compiler.core.common.spi.ForeignCallsProvider;
import org.graalvm.compiler.debug.MetricKey;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.hotspot.GraalHotSpotVMConfig;
import org.graalvm.compiler.hotspot.HotSpotBackendFactory;
import org.graalvm.compiler.hotspot.SnippetResolvedJavaMethod;
import org.graalvm.compiler.hotspot.SnippetResolvedJavaType;
import org.graalvm.compiler.nodes.FieldLocationIdentity;
import org.graalvm.compiler.phases.util.Providers;
import org.graalvm.nativeimage.c.function.RelocatedPointer;
import org.graalvm.nativeimage.hosted.Feature;

public class GraalGraphObjectReplacer
implements Function<Object, Object> {
    private final AnalysisUniverse aUniverse;
    private final ConcurrentMap<AnalysisMethod, SubstrateMethod> methods = ObservableImageHeapMapProvider.create();
    private final ConcurrentMap<AnalysisField, SubstrateField> fields = new ConcurrentHashMap<AnalysisField, SubstrateField>();
    private final ConcurrentMap<FieldLocationIdentity, SubstrateFieldLocationIdentity> fieldLocationIdentities = new ConcurrentHashMap<FieldLocationIdentity, SubstrateFieldLocationIdentity>();
    private final ConcurrentMap<AnalysisType, SubstrateType> types = new ConcurrentHashMap<AnalysisType, SubstrateType>();
    private final ConcurrentMap<Signature, SubstrateSignature> signatures = new ConcurrentHashMap<Signature, SubstrateSignature>();
    private final SubstrateProviders sProviders;
    private final SubstrateUniverseFactory universeFactory;
    private SubstrateGraalRuntime sGraalRuntime;
    private final HostedStringDeduplication stringTable;
    private final Field substrateFieldTypeField;
    private final Field substrateFieldDeclaringClassField;
    private final Field dynamicHubMetaTypeField;
    private final Field substrateTypeRawAllInstanceFieldsField;
    private final Class<?> jvmciCleanerClass = ReflectionUtil.lookupClass((boolean)false, (String)"jdk.vm.ci.hotspot.Cleaner");
    private boolean forbidNewTypes = false;
    private FeatureImpl.BeforeAnalysisAccessImpl beforeAnalysisAccess;

    public GraalGraphObjectReplacer(AnalysisUniverse aUniverse, SubstrateProviders sProviders, SubstrateUniverseFactory universeFactory) {
        this.aUniverse = aUniverse;
        this.sProviders = sProviders;
        this.universeFactory = universeFactory;
        this.stringTable = HostedStringDeduplication.singleton();
        this.substrateFieldTypeField = ReflectionUtil.lookupField(SubstrateField.class, (String)"type");
        this.substrateFieldDeclaringClassField = ReflectionUtil.lookupField(SubstrateField.class, (String)"declaringClass");
        this.dynamicHubMetaTypeField = ReflectionUtil.lookupField(DynamicHub.class, (String)"metaType");
        this.substrateTypeRawAllInstanceFieldsField = ReflectionUtil.lookupField(SubstrateType.class, (String)"rawAllInstanceFields");
    }

    public void setGraalRuntime(SubstrateGraalRuntime sGraalRuntime) {
        assert (this.sGraalRuntime == null);
        this.sGraalRuntime = sGraalRuntime;
    }

    public void setAnalysisAccess(FeatureImpl.BeforeAnalysisAccessImpl beforeAnalysisAccess) {
        this.beforeAnalysisAccess = beforeAnalysisAccess;
    }

    @Override
    public Object apply(Object source) {
        if (source == null) {
            return null;
        }
        Object dest = source;
        if (source instanceof RelocatedPointer) {
            return dest;
        }
        if (source instanceof SnippetResolvedJavaMethod || source instanceof SnippetResolvedJavaType) {
            return source;
        }
        if (source instanceof MetaAccessProvider) {
            dest = this.sProviders.getMetaAccessProvider();
        } else {
            if (source instanceof HotSpotJVMCIRuntime) {
                throw new UnsupportedFeatureException("HotSpotJVMCIRuntime should not appear in the image: " + String.valueOf(source));
            }
            if (source instanceof GraalHotSpotVMConfig) {
                throw new UnsupportedFeatureException("GraalHotSpotVMConfig should not appear in the image: " + String.valueOf(source));
            }
            if (source instanceof HotSpotBackendFactory) {
                HotSpotBackendFactory factory = (HotSpotBackendFactory)source;
                Architecture hostArch = HotSpotJVMCIRuntime.runtime().getHostJVMCIBackend().getTarget().arch;
                if (!factory.getArchitecture().equals(hostArch.getClass())) {
                    throw new UnsupportedFeatureException("Non-host architecture HotSpotBackendFactory should not appear in the image: " + String.valueOf(source));
                }
            } else if (source instanceof GraalRuntime) {
                dest = this.sGraalRuntime;
            } else if (source instanceof AnalysisConstantReflectionProvider) {
                dest = this.sProviders.getConstantReflectionProvider();
            } else if (source instanceof AnalysisConstantFieldProvider) {
                dest = this.sProviders.getConstantFieldProvider();
            } else if (source instanceof ForeignCallsProvider) {
                dest = this.sProviders.getForeignCallsProvider();
            } else if (source instanceof SnippetReflectionProvider) {
                dest = this.sProviders.getSnippetReflectionProvider();
            } else if (source instanceof MetricKey) {
                ((MetricKey)source).getName();
            } else if (source instanceof NodeClass) {
                ((NodeClass)source).shortName();
            } else {
                if (source instanceof HotSpotResolvedJavaMethod) {
                    throw new UnsupportedFeatureException(source.toString());
                }
                if (source instanceof HotSpotResolvedJavaField) {
                    throw new UnsupportedFeatureException(source.toString());
                }
                if (source instanceof HotSpotResolvedJavaType) {
                    throw new UnsupportedFeatureException(source.toString());
                }
                if (source instanceof HotSpotSignature) {
                    throw new UnsupportedFeatureException(source.toString());
                }
                if (source instanceof HotSpotObjectConstant) {
                    throw new UnsupportedFeatureException(source.toString());
                }
                if (source instanceof ResolvedJavaMethod && !(source instanceof SubstrateMethod)) {
                    dest = this.createMethod((ResolvedJavaMethod)source);
                } else if (source instanceof ResolvedJavaField && !(source instanceof SubstrateField)) {
                    dest = this.createField((ResolvedJavaField)source);
                } else if (source instanceof ResolvedJavaType && !(source instanceof SubstrateType)) {
                    dest = this.createType((JavaType)((ResolvedJavaType)source));
                } else if (source instanceof FieldLocationIdentity && !(source instanceof SubstrateFieldLocationIdentity)) {
                    dest = this.createFieldLocationIdentity((FieldLocationIdentity)source);
                }
            }
        }
        assert (dest != null);
        Class<?> destClass = dest.getClass();
        if (this.jvmciCleanerClass.isAssignableFrom(destClass)) {
            throw new UnsupportedFeatureException(this.jvmciCleanerClass.getName() + " objects should not appear in the image: " + String.valueOf(source));
        }
        String className = destClass.getName();
        assert (SubstrateUtil.isBuildingLibgraal() || !className.contains(".hotspot.") || className.contains(".svm.jtt.hotspot.")) : "HotSpot object in image " + className;
        assert (!className.contains(".graal.reachability")) : "Analysis meta object in image " + className;
        assert (!className.contains(".pointsto.meta.")) : "Analysis meta object in image " + className;
        assert (!className.contains(".hosted.meta.")) : "Hosted meta object in image " + className;
        assert (!SubstrateUtil.isBuildingLibgraal() || !className.contains(".svm.hosted.snippets.")) : "Hosted snippet object in image " + className;
        return dest;
    }

    public synchronized SubstrateMethod createMethod(ResolvedJavaMethod original) {
        assert (!(original instanceof SubstrateMethod)) : original;
        AnalysisMethod aMethod = original instanceof AnalysisMethod ? (AnalysisMethod)original : (original instanceof HostedMethod ? ((HostedMethod)original).wrapped : this.aUniverse.lookup((JavaMethod)original));
        aMethod = aMethod.getMultiMethod(MultiMethod.ORIGINAL_METHOD);
        assert (aMethod != null);
        SubstrateMethod sMethod = (SubstrateMethod)this.methods.get(aMethod);
        if (sMethod == null) {
            assert (!(original instanceof HostedMethod)) : "too late to create new method";
            SubstrateMethod newMethod = this.universeFactory.createMethod(aMethod, this.stringTable);
            sMethod = this.methods.putIfAbsent(aMethod, newMethod);
            if (sMethod == null) {
                sMethod = newMethod;
                AnalysisType baseType = aMethod.getDeclaringClass();
                AnalysisMethod baseMethod = aMethod;
                this.beforeAnalysisAccess.registerSubtypeReachabilityHandler((a, reachableSubtype) -> {
                    AnalysisMethod resolvedOverride;
                    AnalysisType subtype = this.beforeAnalysisAccess.getMetaAccess().lookupJavaType(reachableSubtype);
                    if (!subtype.equals((Object)baseType) && (resolvedOverride = subtype.resolveConcreteMethod((ResolvedJavaMethod)baseMethod, null)) != null) {
                        resolvedOverride.registerImplementationInvokedCallback(analysisAccess -> this.createMethod((ResolvedJavaMethod)resolvedOverride));
                    }
                }, baseType.getJavaClass());
                sMethod.setLinks(this.createSignature((Signature)aMethod.getSignature()), this.createType((JavaType)aMethod.getDeclaringClass()));
            }
        }
        return sMethod;
    }

    public synchronized SubstrateField createField(ResolvedJavaField original) {
        AnalysisField aField;
        assert (!(original instanceof SubstrateField)) : original;
        if (original instanceof AnalysisField) {
            aField = (AnalysisField)original;
        } else if (original instanceof HostedField) {
            aField = ((HostedField)original).wrapped;
        } else {
            throw new InternalError(original.toString());
        }
        SubstrateField sField = (SubstrateField)this.fields.get(aField);
        if (sField == null) {
            assert (!(original instanceof HostedField)) : "too late to create new field";
            SubstrateField newField = this.universeFactory.createField(aField, this.stringTable);
            sField = this.fields.putIfAbsent(aField, newField);
            if (sField == null) {
                sField = newField;
                sField.setLinks(this.createType((JavaType)aField.getType()), this.createType((JavaType)aField.getDeclaringClass()));
                this.aUniverse.getHeapScanner().rescanField((Object)sField, this.substrateFieldTypeField);
                this.aUniverse.getHeapScanner().rescanField((Object)sField, this.substrateFieldDeclaringClassField);
            }
        }
        return sField;
    }

    private synchronized SubstrateFieldLocationIdentity createFieldLocationIdentity(FieldLocationIdentity original) {
        assert (!(original instanceof SubstrateFieldLocationIdentity)) : original;
        return this.fieldLocationIdentities.computeIfAbsent(original, id -> new SubstrateFieldLocationIdentity(this.createField(id.getField()), id.isImmutable()));
    }

    public SubstrateField getField(AnalysisField field) {
        return (SubstrateField)this.fields.get(field);
    }

    public boolean removeField(AnalysisField field) {
        return this.fields.remove(field) != null;
    }

    public boolean typeCreated(JavaType original) {
        return this.types.containsKey(GraalGraphObjectReplacer.toAnalysisType(original));
    }

    public void forbidNewTypes() {
        this.forbidNewTypes = true;
    }

    public synchronized SubstrateType createType(JavaType original) {
        assert (!(original instanceof SubstrateType)) : original;
        if (original == null) {
            return null;
        }
        AnalysisType aType = GraalGraphObjectReplacer.toAnalysisType(original);
        SubstrateType sType = (SubstrateType)this.types.get(aType);
        if (sType == null) {
            VMError.guarantee(!this.forbidNewTypes && !(original instanceof HostedType), "Too late to create a new type: %s", aType);
            aType.registerAsReachable((Object)"type reachable from Graal graphs");
            DynamicHub hub = ((SVMHost)this.aUniverse.hostVM()).dynamicHub((ResolvedJavaType)aType);
            SubstrateType newType = new SubstrateType(aType.getJavaKind(), hub);
            sType = this.types.putIfAbsent(aType, newType);
            if (sType == null) {
                sType = newType;
                hub.setMetaType(sType);
                this.aUniverse.getHeapScanner().rescanField((Object)hub, this.dynamicHubMetaTypeField);
                sType.setRawAllInstanceFields(this.createAllInstanceFields((ResolvedJavaType)aType));
                this.aUniverse.getHeapScanner().rescanField((Object)sType, this.substrateTypeRawAllInstanceFieldsField);
                this.createType((JavaType)aType.getSuperclass());
                this.createType((JavaType)aType.getComponentType());
                for (AnalysisType aInterface : aType.getInterfaces()) {
                    this.createType((JavaType)aInterface);
                }
            }
        }
        return sType;
    }

    private static AnalysisType toAnalysisType(JavaType original) {
        if (original instanceof HostedType) {
            return ((HostedType)original).getWrapped();
        }
        if (original instanceof AnalysisType) {
            return (AnalysisType)original;
        }
        throw new InternalError("Unexpected type " + String.valueOf(original));
    }

    private SubstrateField[] createAllInstanceFields(ResolvedJavaType originalType) {
        ResolvedJavaField[] originalFields = originalType.getInstanceFields(true);
        SubstrateField[] sFields = new SubstrateField[originalFields.length];
        for (int idx = 0; idx < originalFields.length; ++idx) {
            sFields[idx] = this.createField(originalFields[idx]);
        }
        return sFields;
    }

    private synchronized SubstrateSignature createSignature(Signature original) {
        SubstrateSignature newSignature;
        assert (!(original instanceof SubstrateSignature)) : original;
        SubstrateSignature sSignature = (SubstrateSignature)this.signatures.get(original);
        if (sSignature == null && (sSignature = this.signatures.putIfAbsent(original, newSignature = new SubstrateSignature())) == null) {
            sSignature = newSignature;
            SubstrateType[] parameterTypes = new SubstrateType[original.getParameterCount(false)];
            for (int index = 0; index < original.getParameterCount(false); ++index) {
                parameterTypes[index] = this.createType(original.getParameterType(index, null));
            }
            sSignature.setTypes(parameterTypes, this.createType(original.getReturnType(null)));
        }
        return sSignature;
    }

    public void setMethodsImplementations() {
        for (Map.Entry entry : this.methods.entrySet()) {
            AnalysisMethod aMethod = (AnalysisMethod)entry.getKey();
            SubstrateMethod sMethod = (SubstrateMethod)entry.getValue();
            AnalysisMethod[] aMethodImplementations = aMethod.getImplementations();
            SubstrateMethod[] implementations = new SubstrateMethod[aMethodImplementations.length];
            int idx = 0;
            for (AnalysisMethod impl : aMethodImplementations) {
                SubstrateMethod sImpl = (SubstrateMethod)this.methods.get(impl);
                VMError.guarantee(sImpl != null, "SubstrateMethod for %s missing.", impl);
                implementations[idx++] = sImpl;
            }
            sMethod.setImplementations(implementations);
        }
    }

    public void updateSubstrateDataAfterCompilation(HostedUniverse hUniverse, Providers providers) {
        List<String> unlinkedTypes;
        if (Options.GuaranteeSubstrateTypesLinked.getValue().booleanValue() && !(unlinkedTypes = this.types.values().stream().filter(sType -> !sType.isLinked()).map(SubstrateType::toString).toList()).isEmpty()) {
            throw VMError.shouldNotReachHere(String.format("Unlinked SubstrateTypes have been created:%n%s", String.join((CharSequence)System.lineSeparator(), unlinkedTypes)));
        }
        for (Map.Entry entry : this.types.entrySet()) {
            AnalysisType aType = (AnalysisType)entry.getKey();
            SubstrateType sType2 = (SubstrateType)entry.getValue();
            if (!hUniverse.contains((JavaType)aType)) continue;
            HostedType hType = hUniverse.lookup((JavaType)aType);
            if (hType.getUniqueConcreteImplementation() != null) {
                sType2.setTypeCheckData(hType.getUniqueConcreteImplementation().getHub());
            }
            if (sType2.getInstanceFieldCount() <= 1) continue;
            sType2.setRawAllInstanceFields(this.createAllInstanceFields(hType));
        }
        for (Map.Entry entry : this.fields.entrySet()) {
            AnalysisField aField = (AnalysisField)entry.getKey();
            SubstrateField sField = (SubstrateField)entry.getValue();
            HostedField hField = hUniverse.lookup((JavaField)aField);
            JavaConstant constantValue = hField.isStatic() && ((HostedConstantFieldProvider)providers.getConstantFieldProvider()).isFinalField(hField, null) ? providers.getConstantReflection().readFieldValue((ResolvedJavaField)hField, null) : null;
            sField.setSubstrateData(hField.getLocation(), hField.isAccessed(), hField.isWritten() || !hField.isValueAvailable(), constantValue);
        }
    }

    public void updateSubstrateDataAfterHeapLayout(HostedUniverse hUniverse) {
        for (Map.Entry entry : this.methods.entrySet()) {
            AnalysisMethod aMethod = (AnalysisMethod)entry.getKey();
            SubstrateMethod sMethod = (SubstrateMethod)entry.getValue();
            HostedMethod hMethod = hUniverse.lookup((JavaMethod)aMethod);
            int vTableIndex = hMethod.hasVTableIndex() ? hMethod.getVTableIndex() : -1;
            sMethod.setSubstrateData(vTableIndex, hMethod.isCodeAddressOffsetValid() ? hMethod.getCodeAddressOffset() : 0, hMethod.getDeoptOffsetInImage());
        }
    }

    public void registerImmutableObjects(Feature.CompilationAccess access) {
        for (SubstrateMethod method : this.methods.values()) {
            access.registerAsImmutable((Object)method);
            access.registerAsImmutable(method.getRawImplementations());
            access.registerAsImmutable((Object)method.getEncodedLineNumberTable());
        }
        for (SubstrateField field : this.fields.values()) {
            access.registerAsImmutable((Object)field);
        }
        for (FieldLocationIdentity fieldLocationIdentity : this.fieldLocationIdentities.values()) {
            access.registerAsImmutable((Object)fieldLocationIdentity);
        }
        for (SubstrateType type : this.types.values()) {
            access.registerAsImmutable((Object)type);
            access.registerAsImmutable((Object)type.getRawAllInstanceFields());
        }
        for (SubstrateSignature signature : this.signatures.values()) {
            access.registerAsImmutable((Object)signature);
            access.registerAsImmutable(signature.getRawParameterTypes());
        }
    }

    public static class Options {
        public static final HostedOptionKey<Boolean> GuaranteeSubstrateTypesLinked = new HostedOptionKey<Boolean>(false);
    }
}

