/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.phases;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.graal.code.SubstrateBackend;
import com.oracle.svm.core.meta.SharedMethod;
import java.lang.reflect.AnnotatedElement;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.nodes.FixedNode;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.ReturnNode;
import org.graalvm.compiler.nodes.SafepointNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.phases.common.LoopSafepointInsertionPhase;
import org.graalvm.compiler.phases.tiers.MidTierContext;
import org.graalvm.nativeimage.AnnotationAccess;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.c.function.CFunction;
import org.graalvm.nativeimage.c.function.InvokeCFunctionPointer;

public class SubstrateSafepointInsertionPhase
extends LoopSafepointInsertionPhase {
    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static boolean needSafepointCheck(ResolvedJavaMethod method) {
        if (Uninterruptible.Utils.isUninterruptible((AnnotatedElement)method)) {
            return false;
        }
        return !AnnotationAccess.isAnnotationPresent((AnnotatedElement)method, CFunction.class) && !AnnotationAccess.isAnnotationPresent((AnnotatedElement)method, InvokeCFunctionPointer.class);
    }

    public static boolean needsSafepointCheck(StructuredGraph graph) {
        SharedMethod method = (SharedMethod)graph.method();
        return method.needSafepointCheck();
    }

    public static void insertMethodEndSafepoints(StructuredGraph graph, MidTierContext context) {
        SharedMethod method = (SharedMethod)graph.method();
        if (!((SubstrateBackend)context.getTargetProvider()).safepointCheckedInEpilogue(method)) {
            for (ReturnNode returnNode : graph.getNodes(ReturnNode.TYPE)) {
                SafepointNode safepointNode = (SafepointNode)graph.add((Node)new SafepointNode());
                graph.addBeforeFixed((FixedNode)returnNode, (FixedWithNextNode)safepointNode);
            }
        }
    }

    protected void run(StructuredGraph graph, MidTierContext context) {
        if (!SubstrateSafepointInsertionPhase.needsSafepointCheck(graph)) {
            return;
        }
        SubstrateSafepointInsertionPhase.insertMethodEndSafepoints(graph, context);
        super.run(graph, context);
    }
}

