/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.c.enums;

import com.oracle.svm.core.Uninterruptible;

public abstract class EnumRuntimeData {
    private static final NullPointerException CACHED_NULL_EXCEPTION = new NullPointerException("null enum object cannot be converted to C enum integer (typically for automatic conversions on return to C code)");
    private final long[] javaToC;

    protected EnumRuntimeData(long[] javaToC) {
        this.javaToC = javaToC;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    protected long convertJavaToCLong(Enum<?> javaValue) {
        if (javaValue == null) {
            throw CACHED_NULL_EXCEPTION;
        }
        return this.javaToC[javaValue.ordinal()];
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    protected int convertJavaToCInt(Enum<?> javaValue) {
        return (int)this.convertJavaToCLong(javaValue);
    }

    protected abstract Enum<?> convertCToJava(long var1);
}

