/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.configure.config;

import com.oracle.svm.configure.ConfigurationBase;
import com.oracle.svm.configure.config.PredefinedClassesConfiguration;
import com.oracle.svm.configure.config.ProxyConfiguration;
import com.oracle.svm.configure.config.ResourceConfiguration;
import com.oracle.svm.configure.config.SerializationConfiguration;
import com.oracle.svm.configure.config.TypeConfiguration;
import com.oracle.svm.configure.config.conditional.ConditionalConfigurationPredicate;
import com.oracle.svm.core.configure.ConfigurationFile;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.core.util.json.JsonPrintable;
import com.oracle.svm.core.util.json.JsonWriter;
import java.io.IOException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;

public class ConfigurationSet {
    private final TypeConfiguration reflectionConfiguration;
    private final TypeConfiguration jniConfiguration;
    private final ResourceConfiguration resourceConfiguration;
    private final ProxyConfiguration proxyConfiguration;
    private final SerializationConfiguration serializationConfiguration;
    private final PredefinedClassesConfiguration predefinedClassesConfiguration;

    public ConfigurationSet(TypeConfiguration reflectionConfiguration, TypeConfiguration jniConfiguration, ResourceConfiguration resourceConfiguration, ProxyConfiguration proxyConfiguration, SerializationConfiguration serializationConfiguration, PredefinedClassesConfiguration predefinedClassesConfiguration) {
        this.reflectionConfiguration = reflectionConfiguration;
        this.jniConfiguration = jniConfiguration;
        this.resourceConfiguration = resourceConfiguration;
        this.proxyConfiguration = proxyConfiguration;
        this.serializationConfiguration = serializationConfiguration;
        this.predefinedClassesConfiguration = predefinedClassesConfiguration;
    }

    public ConfigurationSet(ConfigurationSet other) {
        this(other.reflectionConfiguration.copy(), other.jniConfiguration.copy(), other.resourceConfiguration.copy(), other.proxyConfiguration.copy(), other.serializationConfiguration.copy(), other.predefinedClassesConfiguration.copy());
    }

    public ConfigurationSet() {
        this(new TypeConfiguration("reflection"), new TypeConfiguration("jni"), new ResourceConfiguration(), new ProxyConfiguration(), new SerializationConfiguration(), new PredefinedClassesConfiguration(new Path[0], hash -> false));
    }

    private ConfigurationSet mutate(ConfigurationSet other, Mutator mutator) {
        TypeConfiguration reflectionConfig = mutator.apply(this.reflectionConfiguration, other.reflectionConfiguration);
        TypeConfiguration jniConfig = mutator.apply(this.jniConfiguration, other.jniConfiguration);
        ResourceConfiguration resourceConfig = mutator.apply(this.resourceConfiguration, other.resourceConfiguration);
        ProxyConfiguration proxyConfig = mutator.apply(this.proxyConfiguration, other.proxyConfiguration);
        SerializationConfiguration serializationConfig = mutator.apply(this.serializationConfiguration, other.serializationConfiguration);
        PredefinedClassesConfiguration predefinedClassesConfig = mutator.apply(this.predefinedClassesConfiguration, other.predefinedClassesConfiguration);
        return new ConfigurationSet(reflectionConfig, jniConfig, resourceConfig, proxyConfig, serializationConfig, predefinedClassesConfig);
    }

    public ConfigurationSet copyAndMerge(ConfigurationSet other) {
        return this.mutate(other, ConfigurationBase::copyAndMerge);
    }

    public ConfigurationSet copyAndSubtract(ConfigurationSet other) {
        return this.mutate(other, ConfigurationBase::copyAndSubtract);
    }

    public ConfigurationSet copyAndIntersectWith(ConfigurationSet other) {
        return this.mutate(other, ConfigurationBase::copyAndIntersect);
    }

    public ConfigurationSet filter(ConditionalConfigurationPredicate filter) {
        TypeConfiguration reflectionConfig = (TypeConfiguration)this.reflectionConfiguration.copyAndFilter(filter);
        TypeConfiguration jniConfig = (TypeConfiguration)this.jniConfiguration.copyAndFilter(filter);
        ResourceConfiguration resourceConfig = (ResourceConfiguration)this.resourceConfiguration.copyAndFilter(filter);
        ProxyConfiguration proxyConfig = (ProxyConfiguration)this.proxyConfiguration.copyAndFilter(filter);
        SerializationConfiguration serializationConfig = (SerializationConfiguration)this.serializationConfiguration.copyAndFilter(filter);
        PredefinedClassesConfiguration predefinedClassesConfig = (PredefinedClassesConfiguration)this.predefinedClassesConfiguration.copyAndFilter(filter);
        return new ConfigurationSet(reflectionConfig, jniConfig, resourceConfig, proxyConfig, serializationConfig, predefinedClassesConfig);
    }

    public TypeConfiguration getReflectionConfiguration() {
        return this.reflectionConfiguration;
    }

    public TypeConfiguration getJniConfiguration() {
        return this.jniConfiguration;
    }

    public ResourceConfiguration getResourceConfiguration() {
        return this.resourceConfiguration;
    }

    public ProxyConfiguration getProxyConfiguration() {
        return this.proxyConfiguration;
    }

    public SerializationConfiguration getSerializationConfiguration() {
        return this.serializationConfiguration;
    }

    public PredefinedClassesConfiguration getPredefinedClassesConfiguration() {
        return this.predefinedClassesConfiguration;
    }

    public <T extends ConfigurationBase<T, ?>> T getConfiguration(ConfigurationFile configurationFile) {
        switch (configurationFile) {
            case DYNAMIC_PROXY: {
                return (T)this.proxyConfiguration;
            }
            case RESOURCES: {
                return (T)this.resourceConfiguration;
            }
            case JNI: {
                return (T)this.jniConfiguration;
            }
            case REFLECTION: {
                return (T)this.reflectionConfiguration;
            }
            case SERIALIZATION: {
                return (T)this.serializationConfiguration;
            }
            case PREDEFINED_CLASSES_NAME: {
                return (T)this.predefinedClassesConfiguration;
            }
        }
        throw VMError.shouldNotReachHere((String)("Unsupported configuration in configuration container: " + String.valueOf(configurationFile)));
    }

    public static List<Path> writeConfiguration(Function<ConfigurationFile, Path> configFilePathResolver, Function<ConfigurationFile, JsonPrintable> configSupplier) throws IOException {
        ArrayList<Path> writtenFiles = new ArrayList<Path>();
        for (ConfigurationFile configFile : ConfigurationFile.agentGeneratedFiles()) {
            Path path = configFilePathResolver.apply(configFile);
            writtenFiles.add(path);
            JsonWriter writer = new JsonWriter(path, new OpenOption[0]);
            configSupplier.apply(configFile).printJson(writer);
            writer.newline();
            writer.close();
        }
        return writtenFiles;
    }

    public List<Path> writeConfiguration(Function<ConfigurationFile, Path> configFilePathResolver) throws IOException {
        return ConfigurationSet.writeConfiguration(configFilePathResolver, this::getConfiguration);
    }

    public boolean isEmpty() {
        return this.reflectionConfiguration.isEmpty() && this.jniConfiguration.isEmpty() && this.resourceConfiguration.isEmpty() && this.proxyConfiguration.isEmpty() && this.serializationConfiguration.isEmpty() && this.predefinedClassesConfiguration.isEmpty();
    }

    @FunctionalInterface
    private static interface Mutator {
        public <T extends ConfigurationBase<T, ?>> T apply(T var1, T var2);
    }
}

