// CheckStyle: stop header check
// CheckStyle: stop line length check
// GENERATED CONTENT - DO NOT EDIT
// Source: ClassInitializationOptions.java
package com.oracle.svm.hosted.classinitialization;

import java.util.*;
import org.graalvm.compiler.options.*;
import org.graalvm.compiler.options.OptionType;
import org.graalvm.compiler.options.OptionStability;

public class ClassInitializationOptions_OptionDescriptors implements OptionDescriptors {
    @Override
    public OptionDescriptor get(String value) {
        switch (value) {
        // CheckStyle: stop line length check
        case "AllowDeprecatedInitializeAllClassesAtBuildTime": {
            return OptionDescriptor.create(
                /*name*/ "AllowDeprecatedInitializeAllClassesAtBuildTime",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Instead of abort, only warn if --initialize-at-build-time= is used.",
                /*declaringClass*/ ClassInitializationOptions.class,
                /*fieldName*/ "AllowDeprecatedInitializeAllClassesAtBuildTime",
                /*option*/ ClassInitializationOptions.AllowDeprecatedInitializeAllClassesAtBuildTime,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "AssertInitializationSpecifiedForAllClasses": {
            return OptionDescriptor.create(
                /*name*/ "AssertInitializationSpecifiedForAllClasses",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Assert class initialization is specified for all classes.",
                /*declaringClass*/ ClassInitializationOptions.class,
                /*fieldName*/ "AssertInitializationSpecifiedForAllClasses",
                /*option*/ ClassInitializationOptions.AssertInitializationSpecifiedForAllClasses,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "ClassInitialization": {
            return OptionDescriptor.create(
                /*name*/ "ClassInitialization",
                /*optionType*/ OptionType.User,
                /*optionValueType*/ com.oracle.svm.core.option.LocatableMultiOptionValue.Strings.class,
                /*help*/ "A comma-separated list of classes appended with their initialization strategy (':build_time', ':rerun', or ':run_time')",
                /*declaringClass*/ ClassInitializationOptions.class,
                /*fieldName*/ "ClassInitialization",
                /*option*/ ClassInitializationOptions.ClassInitialization,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "PrintClassInitialization": {
            return OptionDescriptor.create(
                /*name*/ "PrintClassInitialization",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Prints class initialization info for all classes detected by analysis.",
                /*declaringClass*/ ClassInitializationOptions.class,
                /*fieldName*/ "PrintClassInitialization",
                /*option*/ ClassInitializationOptions.PrintClassInitialization,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "SimulateClassInitializer": {
            return OptionDescriptor.create(
                /*name*/ "SimulateClassInitializer",
                /*optionType*/ OptionType.Expert,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Simulate the effects of class initializer at image build time, to avoid class initialization at run time.",
                /*declaringClass*/ ClassInitializationOptions.class,
                /*fieldName*/ "SimulateClassInitializer",
                /*option*/ ClassInitializationOptions.SimulateClassInitializer,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "SimulateClassInitializerCollectAllReasons": {
            return OptionDescriptor.create(
                /*name*/ "SimulateClassInitializerCollectAllReasons",
                /*optionType*/ OptionType.Expert,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Configuration for SimulateClassInitializer: Collect all reasons why a class initializer cannot be simulated.",
                /*declaringClass*/ ClassInitializationOptions.class,
                /*fieldName*/ "SimulateClassInitializerCollectAllReasons",
                /*option*/ ClassInitializationOptions.SimulateClassInitializerCollectAllReasons,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "SimulateClassInitializerMaxAllocatedBytes": {
            return OptionDescriptor.create(
                /*name*/ "SimulateClassInitializerMaxAllocatedBytes",
                /*optionType*/ OptionType.Expert,
                /*optionValueType*/ Integer.class,
                /*help*/ "Configuration for SimulateClassInitializer: Maximum number of bytes allocated in the image heap for each class initializer.",
                /*declaringClass*/ ClassInitializationOptions.class,
                /*fieldName*/ "SimulateClassInitializerMaxAllocatedBytes",
                /*option*/ ClassInitializationOptions.SimulateClassInitializerMaxAllocatedBytes,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "SimulateClassInitializerMaxInlineDepth": {
            return OptionDescriptor.create(
                /*name*/ "SimulateClassInitializerMaxInlineDepth",
                /*optionType*/ OptionType.Expert,
                /*optionValueType*/ Integer.class,
                /*help*/ "Configuration for SimulateClassInitializer: Maximum inlining depth during simulation.",
                /*declaringClass*/ ClassInitializationOptions.class,
                /*fieldName*/ "SimulateClassInitializerMaxInlineDepth",
                /*option*/ ClassInitializationOptions.SimulateClassInitializerMaxInlineDepth,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "SimulateClassInitializerMaxLoopIterations": {
            return OptionDescriptor.create(
                /*name*/ "SimulateClassInitializerMaxLoopIterations",
                /*optionType*/ OptionType.Expert,
                /*optionValueType*/ Integer.class,
                /*help*/ "Configuration for SimulateClassInitializer: Maximum number of loop iterations that are unrolled during simulation.",
                /*declaringClass*/ ClassInitializationOptions.class,
                /*fieldName*/ "SimulateClassInitializerMaxLoopIterations",
                /*option*/ ClassInitializationOptions.SimulateClassInitializerMaxLoopIterations,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "StrictImageHeap": {
            return OptionDescriptor.create(
                /*name*/ "StrictImageHeap",
                /*optionType*/ OptionType.User,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Enable the strict image heap mode that allows all classes to be used at build-time but also requires types of all objects in the heap to be explicitly marked for build-time initialization.",
                /*declaringClass*/ ClassInitializationOptions.class,
                /*fieldName*/ "StrictImageHeap",
                /*option*/ ClassInitializationOptions.StrictImageHeap,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        // CheckStyle: resume line length check
        }
        return null;
    }

    @Override
    public Iterator<OptionDescriptor> iterator() {
        return new Iterator<>() {
            int i = 0;
            @Override
            public boolean hasNext() {
                return i < 10;
            }
            @Override
            public OptionDescriptor next() {
                switch (i++) {
                    case 0: return get("AllowDeprecatedInitializeAllClassesAtBuildTime");
                    case 1: return get("AssertInitializationSpecifiedForAllClasses");
                    case 2: return get("ClassInitialization");
                    case 3: return get("PrintClassInitialization");
                    case 4: return get("SimulateClassInitializer");
                    case 5: return get("SimulateClassInitializerCollectAllReasons");
                    case 6: return get("SimulateClassInitializerMaxAllocatedBytes");
                    case 7: return get("SimulateClassInitializerMaxInlineDepth");
                    case 8: return get("SimulateClassInitializerMaxLoopIterations");
                    case 9: return get("StrictImageHeap");
                }
                throw new NoSuchElementException();
            }
        };
    }
}
