/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.meta;

import com.oracle.graal.pointsto.api.DefaultUnsafePartition;
import com.oracle.graal.pointsto.api.PointstoOptions;
import com.oracle.graal.pointsto.flow.ContextInsensitiveFieldTypeFlow;
import com.oracle.graal.pointsto.flow.FieldTypeFlow;
import com.oracle.graal.pointsto.infrastructure.OriginalFieldProvider;
import com.oracle.graal.pointsto.infrastructure.WrappedJavaField;
import com.oracle.graal.pointsto.meta.AnalysisElement;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.meta.AnalysisUniverse;
import com.oracle.graal.pointsto.meta.FieldValueComputer;
import com.oracle.graal.pointsto.typestate.TypeState;
import com.oracle.graal.pointsto.util.AnalysisFuture;
import com.oracle.graal.pointsto.util.AtomicUtils;
import com.oracle.graal.pointsto.util.ConcurrentLightHashSet;
import com.oracle.svm.util.UnsafePartitionKind;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.compiler.debug.GraalError;

public abstract class AnalysisField
extends AnalysisElement
implements WrappedJavaField,
OriginalFieldProvider {
    private static final AtomicReferenceFieldUpdater<AnalysisField, Object> OBSERVERS_UPDATER = AtomicReferenceFieldUpdater.newUpdater(AnalysisField.class, Object.class, "observers");
    private static final AtomicReferenceFieldUpdater<AnalysisField, Object> isAccessedUpdater = AtomicReferenceFieldUpdater.newUpdater(AnalysisField.class, Object.class, "isAccessed");
    private static final AtomicReferenceFieldUpdater<AnalysisField, Object> isReadUpdater = AtomicReferenceFieldUpdater.newUpdater(AnalysisField.class, Object.class, "isRead");
    private static final AtomicReferenceFieldUpdater<AnalysisField, Object> isWrittenUpdater = AtomicReferenceFieldUpdater.newUpdater(AnalysisField.class, Object.class, "isWritten");
    private static final AtomicReferenceFieldUpdater<AnalysisField, Object> isFoldedUpdater = AtomicReferenceFieldUpdater.newUpdater(AnalysisField.class, Object.class, "isFolded");
    private static final AtomicReferenceFieldUpdater<AnalysisField, Object> isUnsafeAccessedUpdater = AtomicReferenceFieldUpdater.newUpdater(AnalysisField.class, Object.class, "isUnsafeAccessed");
    private static final AtomicIntegerFieldUpdater<AnalysisField> unsafeFrozenTypeStateUpdater = AtomicIntegerFieldUpdater.newUpdater(AnalysisField.class, "unsafeFrozenTypeState");
    private final int id;
    public final ResolvedJavaField wrapped;
    private FieldTypeFlow staticFieldFlow;
    private FieldTypeFlow initialInstanceFieldFlow;
    private ContextInsensitiveFieldTypeFlow instanceFieldFlow;
    private volatile Object isRead;
    private volatile Object isAccessed;
    private volatile Object isWritten;
    private volatile Object isFolded;
    private boolean isJNIAccessed;
    private volatile Object isUnsafeAccessed;
    private volatile int unsafeFrozenTypeState;
    private volatile Object observers;
    private boolean canBeNull;
    private ConcurrentMap<Object, Boolean> readBy;
    private ConcurrentMap<Object, Boolean> writtenBy;
    protected TypeState instanceFieldTypeState;
    protected int position;
    protected final AnalysisType declaringClass;
    protected final AnalysisType fieldType;
    protected final FieldValueComputer fieldValueComputer;

    public AnalysisField(AnalysisUniverse universe, ResolvedJavaField wrappedField) {
        assert (!wrappedField.isInternal());
        this.position = -1;
        this.wrapped = wrappedField;
        this.id = universe.nextFieldId.getAndIncrement();
        boolean trackAccessChain = (Boolean)PointstoOptions.TrackAccessChain.getValue(universe.hostVM().options());
        this.readBy = trackAccessChain ? new ConcurrentHashMap() : null;
        this.writtenBy = trackAccessChain ? new ConcurrentHashMap() : null;
        this.declaringClass = universe.lookup((JavaType)wrappedField.getDeclaringClass());
        this.fieldType = AnalysisField.getDeclaredType(universe, wrappedField);
        if (this.isStatic()) {
            this.canBeNull = false;
            this.staticFieldFlow = new FieldTypeFlow(this, this.getType());
            this.initialInstanceFieldFlow = null;
        } else {
            this.canBeNull = true;
            this.instanceFieldFlow = new ContextInsensitiveFieldTypeFlow(this, this.getType());
            this.initialInstanceFieldFlow = new FieldTypeFlow(this, this.getType());
        }
        this.fieldValueComputer = universe.hostVM().createFieldValueComputer(this);
    }

    @Override
    protected AnalysisUniverse getUniverse() {
        return this.declaringClass.getUniverse();
    }

    private static AnalysisType getDeclaredType(AnalysisUniverse universe, ResolvedJavaField wrappedField) {
        ResolvedJavaType resolvedType;
        try {
            resolvedType = wrappedField.getType().resolve(universe.substitutions.resolve(wrappedField.getDeclaringClass()));
        }
        catch (LinkageError e) {
            return universe.objectType();
        }
        return universe.lookup((JavaType)resolvedType);
    }

    @Override
    public ResolvedJavaField getWrapped() {
        return this.wrapped;
    }

    public void copyAccessInfos(AnalysisField other) {
        isAccessedUpdater.set(this, other.isAccessed);
        isUnsafeAccessedUpdater.set(this, other.isUnsafeAccessed);
        this.canBeNull = other.canBeNull;
        isWrittenUpdater.set(this, other.isWritten);
        isFoldedUpdater.set(this, other.isFolded);
        isReadUpdater.set(this, other.isRead);
        this.notifyUpdateAccessInfo();
    }

    public void intersectAccessInfos(AnalysisField other) {
        isAccessedUpdater.set(this, this.isAccessed != null & other.isAccessed != null ? this.isAccessed : null);
        this.canBeNull = this.canBeNull && other.canBeNull;
        isWrittenUpdater.set(this, this.isWritten != null & other.isWritten != null ? this.isWritten : null);
        isFoldedUpdater.set(this, this.isFolded != null & other.isFolded != null ? this.isFolded : null);
        isReadUpdater.set(this, this.isRead != null & other.isRead != null ? this.isRead : null);
        this.notifyUpdateAccessInfo();
    }

    public int getId() {
        return this.id;
    }

    public int hashCode() {
        return this.id;
    }

    public JavaKind getStorageKind() {
        return this.fieldType.getStorageKind();
    }

    public TypeState getTypeState() {
        if (this.getType().getStorageKind() != JavaKind.Object) {
            return null;
        }
        if (this.isStatic()) {
            return this.interceptTypeState(this.staticFieldFlow.getState());
        }
        return this.getInstanceFieldTypeState();
    }

    public TypeState getInstanceFieldTypeState() {
        return this.interceptTypeState(this.instanceFieldFlow.getState());
    }

    public FieldTypeFlow getInitialInstanceFieldFlow() {
        return this.initialInstanceFieldFlow;
    }

    public FieldTypeFlow getStaticFieldFlow() {
        assert (Modifier.isStatic(this.getModifiers()));
        return this.staticFieldFlow;
    }

    public ContextInsensitiveFieldTypeFlow getInstanceFieldFlow() {
        assert (!Modifier.isStatic(this.getModifiers()));
        return this.instanceFieldFlow;
    }

    public void cleanupAfterAnalysis() {
        this.staticFieldFlow = null;
        this.instanceFieldFlow = null;
        this.initialInstanceFieldFlow = null;
        this.readBy = null;
        this.writtenBy = null;
        this.instanceFieldTypeState = null;
    }

    public boolean registerAsAccessed(Object reason) {
        assert (this.isValidReason(reason)) : "Registering a field as accessed needs to provide a valid reason.";
        boolean firstAttempt = AtomicUtils.atomicSet(this, reason, isAccessedUpdater);
        this.notifyUpdateAccessInfo();
        if (firstAttempt) {
            this.onReachable();
            this.getUniverse().onFieldAccessed(this);
            this.getUniverse().getHeapScanner().onFieldRead(this);
        }
        return firstAttempt;
    }

    public boolean registerAsRead(Object reason) {
        assert (this.isValidReason(reason)) : "Registering a field as read needs to provide a valid reason.";
        boolean firstAttempt = AtomicUtils.atomicSet(this, reason, isReadUpdater);
        this.notifyUpdateAccessInfo();
        if (this.readBy != null) {
            this.readBy.put(reason, Boolean.TRUE);
        }
        if (firstAttempt) {
            this.onReachable();
            this.getUniverse().onFieldAccessed(this);
            this.getUniverse().getHeapScanner().onFieldRead(this);
        }
        return firstAttempt;
    }

    public boolean registerAsWritten(Object reason) {
        assert (this.isValidReason(reason)) : "Registering a field as written needs to provide a valid reason.";
        boolean firstAttempt = AtomicUtils.atomicSet(this, reason, isWrittenUpdater);
        this.notifyUpdateAccessInfo();
        if (this.writtenBy != null && reason != null) {
            this.writtenBy.put(reason, Boolean.TRUE);
        }
        if (firstAttempt) {
            this.onReachable();
            if (Modifier.isVolatile(this.getModifiers()) || this.getStorageKind() == JavaKind.Object) {
                this.getUniverse().onFieldAccessed(this);
            }
        }
        return firstAttempt;
    }

    public void registerAsFolded(Object reason) {
        assert (this.isValidReason(reason)) : "Registering a field as folded needs to provide a valid reason.";
        if (AtomicUtils.atomicSet(this, reason, isFoldedUpdater)) {
            assert (this.getDeclaringClass().isReachable());
            this.onReachable();
        }
    }

    public void registerAsUnsafeAccessed(Object reason) {
        this.registerAsUnsafeAccessed(DefaultUnsafePartition.get(), reason);
    }

    public boolean registerAsUnsafeAccessed(UnsafePartitionKind partitionKind, Object reason) {
        assert (this.isValidReason(reason)) : "Registering a field as unsafe accessed needs to provide a valid reason.";
        this.registerAsAccessed(reason);
        if (AtomicUtils.atomicSet(this, reason, isUnsafeAccessedUpdater)) {
            this.registerAsWritten(reason);
            if (this.isStatic()) {
                this.getUniverse().registerUnsafeAccessedStaticField(this);
            } else {
                AnalysisType declaringType = this.getDeclaringClass();
                declaringType.registerUnsafeAccessedField(this, partitionKind);
            }
            return true;
        }
        this.notifyUpdateAccessInfo();
        return false;
    }

    public boolean isUnsafeAccessed() {
        return AtomicUtils.isSet(this, isUnsafeAccessedUpdater);
    }

    public void registerAsJNIAccessed() {
        this.isJNIAccessed = true;
    }

    public boolean isJNIAccessed() {
        return this.isJNIAccessed;
    }

    public void setUnsafeFrozenTypeState(boolean value) {
        unsafeFrozenTypeStateUpdater.set(this, value ? 1 : 0);
    }

    public boolean hasUnsafeFrozenTypeState() {
        return AtomicUtils.isSet(this, unsafeFrozenTypeStateUpdater);
    }

    public Object getReadBy() {
        return isReadUpdater.get(this);
    }

    public Object getAccessedReason() {
        return this.isAccessed;
    }

    public boolean isAccessed() {
        return AtomicUtils.isSet(this, isAccessedUpdater) || AtomicUtils.isSet(this, isReadUpdater) || AtomicUtils.isSet(this, isWrittenUpdater) && (Modifier.isVolatile(this.getModifiers()) || this.getStorageKind() == JavaKind.Object);
    }

    public boolean isRead() {
        return AtomicUtils.isSet(this, isAccessedUpdater) || AtomicUtils.isSet(this, isReadUpdater);
    }

    public Object getReadReason() {
        return this.isRead;
    }

    public boolean isWritten() {
        return AtomicUtils.isSet(this, isAccessedUpdater) || AtomicUtils.isSet(this, isWrittenUpdater);
    }

    public Object getWrittenReason() {
        return this.isWritten;
    }

    public boolean isFolded() {
        return AtomicUtils.isSet(this, isFoldedUpdater);
    }

    public Object getFoldedReason() {
        return this.isFolded;
    }

    @Override
    public boolean isReachable() {
        return AtomicUtils.isSet(this, isAccessedUpdater) || AtomicUtils.isSet(this, isReadUpdater) || AtomicUtils.isSet(this, isWrittenUpdater) || AtomicUtils.isSet(this, isFoldedUpdater);
    }

    @Override
    public void onReachable() {
        this.notifyReachabilityCallbacks(this.declaringClass.getUniverse(), new ArrayList<AnalysisFuture<Void>>());
    }

    public boolean isValueAvailable() {
        if (this.fieldValueComputer != null) {
            return this.fieldValueComputer.isAvailable();
        }
        return true;
    }

    public boolean isComputedValue() {
        return this.fieldValueComputer != null;
    }

    public Class<?>[] computedValueTypes() {
        return this.fieldValueComputer.types();
    }

    public boolean computedValueCanBeNull() {
        return this.fieldValueComputer.canBeNull();
    }

    public void setCanBeNull(boolean canBeNull) {
        this.canBeNull = canBeNull;
        this.notifyUpdateAccessInfo();
    }

    public boolean canBeNull() {
        return this.canBeNull;
    }

    public String getName() {
        return this.wrapped.getName();
    }

    public void setPosition(int newPosition) {
        this.position = newPosition;
    }

    public int getPosition() {
        assert (this.position != -1) : this;
        return this.position;
    }

    public AnalysisType getType() {
        return this.fieldType;
    }

    public int getModifiers() {
        return this.wrapped.getModifiers();
    }

    public int getOffset() {
        throw GraalError.unimplementedOverride();
    }

    public AnalysisType getDeclaringClass() {
        return this.declaringClass;
    }

    public boolean isInternal() {
        return false;
    }

    public boolean isSynthetic() {
        return this.wrapped.isSynthetic();
    }

    public boolean isStatic() {
        return Modifier.isStatic(this.getModifiers());
    }

    public String toString() {
        return "AnalysisField<" + this.format("%h.%n") + " -> " + this.wrapped.toString() + ", accessed: " + (this.isAccessed != null) + ", read: " + (this.isRead != null) + ", written: " + (this.isWritten != null) + ", folded: " + this.isFolded() + ">";
    }

    @Override
    public Field getJavaField() {
        return OriginalFieldProvider.getJavaField(this.wrapped);
    }

    public JavaConstant getConstantValue() {
        return this.getUniverse().lookup(this.getWrapped().getConstantValue());
    }

    public void addAnalysisFieldObserver(AnalysisFieldObserver observer) {
        ConcurrentLightHashSet.addElement(this, OBSERVERS_UPDATER, observer);
    }

    public void removeAnalysisFieldObserver(AnalysisFieldObserver observer) {
        ConcurrentLightHashSet.removeElement(this, OBSERVERS_UPDATER, observer);
    }

    private void notifyUpdateAccessInfo() {
        for (Object observer : ConcurrentLightHashSet.getElements(this, OBSERVERS_UPDATER)) {
            ((AnalysisFieldObserver)observer).notifyUpdateAccessInfo(this);
        }
    }

    private TypeState interceptTypeState(TypeState typestate) {
        TypeState result = typestate;
        for (Object observer : ConcurrentLightHashSet.getElements(this, OBSERVERS_UPDATER)) {
            result = ((AnalysisFieldObserver)observer).interceptTypeState(this, typestate);
        }
        return result;
    }

    public static interface AnalysisFieldObserver {
        public void notifyUpdateAccessInfo(AnalysisField var1);

        public TypeState interceptTypeState(AnalysisField var1, TypeState var2);
    }
}

