/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted;

import com.oracle.graal.pointsto.reports.ReportUtils;
import com.oracle.svm.core.BuildArtifacts;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.option.HostedOptionValues;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.core.util.json.JsonWriter;
import com.oracle.svm.hosted.NativeImageGenerator;
import com.oracle.svm.util.LogUtils;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Consumer;

public class BuildArtifactsExporter {
    private static final String ENV_VAR_REENABLE_DEPRECATED = "NATIVE_IMAGE_DEPRECATED_BUILD_ARTIFACTS_TXT";

    public static void run(String imageName, BuildArtifacts buildArtifacts, Map<BuildArtifacts.ArtifactType, List<Path>> buildArtifactsMap) {
        BuildArtifactsExporter.run(buildArtifacts, buildArtifactsMap);
        if ("true".equalsIgnoreCase(System.getenv().get(ENV_VAR_REENABLE_DEPRECATED))) {
            LogUtils.warningDeprecatedEnvironmentVariable((String)ENV_VAR_REENABLE_DEPRECATED);
            BuildArtifactsExporter.reportDeprecatedBuildArtifacts(imageName, buildArtifacts, buildArtifactsMap);
        }
    }

    private static void run(BuildArtifacts buildArtifacts, Map<BuildArtifacts.ArtifactType, List<Path>> buildArtifactsMap) {
        if (buildArtifactsMap.isEmpty() || !SubstrateOptions.GenerateBuildArtifactsFile.getValue().booleanValue()) {
            return;
        }
        Path buildPath = NativeImageGenerator.generatedFiles(HostedOptionValues.singleton());
        Path targetPath = buildPath.resolve("build-artifacts.json");
        TreeMap<String, List> jsonMap = new TreeMap<String, List>();
        for (Map.Entry<BuildArtifacts.ArtifactType, List<Path>> artifact : buildArtifactsMap.entrySet()) {
            String key = artifact.getKey().getJsonKey();
            List<String> value = artifact.getValue().stream().map(p -> buildPath.relativize(p.toAbsolutePath()).toString()).toList();
            jsonMap.computeIfAbsent(key, k -> new ArrayList()).addAll(value);
        }
        try (JsonWriter writer = new JsonWriter(targetPath, new OpenOption[0]);){
            writer.appendObjectStart();
            Iterator iterator = jsonMap.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                writer.quote((String)entry.getKey()).appendFieldSeparator().print((List)entry.getValue());
                if (!iterator.hasNext()) continue;
                writer.appendSeparator();
            }
            writer.appendObjectEnd();
            buildArtifacts.add(BuildArtifacts.ArtifactType.BUILD_INFO, targetPath);
        }
        catch (IOException e) {
            throw VMError.shouldNotReachHere("Unable to create build-artifacts.json", e);
        }
    }

    private static void reportDeprecatedBuildArtifacts(String imageName, BuildArtifacts buildArtifacts, Map<BuildArtifacts.ArtifactType, List<Path>> buildArtifactsMap) {
        Path buildDir = NativeImageGenerator.generatedFiles(HostedOptionValues.singleton());
        Consumer<PrintWriter> writerConsumer = writer -> buildArtifactsMap.forEach((artifactType, paths) -> {
            writer.println("[" + String.valueOf(artifactType) + "]");
            if (artifactType == BuildArtifacts.ArtifactType.JDK_LIBRARY_SHIM) {
                writer.println("# Note that shim JDK libraries depend on this");
                writer.println("# particular native image (including its name)");
                writer.println("# and therefore cannot be used with others.");
            }
            paths.stream().map(Path::toAbsolutePath).map(buildDir::relativize).forEach(writer::println);
            writer.println();
        });
        buildArtifacts.add(BuildArtifacts.ArtifactType.BUILD_INFO, ReportUtils.report((String)"build artifacts", (Path)buildDir.resolve(imageName + ".build_artifacts.txt"), writerConsumer, (boolean)false));
    }
}

