/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.graal.isolated;

import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.graal.meta.SubstrateMemoryAccessProvider;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.meta.SubstrateObjectConstant;
import com.oracle.svm.graal.isolated.ClientHandle;
import com.oracle.svm.graal.isolated.ClientIsolateThread;
import com.oracle.svm.graal.isolated.ConstantData;
import com.oracle.svm.graal.isolated.ConstantDataConverter;
import com.oracle.svm.graal.isolated.ImageHeapObjects;
import com.oracle.svm.graal.isolated.ImageHeapRef;
import com.oracle.svm.graal.isolated.IsolatedCompileClient;
import com.oracle.svm.graal.isolated.IsolatedCompileContext;
import com.oracle.svm.graal.isolated.IsolatedObjectConstant;
import com.oracle.svm.graal.meta.SubstrateConstantReflectionProvider;
import com.oracle.svm.graal.meta.SubstrateField;
import com.oracle.svm.graal.meta.SubstrateMemoryAccessProviderImpl;
import com.oracle.svm.graal.meta.SubstrateMetaAccess;
import java.lang.reflect.Array;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.MemoryAccessProvider;
import jdk.vm.ci.meta.PrimitiveConstant;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.compiler.core.common.CompressEncoding;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.nativeimage.c.function.CEntryPoint;
import org.graalvm.word.WordFactory;

final class IsolateAwareConstantReflectionProvider
extends SubstrateConstantReflectionProvider {
    private static final IsolatedMemoryAccessProvider ISOLATED_MEMORY_ACCESS_PROVIDER_SINGLETON = new IsolatedMemoryAccessProvider();

    private static boolean isIsolatedCompilation() {
        return SubstrateOptions.shouldCompileInIsolates();
    }

    IsolateAwareConstantReflectionProvider(SubstrateMetaAccess metaAccess) {
        super(metaAccess);
    }

    @Override
    public Integer readArrayLength(JavaConstant array) {
        if (!IsolateAwareConstantReflectionProvider.isIsolatedCompilation()) {
            return super.readArrayLength(array);
        }
        if (array.getJavaKind() != JavaKind.Object || array.isNull()) {
            return null;
        }
        if (array instanceof IsolatedObjectConstant) {
            ClientHandle<?> arrayHandle = ((IsolatedObjectConstant)array).getHandle();
            int length = IsolateAwareConstantReflectionProvider.readArrayLength0(IsolatedCompileContext.get().getClient(), arrayHandle);
            return length >= 0 ? Integer.valueOf(length) : null;
        }
        Object arrayObj = SubstrateObjectConstant.asObject((Constant)array);
        if (!arrayObj.getClass().isArray()) {
            return null;
        }
        assert (ImageHeapObjects.isInImageHeap(arrayObj));
        return Array.getLength(arrayObj);
    }

    @CEntryPoint(include=CEntryPoint.NotIncludedAutomatically.class, publishAs=CEntryPoint.Publish.NotPublished)
    private static int readArrayLength0(ClientIsolateThread client, ClientHandle<?> arrayHandle) {
        Object array = IsolatedCompileClient.get().unhand(arrayHandle);
        if (!array.getClass().isArray()) {
            return -1;
        }
        return Array.getLength(array);
    }

    @Override
    public JavaConstant readArrayElement(JavaConstant array, int index) {
        if (!IsolateAwareConstantReflectionProvider.isIsolatedCompilation()) {
            return super.readArrayElement(array, index);
        }
        if (array.getJavaKind() != JavaKind.Object || array.isNull()) {
            return null;
        }
        ConstantData arrayData = (ConstantData)StackValue.get(ConstantData.class);
        ConstantData resultData = (ConstantData)StackValue.get(ConstantData.class);
        ConstantDataConverter.fromCompiler((Constant)array, arrayData);
        IsolateAwareConstantReflectionProvider.readArrayElement0(IsolatedCompileContext.get().getClient(), arrayData, index, resultData);
        return ConstantDataConverter.toCompiler(resultData);
    }

    @CEntryPoint(include=CEntryPoint.NotIncludedAutomatically.class, publishAs=CEntryPoint.Publish.NotPublished)
    private static void readArrayElement0(ClientIsolateThread client, ConstantData arrayData, int index, ConstantData resultData) {
        PrimitiveConstant result;
        JavaConstant array = ConstantDataConverter.toClient(arrayData);
        Object a = SubstrateObjectConstant.asObject((Constant)array);
        if (index < 0 || index >= Array.getLength(a)) {
            result = null;
        } else if (a instanceof Object[]) {
            Object element = ((Object[])a)[index];
            result = SubstrateObjectConstant.forObject(element);
        } else {
            result = JavaConstant.forBoxedPrimitive((Object)Array.get(a, index));
        }
        ConstantDataConverter.fromClient(result, resultData);
    }

    @Override
    public JavaConstant readFieldValue(ResolvedJavaField field, JavaConstant receiver) {
        if (!IsolateAwareConstantReflectionProvider.isIsolatedCompilation()) {
            return super.readFieldValue(field, receiver);
        }
        ConstantData resultData = (ConstantData)StackValue.get(ConstantData.class);
        ConstantData receiverData = (ConstantData)StackValue.get(ConstantData.class);
        ConstantDataConverter.fromCompiler((Constant)receiver, receiverData);
        IsolateAwareConstantReflectionProvider.readFieldValue0(IsolatedCompileContext.get().getClient(), ImageHeapObjects.ref((SubstrateField)field), receiverData, resultData);
        return ConstantDataConverter.toCompiler(resultData);
    }

    @CEntryPoint(include=CEntryPoint.NotIncludedAutomatically.class, publishAs=CEntryPoint.Publish.NotPublished)
    private static void readFieldValue0(ClientIsolateThread client, ImageHeapRef<SubstrateField> fieldRef, ConstantData receiverData, ConstantData resultData) {
        JavaConstant receiver = ConstantDataConverter.toClient(receiverData);
        JavaConstant result = IsolateAwareConstantReflectionProvider.readFieldValue(ImageHeapObjects.deref(fieldRef), receiver);
        ConstantDataConverter.fromClient((Constant)result, resultData);
    }

    @CEntryPoint(include=CEntryPoint.NotIncludedAutomatically.class, publishAs=CEntryPoint.Publish.NotPublished)
    private static void boxPrimitive0(ClientIsolateThread client, ConstantData primitiveData, ConstantData resultData) {
        JavaConstant primitive = ConstantDataConverter.toClient(primitiveData);
        JavaConstant result = SubstrateObjectConstant.forObject(primitive.asBoxedPrimitive());
        ConstantDataConverter.fromClient((Constant)result, resultData);
    }

    @Override
    public JavaConstant unboxPrimitive(JavaConstant boxed) {
        if (boxed instanceof IsolatedObjectConstant) {
            ConstantData resultData = (ConstantData)StackValue.get(ConstantData.class);
            ConstantData boxedData = (ConstantData)StackValue.get(ConstantData.class);
            ConstantDataConverter.fromCompiler((Constant)boxed, boxedData);
            IsolateAwareConstantReflectionProvider.unboxPrimitive0(IsolatedCompileContext.get().getClient(), boxedData, resultData);
            return ConstantDataConverter.toCompiler(resultData);
        }
        return super.unboxPrimitive(boxed);
    }

    @CEntryPoint(include=CEntryPoint.NotIncludedAutomatically.class, publishAs=CEntryPoint.Publish.NotPublished)
    private static void unboxPrimitive0(ClientIsolateThread client, ConstantData boxedData, ConstantData resultData) {
        JavaConstant boxed = ConstantDataConverter.toClient(boxedData);
        PrimitiveConstant result = JavaConstant.forBoxedPrimitive((Object)SubstrateObjectConstant.asObject((Constant)boxed));
        ConstantDataConverter.fromClient((Constant)result, resultData);
    }

    @Override
    public JavaConstant forString(String value) {
        return super.forString(value);
    }

    @Override
    public ResolvedJavaType asJavaType(Constant hub) {
        Constant resolved = hub;
        if (hub instanceof IsolatedObjectConstant) {
            ConstantData hubData = (ConstantData)StackValue.get(ConstantData.class);
            ConstantDataConverter.fromCompiler(hub, hubData);
            ImageHeapRef<DynamicHub> ref = IsolateAwareConstantReflectionProvider.getHubConstantAsImageHeapRef(IsolatedCompileContext.get().getClient(), hubData);
            resolved = SubstrateObjectConstant.forObject(ImageHeapObjects.deref(ref));
        }
        return super.asJavaType(resolved);
    }

    @CEntryPoint(include=CEntryPoint.NotIncludedAutomatically.class, publishAs=CEntryPoint.Publish.NotPublished)
    private static ImageHeapRef<DynamicHub> getHubConstantAsImageHeapRef(ClientIsolateThread client, ConstantData hubData) {
        JavaConstant hub = ConstantDataConverter.toClient(hubData);
        Object target = SubstrateObjectConstant.asObject((Constant)hub);
        return target instanceof DynamicHub ? ImageHeapObjects.ref((DynamicHub)target) : (ImageHeapRef<DynamicHub>)WordFactory.nullPointer();
    }

    @Override
    public MemoryAccessProvider getMemoryAccessProvider() {
        return IsolateAwareConstantReflectionProvider.isIsolatedCompilation() ? ISOLATED_MEMORY_ACCESS_PROVIDER_SINGLETON : SubstrateMemoryAccessProviderImpl.SINGLETON;
    }

    @Override
    public JavaConstant asJavaClass(ResolvedJavaType type) {
        return super.asJavaClass(type);
    }

    @Override
    public int getImageHeapOffset(JavaConstant constant) {
        if (constant instanceof IsolatedObjectConstant) {
            ConstantData constantData = (ConstantData)StackValue.get(ConstantData.class);
            ConstantDataConverter.fromCompiler((Constant)constant, constantData);
            return IsolateAwareConstantReflectionProvider.getImageHeapOffset0(IsolatedCompileContext.get().getClient(), constantData);
        }
        return super.getImageHeapOffset(constant);
    }

    @CEntryPoint(include=CEntryPoint.NotIncludedAutomatically.class, publishAs=CEntryPoint.Publish.NotPublished)
    private static int getImageHeapOffset0(ClientIsolateThread client, ConstantData constantData) {
        JavaConstant constant = ConstantDataConverter.toClient(constantData);
        return IsolateAwareConstantReflectionProvider.getImageHeapOffsetInternal((SubstrateObjectConstant)constant);
    }

    static final class IsolatedMemoryAccessProvider
    implements SubstrateMemoryAccessProvider {
        private IsolatedMemoryAccessProvider() {
        }

        public JavaConstant readPrimitiveConstant(JavaKind kind, Constant base, long displacement, int bits) throws IllegalArgumentException {
            return IsolatedMemoryAccessProvider.read(kind, base, displacement, bits, null);
        }

        public JavaConstant readObjectConstant(Constant base, long displacement) {
            return IsolatedMemoryAccessProvider.read(JavaKind.Object, base, displacement, 0, null);
        }

        @Override
        public JavaConstant readNarrowObjectConstant(Constant base, long displacement, CompressEncoding encoding) {
            return IsolatedMemoryAccessProvider.read(JavaKind.Object, base, displacement, 0, encoding);
        }

        private static JavaConstant read(JavaKind kind, Constant base, long displacement, int primitiveBits, CompressEncoding encoding) {
            int compressShift;
            ConstantData baseData = (ConstantData)StackValue.get(ConstantData.class);
            ConstantDataConverter.fromCompiler(base, baseData);
            long compressBase = encoding != null ? encoding.getBase() : 0L;
            int n = compressShift = encoding != null ? encoding.getShift() : 0;
            assert (encoding != null == (compressBase != 0L || compressShift != 0));
            ConstantData resultData = (ConstantData)StackValue.get(ConstantData.class);
            IsolatedMemoryAccessProvider.read0(IsolatedCompileContext.get().getClient(), kind.getTypeChar(), baseData, displacement, primitiveBits, compressBase, compressShift, resultData);
            return ConstantDataConverter.toCompiler(resultData);
        }

        @CEntryPoint(include=CEntryPoint.NotIncludedAutomatically.class, publishAs=CEntryPoint.Publish.NotPublished)
        private static void read0(ClientIsolateThread client, char kindChar, ConstantData baseData, long displacement, int primitiveBits, long compressBase, int compressShift, ConstantData resultData) {
            JavaConstant result;
            JavaConstant base = ConstantDataConverter.toClient(baseData);
            if (kindChar == JavaKind.Object.getTypeChar()) {
                result = compressBase != 0L || compressShift != 0 ? SubstrateMemoryAccessProviderImpl.SINGLETON.readNarrowObjectConstant((Constant)base, displacement, new CompressEncoding(compressBase, compressShift)) : SubstrateMemoryAccessProviderImpl.SINGLETON.readObjectConstant((Constant)base, displacement);
            } else {
                JavaKind kind = JavaKind.fromPrimitiveOrVoidTypeChar((char)kindChar);
                result = SubstrateMemoryAccessProviderImpl.SINGLETON.readPrimitiveConstant(kind, (Constant)base, displacement, primitiveBits);
            }
            ConstantDataConverter.fromClient((Constant)result, resultData);
        }
    }
}

