/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.posix.pthread;

import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.feature.AutomaticallyRegisteredFeature;
import com.oracle.svm.core.feature.InternalFeature;
import com.oracle.svm.core.locks.ClassInstanceReplacer;
import com.oracle.svm.core.locks.VMCondition;
import com.oracle.svm.core.locks.VMLockSupport;
import com.oracle.svm.core.locks.VMMutex;
import com.oracle.svm.core.posix.pthread.PthreadVMCondition;
import com.oracle.svm.core.posix.pthread.PthreadVMLockSupport;
import com.oracle.svm.core.posix.pthread.PthreadVMMutex;
import java.util.Arrays;
import java.util.Comparator;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.hosted.Feature;

@AutomaticallyRegisteredFeature
final class PthreadVMLockFeature
implements InternalFeature {
    private final ClassInstanceReplacer<VMMutex, VMMutex> mutexReplacer = new ClassInstanceReplacer<VMMutex, VMMutex>(VMMutex.class){

        @Override
        protected VMMutex createReplacement(VMMutex source) {
            return new PthreadVMMutex(source.getName());
        }
    };
    private final ClassInstanceReplacer<VMCondition, VMCondition> conditionReplacer = new ClassInstanceReplacer<VMCondition, VMCondition>(VMCondition.class){

        @Override
        protected VMCondition createReplacement(VMCondition source) {
            return new PthreadVMCondition((PthreadVMMutex)PthreadVMLockFeature.this.mutexReplacer.apply((Object)source.getMutex()), source.getConditionName());
        }
    };

    PthreadVMLockFeature() {
    }

    public boolean isInConfiguration(Feature.IsInConfigurationAccess access) {
        return SubstrateOptions.MultiThreaded.getValue();
    }

    public void duringSetup(Feature.DuringSetupAccess access) {
        PthreadVMLockSupport support = new PthreadVMLockSupport();
        ImageSingletons.add(VMLockSupport.class, (Object)support);
        access.registerObjectReplacer(this.mutexReplacer);
        access.registerObjectReplacer(this.conditionReplacer);
    }

    public void beforeCompilation(Feature.BeforeCompilationAccess access) {
        PthreadVMMutex[] mutexes = this.mutexReplacer.getReplacements().toArray(new PthreadVMMutex[0]);
        PthreadVMCondition[] conditions = this.conditionReplacer.getReplacements().toArray(new PthreadVMCondition[0]);
        Arrays.sort(mutexes, Comparator.comparing(VMMutex::getName));
        Arrays.sort(conditions, Comparator.comparing(c -> c.getMutex().getName()));
        PthreadVMLockSupport lockSupport = PthreadVMLockSupport.singleton();
        lockSupport.mutexes = mutexes;
        lockSupport.conditions = conditions;
    }
}

