/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.genscavenge;

import com.oracle.svm.core.Isolates;
import com.oracle.svm.core.Uninterruptible;

final class Timer
implements AutoCloseable {
    private final String name;
    private boolean wasOpened;
    private long openNanos;
    private boolean wasClosed;
    private long closeNanos;
    private long collectedNanos;

    Timer(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public Timer open() {
        return this.openAt(System.nanoTime());
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    Timer openAt(long nanoTime) {
        this.openNanos = nanoTime;
        this.wasOpened = true;
        this.closeNanos = 0L;
        this.wasClosed = false;
        return this;
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public void close() {
        this.closeAt(System.nanoTime());
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    void closeAt(long nanoTime) {
        this.closeNanos = nanoTime;
        this.wasClosed = true;
        this.collectedNanos += this.closeNanos - this.getOpenedTime();
    }

    public void reset() {
        this.openNanos = 0L;
        this.wasOpened = false;
        this.closeNanos = 0L;
        this.wasClosed = false;
        this.collectedNanos = 0L;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public long getOpenedTime() {
        if (!this.wasOpened) {
            assert (this.openNanos == 0L);
            return Isolates.getCurrentStartNanoTime();
        }
        return this.openNanos;
    }

    public long getClosedTime() {
        assert (this.wasClosed) : "Should have closed timer";
        return this.closeNanos;
    }

    long getMeasuredNanos() {
        return this.collectedNanos;
    }

    long getLastIntervalNanos() {
        return this.getClosedTime() - this.getOpenedTime();
    }
}

