/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.enterprise.hosted.phases;

import com.oracle.graal.pointsto.flow.AnalysisParsedGraph;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.svm.common.meta.MultiMethod;
import com.oracle.svm.core.meta.MethodPointer;
import com.oracle.svm.core.meta.SubstrateMethodPointerConstant;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.enterprise.hosted.cai.a;
import com.oracle.svm.enterprise.hosted.pgo.d;
import com.oracle.svm.hosted.meta.HostedMethod;
import java.util.Arrays;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Function;
import jdk.vm.ci.code.BytecodePosition;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.compiler.bytecode.ResolvedJavaMethodBytecode;
import org.graalvm.compiler.core.common.CompilationIdentifier;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeSourcePosition;
import org.graalvm.compiler.nodes.EncodedGraph;
import org.graalvm.compiler.nodes.FrameState;
import org.graalvm.compiler.nodes.GraphDecoder;
import org.graalvm.compiler.nodes.Invoke;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.options.OptionKey;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.phases.BasePhase;

public class HotMethodDuplicationPhase<C>
extends BasePhase<C> {
    private static final AtomicInteger uR = new AtomicInteger();
    private final Function<HostedMethod, d.b> uS;

    public HotMethodDuplicationPhase(Function<HostedMethod, d.b> function) {
        this.uS = function;
    }

    protected void run(StructuredGraph structuredGraph, C c2) {
        assert (structuredGraph.globalProfileProvider().hotCaller()) : "Should not run on cold compilation units";
        b b2 = new b(structuredGraph);
        d.b b3 = this.uS.apply((HostedMethod)structuredGraph.method());
        HotMethodDuplicationPhase.b(structuredGraph, invoke -> {
            HostedMethod hostedMethod;
            NodeSourcePosition nodeSourcePosition = FrameState.toSourcePosition((FrameState)invoke.stateDuring());
            d.b b4 = b3.a((BytecodePosition)nodeSourcePosition, (ResolvedJavaMethod)(hostedMethod = (HostedMethod)invoke.getTargetMethod()));
            if (b4 == null || !b4.eW()) {
                return;
            }
            HostedMethod hostedMethod2 = HotMethodDuplicationPhase.a(b2, (BytecodePosition)nodeSourcePosition, hostedMethod, b4);
            assert (invoke.callTarget() != null);
            invoke.callTarget().setTargetMethod((ResolvedJavaMethod)hostedMethod2);
        });
    }

    private static HostedMethod a(b b2, BytecodePosition bytecodePosition, HostedMethod hostedMethod, d.b b3) {
        HostedMethod hostedMethod2;
        if (((Boolean)c.vc.getValue(b2.uU.getOptions())).booleanValue() && b3.eX() && (hostedMethod2 = HotMethodDuplicationPhase.a(b3, hostedMethod)) != null) {
            HotMethodDuplicationPhase.a(b2, hostedMethod2, "Reusing method");
            return hostedMethod2;
        }
        hostedMethod2 = b2.a(hostedMethod, bytecodePosition);
        HotMethodDuplicationPhase.a(b2, hostedMethod2, "Duplicated method");
        return hostedMethod2;
    }

    private static void a(b b2, HostedMethod hostedMethod, String string) {
        if (((Boolean)c.vb.getValue(b2.uU.getOptions())).booleanValue()) {
            ResolvedJavaMethod resolvedJavaMethod = b2.uU.method();
            b2.uU.getDebug().log("[HotMethodDuplicationPhase] %s: %s called from %s", (Object)string, (Object)hostedMethod.format("%h.%n"), (Object)resolvedJavaMethod.format("%h.%n"));
        }
    }

    private static HostedMethod a(d.b b2, HostedMethod hostedMethod) {
        for (d.b b3 = b2; b3 != null; b3 = b3.eV()) {
            d.c c2 = (d.c)b3;
            HostedMethod hostedMethod2 = ((a.a)c2.eY()).dy();
            if (hostedMethod2 == null || !Objects.equals(hostedMethod2.wrapped, hostedMethod.wrapped)) continue;
            return hostedMethod2;
        }
        return null;
    }

    private static void b(StructuredGraph structuredGraph, Consumer<Invoke> consumer) {
        for (Node node : structuredGraph.getNodes()) {
            Invoke invoke;
            if (!(node instanceof Invoke) || !(invoke = (Invoke)node).getInvokeKind().isDirect() || invoke.getTargetMethod() == null) continue;
            consumer.accept(invoke);
        }
    }

    private static final class b {
        private final StructuredGraph uU;
        private final Map<a, HostedMethod> uV = new HashMap<a, HostedMethod>();
        private HostedMethod uW;
        private HostedMethod uX;
        private Map<Object, Object> uY;

        private b(StructuredGraph structuredGraph) {
            this.uU = structuredGraph;
        }

        private HostedMethod a(HostedMethod hostedMethod, BytecodePosition bytecodePosition) {
            return this.uV.computeIfAbsent(new a(bytecodePosition, hostedMethod.wrapped), a2 -> this.w(hostedMethod));
        }

        private HostedMethod w(HostedMethod hostedMethod) {
            this.uW = hostedMethod;
            this.uX = hostedMethod.getOrCreateMultiMethod((MultiMethod.MultiMethodKey)new com.oracle.svm.enterprise.hosted.phases.HotMethodDuplicationPhase$a());
            this.uY = new IdentityHashMap<Object, Object>();
            this.uX.compilationInfo.setCompileOptions(new OptionValues(hostedMethod.compilationInfo.getCompileOptions().getMap()));
            EncodedGraph encodedGraph = this.a(hostedMethod.compilationInfo.getCompilationGraph().getEncodedGraph());
            this.uX.compilationInfo.encodeGraph(this.a(encodedGraph, (ResolvedJavaMethod)this.uX));
            return this.uX;
        }

        private EncodedGraph a(EncodedGraph encodedGraph) {
            Object[] objectArray = encodedGraph.getObjects();
            Object[] objectArray2 = new Object[objectArray.length];
            for (int i2 = 0; i2 < objectArray.length; ++i2) {
                objectArray2[i2] = this.q(objectArray[i2]);
            }
            return new EncodedGraph(Arrays.copyOf(encodedGraph.getEncoding(), encodedGraph.getEncoding().length), encodedGraph.getStartOffset(), objectArray2, Arrays.copyOf(encodedGraph.getNodeClasses(), encodedGraph.getNodeClasses().length), encodedGraph.getAssumptions(), encodedGraph.getInlinedMethods(), encodedGraph.hasUnsafeAccess(), encodedGraph.trackNodeSourcePosition());
        }

        private StructuredGraph a(EncodedGraph encodedGraph, ResolvedJavaMethod resolvedJavaMethod) {
            DebugContext debugContext = this.uU.getDebug();
            StructuredGraph structuredGraph = new StructuredGraph.Builder(this.uU.getOptions(), debugContext).method(resolvedJavaMethod).recordInlinedMethods(false).trackNodeSourcePosition(encodedGraph.trackNodeSourcePosition()).compilationId((CompilationIdentifier)CompilationIdentifier.INVALID_COMPILATION_ID).build();
            try (DebugContext.Scope scope = debugContext.scope((Object)"HotMethodDuplicationPhase#decodeGraph", (Object)structuredGraph, (Object)resolvedJavaMethod);){
                new GraphDecoder(AnalysisParsedGraph.HOST_ARCHITECTURE, structuredGraph).decode(encodedGraph);
            }
            catch (Throwable throwable) {
                throw debugContext.handle(throwable);
            }
            return structuredGraph;
        }

        private Object q(Object object) {
            if (object == null) {
                return null;
            }
            return this.uY.computeIfAbsent(object, this::r);
        }

        private ResolvedJavaMethod d(ResolvedJavaMethod resolvedJavaMethod) {
            if (Objects.equals(resolvedJavaMethod, this.uW)) {
                return this.uX;
            }
            return (ResolvedJavaMethod)this.q(resolvedJavaMethod);
        }

        private Object r(Object object) {
            if (object instanceof Node) {
                throw VMError.shouldNotReachHere((String)"Must not replace a Graal graph nodes, only data objects referenced from a node");
            }
            if (object.getClass() == ResolvedJavaMethodBytecode.class) {
                ResolvedJavaMethodBytecode resolvedJavaMethodBytecode = (ResolvedJavaMethodBytecode)object;
                HostedMethod hostedMethod = (HostedMethod)this.q(resolvedJavaMethodBytecode.getMethod());
                return new ResolvedJavaMethodBytecode(this.d((ResolvedJavaMethod)hostedMethod), resolvedJavaMethodBytecode.getOrigin());
            }
            if (object.getClass() == SubstrateMethodPointerConstant.class) {
                SubstrateMethodPointerConstant substrateMethodPointerConstant = (SubstrateMethodPointerConstant)object;
                MethodPointer methodPointer = substrateMethodPointerConstant.pointer();
                ResolvedJavaMethod resolvedJavaMethod = methodPointer.getMethod();
                ResolvedJavaMethod resolvedJavaMethod2 = this.d(resolvedJavaMethod);
                return new SubstrateMethodPointerConstant(new MethodPointer(resolvedJavaMethod2));
            }
            if (object.getClass() == NodeSourcePosition.class) {
                NodeSourcePosition nodeSourcePosition = (NodeSourcePosition)object;
                NodeSourcePosition nodeSourcePosition2 = (NodeSourcePosition)this.q(nodeSourcePosition.getCaller());
                ResolvedJavaMethod resolvedJavaMethod = this.d(nodeSourcePosition.getMethod());
                return new NodeSourcePosition(nodeSourcePosition.getSourceLanguage(), nodeSourcePosition2, resolvedJavaMethod, nodeSourcePosition.getBCI(), nodeSourcePosition.getMarker());
            }
            return object;
        }

        private static final class a {
            final BytecodePosition uZ;
            final AnalysisMethod va;

            a(BytecodePosition bytecodePosition, AnalysisMethod analysisMethod) {
                this.uZ = bytecodePosition;
                this.va = analysisMethod;
            }

            public boolean equals(Object object) {
                if (this == object) {
                    return true;
                }
                if (object == null || this.getClass() != object.getClass()) {
                    return false;
                }
                a a2 = (a)object;
                return Objects.equals(this.uZ, a2.uZ) && Objects.equals(this.va, a2.va);
            }

            public int hashCode() {
                return Objects.hash(this.uZ, this.va);
            }
        }
    }

    public static class c {
        public static final OptionKey<Boolean> vb = new OptionKey((Object)false);
        public static final OptionKey<Boolean> vc = new OptionKey((Object)true);
    }

    private static final class a
    implements MultiMethod.MultiMethodKey {
        final int uT = uR.getAndIncrement();

        private a() {
        }

        public String toString() {
            return "Hot_Method_Key_" + this.uT;
        }
    }
}

