/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.foreign;

import com.oracle.svm.core.configure.ConfigurationParser;
import com.oracle.svm.hosted.foreign.FunctionDescriptorParser;
import java.lang.foreign.FunctionDescriptor;
import java.lang.foreign.Linker;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import org.graalvm.collections.EconomicMap;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.impl.ConfigurationCondition;
import org.graalvm.nativeimage.impl.RuntimeForeignAccessSupport;

@Platforms(value={Platform.HOSTED_ONLY.class})
public class ForeignFunctionsConfigurationParser
extends ConfigurationParser {
    private static final String DOWNCALL_OPTION_CAPTURE_CALL_STATE = "captureCallState";
    private static final String DOWNCALL_OPTION_FIRST_VARIADIC_ARG = "firstVariadicArg";
    private static final String DOWNCALL_OPTION_TRIVIAL = "trivial";
    private final RuntimeForeignAccessSupport accessSupport;

    public ForeignFunctionsConfigurationParser(RuntimeForeignAccessSupport access) {
        super(true);
        this.accessSupport = access;
    }

    public void parseAndRegister(Object json, URI origin) {
        EconomicMap topLevel = ForeignFunctionsConfigurationParser.asMap((Object)json, (String)"first level of document must be a map");
        this.checkAttributes(topLevel, "foreign methods categories", List.of(), List.of("downcalls"));
        List downcalls = ForeignFunctionsConfigurationParser.asList((Object)topLevel.get((Object)"downcalls", List.of()), (String)"downcalls must be an array of method signatures");
        for (Object downcall : downcalls) {
            this.parseAndRegisterForeignCall(downcall, (descriptor, options) -> this.accessSupport.registerForDowncall(ConfigurationCondition.alwaysTrue(), descriptor, options));
        }
    }

    private void parseAndRegisterForeignCall(Object call, BiConsumer<Object, Object[]> register) {
        EconomicMap map = ForeignFunctionsConfigurationParser.asMap((Object)call, (String)"a foreign call must be a map");
        this.checkAttributes(map, "foreign call", List.of("descriptor"), List.of("options"));
        FunctionDescriptor descriptor = this.parseDescriptor(map.get((Object)"descriptor"));
        List<Linker.Option> options = this.parseOptions(map.get((Object)"options", null));
        register.accept(descriptor, options.toArray());
    }

    private FunctionDescriptor parseDescriptor(Object signature) {
        String input = ForeignFunctionsConfigurationParser.asString((Object)signature, (String)"a function descriptor must be a string");
        return FunctionDescriptorParser.parse(input);
    }

    private List<Linker.Option> parseOptions(Object options) {
        if (options == null) {
            return List.of();
        }
        ArrayList<Linker.Option> res = new ArrayList<Linker.Option>();
        EconomicMap map = ForeignFunctionsConfigurationParser.asMap((Object)options, (String)"options must be a map");
        this.checkAttributes(map, "options", List.of(), List.of(DOWNCALL_OPTION_FIRST_VARIADIC_ARG, DOWNCALL_OPTION_CAPTURE_CALL_STATE, DOWNCALL_OPTION_TRIVIAL));
        if (map.containsKey((Object)DOWNCALL_OPTION_FIRST_VARIADIC_ARG)) {
            int firstVariadic = (int)ForeignFunctionsConfigurationParser.asLong((Object)map.get((Object)DOWNCALL_OPTION_FIRST_VARIADIC_ARG), (String)"");
            res.add(Linker.Option.firstVariadicArg(firstVariadic));
        }
        if (map.containsKey((Object)DOWNCALL_OPTION_CAPTURE_CALL_STATE) && ForeignFunctionsConfigurationParser.asBoolean((Object)map.get((Object)DOWNCALL_OPTION_CAPTURE_CALL_STATE, (Object)""), (String)DOWNCALL_OPTION_CAPTURE_CALL_STATE)) {
            res.add(Linker.Option.captureCallState("errno"));
        }
        if (map.containsKey((Object)DOWNCALL_OPTION_TRIVIAL) && ForeignFunctionsConfigurationParser.asBoolean((Object)map.get((Object)DOWNCALL_OPTION_TRIVIAL, (Object)""), (String)DOWNCALL_OPTION_TRIVIAL)) {
            res.add(Linker.Option.isTrivial());
        }
        return res;
    }
}

