/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jipher.internal.spi;

import com.oracle.jipher.internal.openssl.MdAlg;
import com.oracle.jipher.internal.openssl.Pkey;
import com.oracle.jipher.internal.spi.InternalProvider;
import com.oracle.jipher.internal.spi.RsaDigestSig;
import com.oracle.jipher.internal.spi.RsaPssGeneralSig;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.ProviderException;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import java.security.spec.MGF1ParameterSpec;
import java.security.spec.PSSParameterSpec;

public abstract class RsaPssDigestSig
extends RsaDigestSig {
    static final int RSA_PSS_SALTLEN_AUTO = -2;
    private int saltLen;
    private boolean saltLenSet;

    RsaPssDigestSig(MdAlg md, int saltLen) {
        super(md);
        this.saltLen = saltLen;
        this.saltLenSet = false;
    }

    @Override
    protected void engineSetParameter(AlgorithmParameterSpec params) throws InvalidAlgorithmParameterException {
        if (!this.isInitialized || this.ctx == null) {
            throw new IllegalStateException("Object not initialized");
        }
        if (!(params instanceof PSSParameterSpec)) {
            throw new InvalidAlgorithmParameterException("Must be PSSParameterSpec");
        }
        PSSParameterSpec spec = (PSSParameterSpec)params;
        if (!spec.getDigestAlgorithm().equals(this.md.getAlg())) {
            throw new InvalidAlgorithmParameterException("Digest algorithm must match signature digest: " + this.md.getAlg());
        }
        RsaPssGeneralSig.verifyParams(this.md.getAlg(), spec);
        this.saltLen = spec.getSaltLength();
        this.saltLenSet = true;
        this.ctx.setPssParams(this.saltLen);
    }

    @Override
    protected AlgorithmParameters engineGetParameters() {
        try {
            AlgorithmParameters params = AlgorithmParameters.getInstance("RSASSA-PSS", InternalProvider.get());
            params.init(new PSSParameterSpec(this.md.getAlg(), "MGF1", new MGF1ParameterSpec(this.md.getAlg()), this.saltLen, 1));
            return params;
        }
        catch (NoSuchAlgorithmException | InvalidParameterSpecException e) {
            throw new ProviderException(e);
        }
    }

    @Override
    void doInit(Pkey pkey, boolean isSign) throws InvalidKeyException {
        super.doInit(pkey, isSign);
        this.ctx.setPssPadding();
        try {
            this.ctx.setPssParams(isSign || this.saltLenSet ? this.saltLen : -2);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new InvalidKeyException(e);
        }
    }

    public static final class RsaPssSha512
    extends RsaPssDigestSig {
        public RsaPssSha512() {
            super(MdAlg.SHA512, 64);
        }
    }

    public static final class RsaPssSha384
    extends RsaPssDigestSig {
        public RsaPssSha384() {
            super(MdAlg.SHA384, 48);
        }
    }

    public static final class RsaPssSha256
    extends RsaPssDigestSig {
        public RsaPssSha256() {
            super(MdAlg.SHA256, 32);
        }
    }

    public static final class RsaPssSha224
    extends RsaPssDigestSig {
        public RsaPssSha224() {
            super(MdAlg.SHA224, 28);
        }
    }

    public static final class RsaPssSha1
    extends RsaPssDigestSig {
        public RsaPssSha1() {
            super(MdAlg.SHA1, 20);
        }
    }
}

