/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jipher.internal.spi;

import com.oracle.jipher.internal.openssl.Pkey;
import com.oracle.jipher.internal.openssl.PkeyCtx;
import com.oracle.jipher.internal.spi.InternalProvider;
import java.math.BigInteger;
import java.security.AlgorithmParameterGeneratorSpi;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.ProviderException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.DSAGenParameterSpec;
import java.security.spec.DSAParameterSpec;
import java.security.spec.InvalidParameterSpecException;

public final class DsaParamGenerator
extends AlgorithmParameterGeneratorSpi {
    private int pLen;
    private int qLen;

    @Override
    protected void engineInit(int size, SecureRandom random) {
        this.qLen = this.getDefault(size);
        this.pLen = size;
    }

    @Override
    protected void engineInit(AlgorithmParameterSpec genParamSpec, SecureRandom random) throws InvalidAlgorithmParameterException {
        if (genParamSpec == null || !genParamSpec.getClass().getName().equals("java.security.spec.DSAGenParameterSpec")) {
            throw new InvalidAlgorithmParameterException("Expected DSAGenParameterSpec");
        }
        this.initDsaParams((DSAGenParameterSpec)genParamSpec);
    }

    private int getDefault(int keyBits) {
        if (keyBits == 2048) {
            return 224;
        }
        if (keyBits == 3072) {
            return 256;
        }
        throw new InvalidParameterException("Only 2048 and 3072 bit parameter generation supported.");
    }

    private void initDsaParams(DSAGenParameterSpec spec) throws InvalidAlgorithmParameterException {
        if (!this.isValidPlenQlen(spec.getPrimePLength(), spec.getSubprimeQLength())) {
            throw new InvalidAlgorithmParameterException("Unsupported generation params,(Plen,QLen) must be one of (2048,224), (2048, 256), (3072, 256).");
        }
        this.pLen = spec.getPrimePLength();
        this.qLen = spec.getSubprimeQLength();
    }

    private boolean isValidPlenQlen(int pLen, int qLen) {
        if (pLen == 2048 && qLen == 224) {
            return true;
        }
        if (pLen == 2048 && qLen == 256) {
            return true;
        }
        return pLen == 3072 && qLen == 256;
    }

    @Override
    protected AlgorithmParameters engineGenerateParameters() {
        DSAParameterSpec dsaParams;
        PkeyCtx.DsaParamGen gen = new PkeyCtx.DsaParamGen();
        Pkey params = null;
        try {
            gen.setParams(this.pLen, this.qLen);
            params = gen.generate();
            byte[][] pqg = params.getDsaParams();
            dsaParams = new DSAParameterSpec(new BigInteger(1, pqg[0]), new BigInteger(1, pqg[1]), new BigInteger(1, pqg[2]));
            gen.free();
        }
        catch (InvalidKeyException e) {
            try {
                throw new ProviderException(e.getMessage());
            }
            catch (Throwable throwable) {
                gen.free();
                Pkey.free(params);
                throw throwable;
            }
        }
        Pkey.free(params);
        try {
            AlgorithmParameters ap = AlgorithmParameters.getInstance("DSA", InternalProvider.get());
            ap.init(dsaParams);
            return ap;
        }
        catch (NoSuchAlgorithmException | InvalidParameterSpecException e) {
            throw new ProviderException(e);
        }
    }
}

