/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jipher.internal.openssl;

import com.oracle.jipher.internal.common.MultiRelease;
import com.oracle.jipher.internal.openssl.OpenSsl;

abstract class OsslObject
implements AutoCloseable {
    private final BaseState state;
    OpenSsl openssl;
    long ptr;
    private final Object cleanable;

    OsslObject(BaseState state) {
        this.state = state;
        this.openssl = state.openssl;
        this.ptr = state.ptr;
        this.cleanable = MultiRelease.CLEANER_INSTANCE.register(this, this.state);
    }

    public void free() {
        this.close();
    }

    @Override
    public void close() {
        this.ptr = 0L;
        MultiRelease.clean(this.cleanable);
    }

    static abstract class BaseState
    implements Runnable {
        final OpenSsl openssl;
        final long ptr;

        BaseState(OpenSsl openssl, long ptr) {
            this.openssl = openssl;
            this.ptr = ptr;
        }

        @Override
        public final void run() {
            this.free(this.ptr);
        }

        abstract void free(long var1);
    }
}

