// CheckStyle: stop header check
// CheckStyle: stop line length check
// GENERATED CONTENT - DO NOT EDIT
// Source: ConfigurationFiles.java
package com.oracle.svm.core.configure;

import java.util.*;
import org.graalvm.compiler.options.*;
import org.graalvm.compiler.options.OptionType;
import org.graalvm.compiler.options.OptionStability;

public class ConfigurationFiles_OptionDescriptors implements OptionDescriptors {
    @Override
    public OptionDescriptor get(String value) {
        switch (value) {
        // CheckStyle: stop line length check
        case "ConfigurationFileDirectories": {
            return OptionDescriptor.create(
                /*name*/ "ConfigurationFileDirectories",
                /*optionType*/ OptionType.User,
                /*optionValueType*/ com.oracle.svm.core.option.LocatableMultiOptionValue.Paths.class,
                /*help*/ "Directories directly containing configuration files for dynamic features at runtime.",
                /*declaringClass*/ ConfigurationFiles.Options.class,
                /*fieldName*/ "ConfigurationFileDirectories",
                /*option*/ ConfigurationFiles.Options.ConfigurationFileDirectories,
                /*stability*/ OptionStability.STABLE,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "ConfigurationResourceRoots": {
            return OptionDescriptor.create(
                /*name*/ "ConfigurationResourceRoots",
                /*optionType*/ OptionType.User,
                /*optionValueType*/ com.oracle.svm.core.option.LocatableMultiOptionValue.Strings.class,
                /*help*/ "Resource path above configuration resources for dynamic features at runtime.",
                /*declaringClass*/ ConfigurationFiles.Options.class,
                /*fieldName*/ "ConfigurationResourceRoots",
                /*option*/ ConfigurationFiles.Options.ConfigurationResourceRoots,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "DynamicProxyConfigurationFiles": {
            return OptionDescriptor.create(
                /*name*/ "DynamicProxyConfigurationFiles",
                /*optionType*/ OptionType.User,
                /*optionValueType*/ com.oracle.svm.core.option.LocatableMultiOptionValue.Paths.class,
                /*help*/ "One or several (comma-separated) paths to JSON files that specify lists of interfaces that define Java proxy classes.",
                /*extraHelp*/ new String[] {
                         "",
                         "The JSON structure is described in the following schema:",
                         "",
                         "  https://github.com/oracle/graal/blob/master/docs/reference-manual/native-image/assets/proxy-config-schema-v1.0.0.json",
                         "",
                         "An example file contents follows:",
                         "",
                         "    [",
                         "      {",
                         "        \"condition\" : {",
                         "          \"typeReachable\" : \"org.example.CallingClass\"",
                         "        },",
                         "        \"interfaces\" : [",
                         "          \"java.lang.AutoCloseable\",",
                         "          \"java.util.Comparator\"",
                         "        ]",
                         "      },",
                         "      {",
                         "        \"condition\" : {",
                         "          \"typeReachable\" : \"org.example.CallingClass\"",
                         "        },",
                         "        \"interfaces\" : [",
                         "          \"java.util.Comparator\"",
                         "        ]",
                         "      }",
                         "    ]",
                              },
                /*declaringClass*/ ConfigurationFiles.Options.class,
                /*fieldName*/ "DynamicProxyConfigurationFiles",
                /*option*/ ConfigurationFiles.Options.DynamicProxyConfigurationFiles,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "DynamicProxyConfigurationResources": {
            return OptionDescriptor.create(
                /*name*/ "DynamicProxyConfigurationResources",
                /*optionType*/ OptionType.User,
                /*optionValueType*/ com.oracle.svm.core.option.LocatableMultiOptionValue.Strings.class,
                /*help*/ "Resources describing program elements to be made available for reflection (see ProxyConfigurationFiles).",
                /*declaringClass*/ ConfigurationFiles.Options.class,
                /*fieldName*/ "DynamicProxyConfigurationResources",
                /*option*/ ConfigurationFiles.Options.DynamicProxyConfigurationResources,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "ForeignConfigurationFiles": {
            return OptionDescriptor.create(
                /*name*/ "ForeignConfigurationFiles",
                /*optionType*/ OptionType.User,
                /*optionValueType*/ com.oracle.svm.core.option.LocatableMultiOptionValue.Paths.class,
                /*help*/ "Files describing stubs allowing foreign calls.",
                /*declaringClass*/ ConfigurationFiles.Options.class,
                /*fieldName*/ "ForeignConfigurationFiles",
                /*option*/ ConfigurationFiles.Options.ForeignConfigurationFiles,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "ForeignResources": {
            return OptionDescriptor.create(
                /*name*/ "ForeignResources",
                /*optionType*/ OptionType.User,
                /*optionValueType*/ com.oracle.svm.core.option.LocatableMultiOptionValue.Strings.class,
                /*help*/ "Resources describing stubs allowing foreign calls.",
                /*declaringClass*/ ConfigurationFiles.Options.class,
                /*fieldName*/ "ForeignResources",
                /*option*/ ConfigurationFiles.Options.ForeignResources,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "JNIConfigurationFiles": {
            return OptionDescriptor.create(
                /*name*/ "JNIConfigurationFiles",
                /*optionType*/ OptionType.User,
                /*optionValueType*/ com.oracle.svm.core.option.LocatableMultiOptionValue.Paths.class,
                /*help*/ "Files describing program elements to be made accessible via JNI (for syntax, see ReflectionConfigurationFiles)",
                /*declaringClass*/ ConfigurationFiles.Options.class,
                /*fieldName*/ "JNIConfigurationFiles",
                /*option*/ ConfigurationFiles.Options.JNIConfigurationFiles,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "JNIConfigurationResources": {
            return OptionDescriptor.create(
                /*name*/ "JNIConfigurationResources",
                /*optionType*/ OptionType.User,
                /*optionValueType*/ com.oracle.svm.core.option.LocatableMultiOptionValue.Strings.class,
                /*help*/ "Resources describing program elements to be made accessible via JNI (see JNIConfigurationFiles).",
                /*declaringClass*/ ConfigurationFiles.Options.class,
                /*fieldName*/ "JNIConfigurationResources",
                /*option*/ ConfigurationFiles.Options.JNIConfigurationResources,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "PredefinedClassesConfigurationFiles": {
            return OptionDescriptor.create(
                /*name*/ "PredefinedClassesConfigurationFiles",
                /*optionType*/ OptionType.User,
                /*optionValueType*/ com.oracle.svm.core.option.LocatableMultiOptionValue.Paths.class,
                /*help*/ "Files describing predefined classes that can be loaded at runtime according to the schema at https://github.com/oracle/graal/blob/master/docs/reference-manual/native-image/assets/predefined-classes-config-schema-v1.0.0.json",
                /*declaringClass*/ ConfigurationFiles.Options.class,
                /*fieldName*/ "PredefinedClassesConfigurationFiles",
                /*option*/ ConfigurationFiles.Options.PredefinedClassesConfigurationFiles,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "PredefinedClassesConfigurationResources": {
            return OptionDescriptor.create(
                /*name*/ "PredefinedClassesConfigurationResources",
                /*optionType*/ OptionType.User,
                /*optionValueType*/ com.oracle.svm.core.option.LocatableMultiOptionValue.Strings.class,
                /*help*/ "Resources describing predefined classes that can be loaded at runtime according to the schema at https://github.com/oracle/graal/blob/master/docs/reference-manual/native-image/assets/predefined-classes-config-schema-v1.0.0.json",
                /*declaringClass*/ ConfigurationFiles.Options.class,
                /*fieldName*/ "PredefinedClassesConfigurationResources",
                /*option*/ ConfigurationFiles.Options.PredefinedClassesConfigurationResources,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "ReachabilityMetadataResources": {
            return OptionDescriptor.create(
                /*name*/ "ReachabilityMetadataResources",
                /*optionType*/ OptionType.User,
                /*optionValueType*/ com.oracle.svm.core.option.LocatableMultiOptionValue.Strings.class,
                /*help*/ "Resources describing reachability metadata needed for the program https://github.com/oracle/graal/blob/master/docs/reference-manual/native-image/assets/reachability-metadata-schema-v1.0.0.json",
                /*declaringClass*/ ConfigurationFiles.Options.class,
                /*fieldName*/ "ReachabilityMetadataResources",
                /*option*/ ConfigurationFiles.Options.ReachabilityMetadataResources,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "ReflectionConfigurationFiles": {
            return OptionDescriptor.create(
                /*name*/ "ReflectionConfigurationFiles",
                /*optionType*/ OptionType.User,
                /*optionValueType*/ com.oracle.svm.core.option.LocatableMultiOptionValue.Paths.class,
                /*help*/ "One or several (comma-separated) paths to JSON files that specify which program elements should be made available via reflection.",
                /*extraHelp*/ new String[] {
                         "",
                         "The JSON object schema is described at:",
                         "",
                         "   https://github.com/oracle/graal/blob/master/docs/reference-manual/native-image/assets/reflect-config-schema-v1.1.0.json",
                         "",
                         "Example:",
                         "",
                         "	[",
                         "	  {",
                         "	    \"condition\" : {",
                         "          \"typeReachable\" : \"org.example.CallingClass\"",
                         "        },",
                         "	    \"name\" : \"java.lang.Class\",",
                         "	    \"allDeclaredConstructors\" : \"true\",",
                         "	    \"allPublicConstructors\" : \"true\",",
                         "	    \"allDeclaredMethods\" : \"true\",",
                         "	    \"allPublicMethods\" : \"true\"",
                         "	  },",
                         "	  {",
                         "	    \"condition\" : {",
                         "          \"typeReachable\" : \"org.example.CallingClass\"",
                         "        },",
                         "	    \"name\" : \"java.lang.String\",",
                         "	    \"fields\" : [",
                         "	      { \"name\" : \"value\" },",
                         "	      { \"name\" : \"hash\" }",
                         "	    ],",
                         "	    \"methods\" : [",
                         "	      { \"name\" : \"<init>\", \"parameterTypes\" : [] },",
                         "	      { \"name\" : \"<init>\", \"parameterTypes\" : [\"char[]\"] },",
                         "	      { \"name\" : \"charAt\" },",
                         "	      { \"name\" : \"format\", \"parameterTypes\" : [\"java.lang.String\", \"java.lang.Object[]\"] },",
                         "	    ]",
                         "	  },",
                         "      {",
                         "        \"condition\" : {",
                         "          \"typeReachable\" : \"org.example.CallingClass\"",
                         "        },",
                         "        \"name\" : \"java.lang.String$CaseInsensitiveComparator\",",
                         "        \"methods\" : [",
                         "          { \"name\" : \"compare\" }",
                         "        ]",
                         "      }",
                         "	]",
                              },
                /*declaringClass*/ ConfigurationFiles.Options.class,
                /*fieldName*/ "ReflectionConfigurationFiles",
                /*option*/ ConfigurationFiles.Options.ReflectionConfigurationFiles,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "ReflectionConfigurationResources": {
            return OptionDescriptor.create(
                /*name*/ "ReflectionConfigurationResources",
                /*optionType*/ OptionType.User,
                /*optionValueType*/ com.oracle.svm.core.option.LocatableMultiOptionValue.Strings.class,
                /*help*/ "Resources describing program elements to be made available for reflection (see ReflectionConfigurationFiles).",
                /*declaringClass*/ ConfigurationFiles.Options.class,
                /*fieldName*/ "ReflectionConfigurationResources",
                /*option*/ ConfigurationFiles.Options.ReflectionConfigurationResources,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "ResourceConfigurationFiles": {
            return OptionDescriptor.create(
                /*name*/ "ResourceConfigurationFiles",
                /*optionType*/ OptionType.User,
                /*optionValueType*/ com.oracle.svm.core.option.LocatableMultiOptionValue.Paths.class,
                /*help*/ "Files describing Java resources to be included in the image according to the schema at https://github.com/oracle/graal/blob/master/docs/reference-manual/native-image/assets/resource-config-schema-v1.0.0.json",
                /*declaringClass*/ ConfigurationFiles.Options.class,
                /*fieldName*/ "ResourceConfigurationFiles",
                /*option*/ ConfigurationFiles.Options.ResourceConfigurationFiles,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "ResourceConfigurationResources": {
            return OptionDescriptor.create(
                /*name*/ "ResourceConfigurationResources",
                /*optionType*/ OptionType.User,
                /*optionValueType*/ com.oracle.svm.core.option.LocatableMultiOptionValue.Strings.class,
                /*help*/ "Resources describing Java resources to be included in the image according to the schema at https://github.com/oracle/graal/blob/master/docs/reference-manual/native-image/assets/resource-config-schema-v1.0.0.json",
                /*declaringClass*/ ConfigurationFiles.Options.class,
                /*fieldName*/ "ResourceConfigurationResources",
                /*option*/ ConfigurationFiles.Options.ResourceConfigurationResources,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "SerializationConfigurationFiles": {
            return OptionDescriptor.create(
                /*name*/ "SerializationConfigurationFiles",
                /*optionType*/ OptionType.User,
                /*optionValueType*/ com.oracle.svm.core.option.LocatableMultiOptionValue.Paths.class,
                /*help*/ "One or several (comma-separated) paths to JSON files that specify lists of serialization configurations.",
                /*extraHelp*/ new String[] {
                         "",
                         "The structure is described in the following schema:",
                         "",
                         "  https://github.com/oracle/graal/blob/master/docs/reference-manual/native-image/assets/serialization-config-schema-v1.1.0.json",
                         "",
                         "Example:",
                         "",
                         "    [",
                         "      {",
                         "        \"condition\" : {",
                         "          \"typeReachable\" : \"app.DataSerializer\"",
                         "        },",
                         "        \"name\" : \"java.util.ArrayList\"",
                         "      }",
                         "    ]",
                         "",
                         "For deserializing lambda classes, the capturing class of the lambda needs to be specified in a separate section of the configuration file, for example:",
                         "",
                         "    [",
                         "      \"types\" : [",
                         "        {",
                         "          \"name\" : \"java.lang.Object\"",
                         "        }",
                         "      ],",
                         "      \"lambdaCapturingTypes\" : [",
                         "        {",
                         "          \"name\" : \"java.util.Comparator\"",
                         "        }",
                         "      ]",
                         "    ]",
                         "",
                         "This JSON file format is also used for the serialization deny list.",
                         "",
                         "In rare cases an application might explicitly make calls to",
                         "",
                         "    ReflectionFactory.newConstructorForSerialization(Class<?> cl, Constructor<?> constructorToCall)",
                         "",
                         "where the passed `constructorToCall` differs from what would automatically be used if regular serialization of `cl`",
                         "would happen. To also support such serialization usecases it is possible to register serialization for a class with a",
                         "custom constructorToCall. For example, to allow serialization of `org.apache.spark.SparkContext$$anonfun$hadoopFile$1`",
                         "using the DeclaredConstructor of java.lang.Object as custom targetConstructor the following can be used in",
                         "serialization-config.json:",
                         "",
                         "    [",
                         "      {",
                         "        \"condition\" : {",
                         "          \"typeReachable\" : \"org.apache.spark.SparkContext\"",
                         "        },",
                         "        \"name\" : \"org.apache.spark.SparkContext$$anonfun$hadoopFile$1\",",
                         "        \"customTargetConstructorClass\" : \"java.lang.Object\"",
                         "      }",
                         "    ]",
                              },
                /*declaringClass*/ ConfigurationFiles.Options.class,
                /*fieldName*/ "SerializationConfigurationFiles",
                /*option*/ ConfigurationFiles.Options.SerializationConfigurationFiles,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "SerializationConfigurationResources": {
            return OptionDescriptor.create(
                /*name*/ "SerializationConfigurationResources",
                /*optionType*/ OptionType.User,
                /*optionValueType*/ com.oracle.svm.core.option.LocatableMultiOptionValue.Strings.class,
                /*help*/ "Resources describing program elements to be made available for serialization (see SerializationConfigurationFiles).",
                /*declaringClass*/ ConfigurationFiles.Options.class,
                /*fieldName*/ "SerializationConfigurationResources",
                /*option*/ ConfigurationFiles.Options.SerializationConfigurationResources,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "SerializationDenyConfigurationFiles": {
            return OptionDescriptor.create(
                /*name*/ "SerializationDenyConfigurationFiles",
                /*optionType*/ OptionType.User,
                /*optionValueType*/ com.oracle.svm.core.option.LocatableMultiOptionValue.Paths.class,
                /*help*/ "One or several (comma-separated) paths to JSON files that specify lists of serialization configurations.",
                /*extraHelp*/ new String[] {
                         "",
                         "The structure is described in the following schema:",
                         "",
                         "  https://github.com/oracle/graal/blob/master/docs/reference-manual/native-image/assets/serialization-config-schema-v1.1.0.json",
                         "",
                         "Example:",
                         "",
                         "    [",
                         "      {",
                         "        \"condition\" : {",
                         "          \"typeReachable\" : \"app.DataSerializer\"",
                         "        },",
                         "        \"name\" : \"java.util.ArrayList\"",
                         "      }",
                         "    ]",
                         "",
                         "For deserializing lambda classes, the capturing class of the lambda needs to be specified in a separate section of the configuration file, for example:",
                         "",
                         "    [",
                         "      \"types\" : [",
                         "        {",
                         "          \"name\" : \"java.lang.Object\"",
                         "        }",
                         "      ],",
                         "      \"lambdaCapturingTypes\" : [",
                         "        {",
                         "          \"name\" : \"java.util.Comparator\"",
                         "        }",
                         "      ]",
                         "    ]",
                         "",
                         "This JSON file format is also used for the serialization deny list.",
                         "",
                         "In rare cases an application might explicitly make calls to",
                         "",
                         "    ReflectionFactory.newConstructorForSerialization(Class<?> cl, Constructor<?> constructorToCall)",
                         "",
                         "where the passed `constructorToCall` differs from what would automatically be used if regular serialization of `cl`",
                         "would happen. To also support such serialization usecases it is possible to register serialization for a class with a",
                         "custom constructorToCall. For example, to allow serialization of `org.apache.spark.SparkContext$$anonfun$hadoopFile$1`",
                         "using the DeclaredConstructor of java.lang.Object as custom targetConstructor the following can be used in",
                         "serialization-config.json:",
                         "",
                         "    [",
                         "      {",
                         "        \"condition\" : {",
                         "          \"typeReachable\" : \"org.apache.spark.SparkContext\"",
                         "        },",
                         "        \"name\" : \"org.apache.spark.SparkContext$$anonfun$hadoopFile$1\",",
                         "        \"customTargetConstructorClass\" : \"java.lang.Object\"",
                         "      }",
                         "    ]",
                              },
                /*declaringClass*/ ConfigurationFiles.Options.class,
                /*fieldName*/ "SerializationDenyConfigurationFiles",
                /*option*/ ConfigurationFiles.Options.SerializationDenyConfigurationFiles,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "SerializationDenyConfigurationResources": {
            return OptionDescriptor.create(
                /*name*/ "SerializationDenyConfigurationResources",
                /*optionType*/ OptionType.User,
                /*optionValueType*/ com.oracle.svm.core.option.LocatableMultiOptionValue.Strings.class,
                /*help*/ "Resources describing program elements that must not be made available for serialization.",
                /*declaringClass*/ ConfigurationFiles.Options.class,
                /*fieldName*/ "SerializationDenyConfigurationResources",
                /*option*/ ConfigurationFiles.Options.SerializationDenyConfigurationResources,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "StrictConfiguration": {
            return OptionDescriptor.create(
                /*name*/ "StrictConfiguration",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "When configuration files do not match their schema, abort the image build instead of emitting a warning.",
                /*declaringClass*/ ConfigurationFiles.Options.class,
                /*fieldName*/ "StrictConfiguration",
                /*option*/ ConfigurationFiles.Options.StrictConfiguration,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "WarnAboutMissingReflectionOrJNIMetadataElements": {
            return OptionDescriptor.create(
                /*name*/ "WarnAboutMissingReflectionOrJNIMetadataElements",
                /*optionType*/ OptionType.Expert,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Warn when reflection and JNI configuration files have elements that could not be found on the classpath or modulepath.",
                /*declaringClass*/ ConfigurationFiles.Options.class,
                /*fieldName*/ "WarnAboutMissingReflectionOrJNIMetadataElements",
                /*option*/ ConfigurationFiles.Options.WarnAboutMissingReflectionOrJNIMetadataElements,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        // CheckStyle: resume line length check
        }
        return null;
    }

    @Override
    public Iterator<OptionDescriptor> iterator() {
        return new Iterator<>() {
            int i = 0;
            @Override
            public boolean hasNext() {
                return i < 21;
            }
            @Override
            public OptionDescriptor next() {
                switch (i++) {
                    case 0: return get("ConfigurationFileDirectories");
                    case 1: return get("ConfigurationResourceRoots");
                    case 2: return get("DynamicProxyConfigurationFiles");
                    case 3: return get("DynamicProxyConfigurationResources");
                    case 4: return get("ForeignConfigurationFiles");
                    case 5: return get("ForeignResources");
                    case 6: return get("JNIConfigurationFiles");
                    case 7: return get("JNIConfigurationResources");
                    case 8: return get("PredefinedClassesConfigurationFiles");
                    case 9: return get("PredefinedClassesConfigurationResources");
                    case 10: return get("ReachabilityMetadataResources");
                    case 11: return get("ReflectionConfigurationFiles");
                    case 12: return get("ReflectionConfigurationResources");
                    case 13: return get("ResourceConfigurationFiles");
                    case 14: return get("ResourceConfigurationResources");
                    case 15: return get("SerializationConfigurationFiles");
                    case 16: return get("SerializationConfigurationResources");
                    case 17: return get("SerializationDenyConfigurationFiles");
                    case 18: return get("SerializationDenyConfigurationResources");
                    case 19: return get("StrictConfiguration");
                    case 20: return get("WarnAboutMissingReflectionOrJNIMetadataElements");
                }
                throw new NoSuchElementException();
            }
        };
    }
}
