/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.foreign;

import com.oracle.svm.core.FunctionPointerHolder;
import com.oracle.svm.core.OS;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.foreign.NativeEntryPointInfo;
import com.oracle.svm.core.headers.LibC;
import com.oracle.svm.core.headers.WindowsAPIs;
import com.oracle.svm.core.snippets.SnippetRuntime;
import com.oracle.svm.core.snippets.SubstrateForeignCallTarget;
import com.oracle.svm.core.util.VMError;
import jdk.internal.foreign.abi.CapturableState;
import org.graalvm.collections.EconomicMap;
import org.graalvm.compiler.api.replacements.Fold;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.c.function.CFunctionPointer;
import org.graalvm.nativeimage.c.type.CIntPointer;
import org.graalvm.word.LocationIdentity;

public class ForeignFunctionsRuntime {
    private final EconomicMap<NativeEntryPointInfo, FunctionPointerHolder> downcallStubs = EconomicMap.create();
    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static final SnippetRuntime.SubstrateForeignCallDescriptor CAPTURE_CALL_STATE = SnippetRuntime.findForeignCall(ForeignFunctionsRuntime.class, (String)"captureCallState", (boolean)false, (LocationIdentity[])new LocationIdentity[]{LocationIdentity.any()});

    @Fold
    public static ForeignFunctionsRuntime singleton() {
        return (ForeignFunctionsRuntime)ImageSingletons.lookup(ForeignFunctionsRuntime.class);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public void addDowncallStubPointer(NativeEntryPointInfo nep, CFunctionPointer ptr) {
        VMError.guarantee((!this.downcallStubs.containsKey((Object)nep) ? 1 : 0) != 0, (String)("Seems like multiple stubs were generated for " + String.valueOf(nep)));
        VMError.guarantee((this.downcallStubs.put((Object)nep, (Object)new FunctionPointerHolder(ptr)) == null ? 1 : 0) != 0);
    }

    public CFunctionPointer getDowncallStubPointer(NativeEntryPointInfo nep) {
        FunctionPointerHolder pointer = (FunctionPointerHolder)this.downcallStubs.get((Object)nep);
        if (pointer == null) {
            throw new UnregisteredForeignStubException(nep);
        }
        return pointer.functionPointer;
    }

    @Fold
    public static int getMask(CapturableState state) {
        return state.mask();
    }

    @Fold
    public static boolean isWindows() {
        return OS.WINDOWS.isCurrent();
    }

    @Uninterruptible(reason="Interruptions might change call state.")
    @SubstrateForeignCallTarget(stubCallingConvention=false, fullyUninterruptible=true)
    public static void captureCallState(int statesToCapture, CIntPointer captureBuffer) {
        assert (statesToCapture != 0);
        assert (captureBuffer.isNonNull());
        int i = 0;
        if (ForeignFunctionsRuntime.isWindows()) {
            assert (WindowsAPIs.isSupported()) : "Windows APIs should be supported on Windows OS";
            if ((statesToCapture & ForeignFunctionsRuntime.getMask(CapturableState.GET_LAST_ERROR)) != 0) {
                captureBuffer.write(i, WindowsAPIs.getLastError());
            }
            ++i;
            if ((statesToCapture & ForeignFunctionsRuntime.getMask(CapturableState.WSA_GET_LAST_ERROR)) != 0) {
                captureBuffer.write(i, WindowsAPIs.wsaGetLastError());
            }
            ++i;
        }
        assert (LibC.isSupported()) : "LibC should always be supported";
        if ((statesToCapture & ForeignFunctionsRuntime.getMask(CapturableState.ERRNO)) != 0) {
            captureBuffer.write(i, LibC.errno());
        }
        ++i;
    }

    public static class UnregisteredForeignStubException
    extends RuntimeException {
        UnregisteredForeignStubException(NativeEntryPointInfo nep) {
            super(UnregisteredForeignStubException.generateMessage(nep));
        }

        private static String generateMessage(NativeEntryPointInfo nep) {
            return "Cannot perform downcall with leaf type " + String.valueOf(nep.methodType()) + " as it was not registered at compilation time.";
        }
    }
}

