/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jipher.pki.ocsp;

import com.oracle.jipher.pki.internal.AlgIdException;
import com.oracle.jipher.pki.internal.AlgorithmId;
import com.oracle.jipher.pki.internal.Debug;
import com.oracle.jipher.pki.internal.RandBytes;
import com.oracle.jipher.pki.ocsp.CertId;
import com.oracle.jipher.pki.x509.AuthInfoAccess;
import com.oracle.jipher.pki.x509.GeneralName;
import com.oracle.jipher.tools.asn1.Asn1;
import com.oracle.jipher.tools.asn1.Asn1BerValue;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class OcspRequest {
    static final String NONCE_OID = "1.3.6.1.5.5.7.48.1.2";
    private static final String SERVICE_LOCATOR_OID = "1.3.6.1.5.5.7.48.1.7";
    private byte[] der;
    private byte[] nonce;
    private X509Certificate targetCert;
    private X509Certificate issuer;
    private Debug debug = Debug.getInstance("ocsp");

    private OcspRequest() {
    }

    public X509Certificate getTarget() {
        return this.targetCert;
    }

    public X509Certificate getIssuer() {
        return this.issuer;
    }

    public byte[] getEncoded() {
        return Arrays.copyOf(this.der, this.der.length);
    }

    public byte[] getNonce() {
        return this.nonce == null ? null : (byte[])this.nonce.clone();
    }

    static /* synthetic */ byte[] access$102(OcspRequest x0, byte[] x1) {
        x0.der = x1;
        return x1;
    }

    static /* synthetic */ byte[] access$402(OcspRequest x0, byte[] x1) {
        x0.nonce = x1;
        return x1;
    }

    public static class Builder {
        private static final int DEFAULT_NONCE_LEN = 16;
        private static final String DEFAULT_HASH_ALG = "SHA-1";
        private X509Certificate targetCert;
        private X509Certificate issuerCert;
        private boolean nonceEnabled;
        private boolean serviceLocatorEnabled;
        private String signAlg;
        private PrivateKey signKey;
        private List<X509Certificate> signCerts;
        private String hashAlg = "SHA-1";
        private GeneralName requestor;
        private Debug debug = Debug.getInstance("OCSP");

        public Builder(X509Certificate target, X509Certificate issuer) {
            this.targetCert = target;
            this.issuerCert = issuer;
        }

        public Builder hashAlg(String alg) {
            this.hashAlg = alg;
            return this;
        }

        public Builder nonceEnabled(boolean include) {
            this.nonceEnabled = include;
            return this;
        }

        public Builder signInfo(String alg, PrivateKey key, X509Certificate ... signCerts) {
            if (key == null) {
                throw new IllegalArgumentException("Signing PrivateKey must be specified.");
            }
            this.signAlg = alg == null ? this.defaultSignAlg(key.getAlgorithm()) : alg;
            this.signKey = key;
            this.signCerts = signCerts == null ? null : Arrays.asList(signCerts);
            return this;
        }

        public Builder serviceLocatorEnabled(boolean enabled) {
            this.serviceLocatorEnabled = enabled;
            return this;
        }

        public Builder requestor(GeneralName requestor) {
            this.requestor = requestor;
            return this;
        }

        public OcspRequest build() throws NoSuchAlgorithmException, SignatureException, CertificateEncodingException, InvalidKeyException {
            try {
                byte[] nonce = this.nonceEnabled ? RandBytes.generate(16) : null;
                Asn1BerValue berValue = this.buildAsn1BerValue(nonce);
                OcspRequest req = new OcspRequest();
                OcspRequest.access$102(req, berValue.encodeDerOctets());
                req.targetCert = this.targetCert;
                req.issuer = this.issuerCert;
                OcspRequest.access$402(req, nonce);
                return req;
            }
            catch (AlgIdException e) {
                throw new NoSuchAlgorithmException(e);
            }
        }

        private String defaultSignAlg(String keyAlg) {
            if ("EC".equalsIgnoreCase(keyAlg)) {
                return "SHA256withECDSA";
            }
            if ("RSA".equalsIgnoreCase(keyAlg)) {
                return "SHA256withRSA";
            }
            if ("DSA".equalsIgnoreCase(keyAlg)) {
                return "SHA256WithDSA";
            }
            throw new IllegalArgumentException("Unsupported PrivateKey for signing.");
        }

        private Asn1BerValue buildAsn1BerValue(byte[] nonce) throws AlgIdException, NoSuchAlgorithmException, SignatureException, CertificateEncodingException, InvalidKeyException {
            Asn1BerValue tbsReq = Asn1.newSequence(this.getRequestor(), this.getRequestList(), this.getRequestExtensions(nonce));
            Asn1BerValue sig = this.getSignature(tbsReq);
            if (sig != null) {
                return Asn1.newSequence(tbsReq, Asn1.newExplicitTag(0, sig));
            }
            return Asn1.newSequence(tbsReq);
        }

        private Asn1BerValue getRequestList() throws AlgIdException, NoSuchAlgorithmException {
            return Asn1.newSequence(this.getRequest(this.targetCert, this.issuerCert));
        }

        private Asn1BerValue getRequestor() {
            if (this.requestor == null) {
                return null;
            }
            return Asn1.newExplicitTag(1, Asn1.decodeOne(this.requestor.getEncoded()));
        }

        private Asn1BerValue getRequestExtensions(byte[] nonce) {
            if (nonce == null) {
                return null;
            }
            Asn1BerValue nonceExt = Asn1.newSequence(Asn1.newOid(OcspRequest.NONCE_OID), Asn1.newOctetString(Asn1.newOctetString(nonce).encodeDerOctets()));
            return Asn1.explicit(2).newSequence(nonceExt);
        }

        private Asn1BerValue getRequest(X509Certificate cert, X509Certificate issuer) throws AlgIdException, NoSuchAlgorithmException {
            CertId certId = CertId.create(AlgorithmId.newInstance(this.hashAlg), cert, issuer);
            this.debug.println(() -> "Request for cert [" + cert.getSubjectX500Principal() + "] (id=" + certId + ")");
            return Asn1.newSequence(certId.toAsn1BerValue(), this.getSingleRequestExtensions(cert));
        }

        private Asn1BerValue getSingleRequestExtensions(X509Certificate cert) {
            if (!this.serviceLocatorEnabled) {
                return null;
            }
            byte[] aiaExt = cert.getExtensionValue("1.3.6.1.5.5.7.1.1");
            if (aiaExt == null) {
                this.debug.println("No ServiceLocator extension added to request (AIA not present in cert)");
                return null;
            }
            byte[] aiaContent = Asn1.decodeOne(aiaExt).getOctetString();
            Asn1BerValue serviceLocator = Asn1.newSequence(Asn1.decodeOne(cert.getIssuerX500Principal().getEncoded()), Asn1.decodeOne(aiaContent));
            this.debug.println(() -> "Adding ServiceLocator extension: " + AuthInfoAccess.decode(cert));
            Asn1BerValue slExt = Asn1.newSequence(Asn1.newOid(OcspRequest.SERVICE_LOCATOR_OID), Asn1.newOctetString(serviceLocator.encodeDerOctets()));
            return Asn1.explicit(0).newSequence(slExt);
        }

        private Asn1BerValue getSignature(Asn1BerValue tbsReq) throws AlgIdException, NoSuchAlgorithmException, InvalidKeyException, SignatureException, CertificateEncodingException {
            if (this.signKey == null) {
                this.debug.println("Sign request = false.");
                return null;
            }
            byte[] tbsBytes = tbsReq.encodeDerOctets();
            byte[] signature = this.sign(tbsBytes);
            AlgorithmId signId = AlgorithmId.newInstance(this.signAlg);
            this.debug.println(() -> "Sign request = true (alg=" + this.signAlg + ")");
            ArrayList<Asn1BerValue> sigContents = new ArrayList<Asn1BerValue>();
            sigContents.add(signId.toAsn1Value());
            sigContents.add(Asn1.newBitString(signature));
            if (this.signCerts != null && !this.signCerts.isEmpty()) {
                ArrayList<Asn1BerValue> certList = new ArrayList<Asn1BerValue>();
                for (X509Certificate cert : this.signCerts) {
                    certList.add(Asn1.decodeOne(cert.getEncoded()));
                    this.debug.println(() -> "Including sign cert [" + cert.getSubjectX500Principal() + "]");
                }
                sigContents.add(Asn1.explicit(0).newSequence(certList));
            }
            return Asn1.newSequence(sigContents);
        }

        private byte[] sign(byte[] data) throws NoSuchAlgorithmException, InvalidKeyException, SignatureException {
            Signature sign = Signature.getInstance(this.signAlg);
            sign.initSign(this.signKey);
            sign.update(data);
            return sign.sign();
        }
    }
}

