/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jipher.pki.internal;

import com.oracle.jipher.pki.internal.AlgorithmId;
import com.oracle.jipher.pki.internal.P12Attributes;
import java.nio.charset.Charset;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

abstract class P12Entry {
    Date date;
    byte[] localKeyId;
    String alias;
    P12Attributes attributes;

    private P12Entry() {
    }

    void setAttributes(P12Attributes attrs) {
        this.alias = attrs.getFriendlyName();
        this.localKeyId = attrs.getLocalKeyId();
        this.attributes = attrs;
    }

    static byte[] generateKeyId() {
        return ("Time " + new Date().getTime()).getBytes(Charset.forName("UTF8"));
    }

    private static Date determineDate(byte[] keyId) {
        String keyIdStr;
        if (keyId != null && (keyIdStr = new String(keyId, Charset.forName("UTF8"))).startsWith("Time ")) {
            try {
                return new Date(Long.parseLong(keyIdStr.substring(5)));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return new Date();
    }

    static class Cert
    extends P12Entry {
        final X509Certificate cert;

        Cert(X509Certificate cert, P12Attributes attrs) {
            this(cert);
            this.setAttributes(attrs);
        }

        Cert(X509Certificate cert) {
            this.cert = cert;
            this.date = new Date();
        }

        public String toString() {
            return "certificate entry with alias " + this.alias;
        }
    }

    static class SecretKey
    extends Key {
        SecretKey(byte[] encryptedKey, AlgorithmId algId) {
            super(encryptedKey, algId);
        }

        public String toString() {
            return "protected secret key entry with alias " + this.alias;
        }
    }

    static class PrivKey
    extends Key {
        private List<X509Certificate> chain = new ArrayList<X509Certificate>();

        PrivKey(byte[] encryptedKey, AlgorithmId algId) {
            super(encryptedKey, algId);
        }

        PrivKey(byte[] encryptedKey, AlgorithmId algId, Certificate[] arrChain) {
            this(encryptedKey, algId);
            for (Certificate c : arrChain) {
                if (!(c instanceof X509Certificate)) continue;
                this.chain.add((X509Certificate)c);
            }
        }

        void setChain(List<X509Certificate> chainCerts) {
            this.chain.addAll(chainCerts);
        }

        List<X509Certificate> getChain() {
            return this.chain;
        }

        public String toString() {
            return "protected private key entry with alias " + this.alias;
        }
    }

    static abstract class Key
    extends P12Entry {
        final byte[] encryptedKey;
        final AlgorithmId encAlgId;

        Key(byte[] encryptedKey, AlgorithmId algId) {
            this.encryptedKey = encryptedKey;
            this.encAlgId = algId;
        }

        @Override
        void setAttributes(P12Attributes attrs) {
            super.setAttributes(attrs);
            this.date = P12Entry.determineDate(this.localKeyId);
        }
    }
}

