/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.configure.trace;

import com.oracle.svm.configure.config.ConfigurationMemberInfo;
import com.oracle.svm.configure.config.ConfigurationSet;
import com.oracle.svm.configure.config.ProxyConfiguration;
import com.oracle.svm.configure.config.ResourceConfiguration;
import com.oracle.svm.configure.config.SignatureUtil;
import com.oracle.svm.configure.config.TypeConfiguration;
import com.oracle.svm.configure.trace.AbstractProcessor;
import com.oracle.svm.configure.trace.AccessAdvisor;
import com.oracle.svm.configure.trace.LazyValueUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import jdk.vm.ci.meta.MetaUtil;
import org.graalvm.collections.EconomicMap;
import org.graalvm.compiler.phases.common.LazyValue;
import org.graalvm.nativeimage.impl.ConfigurationCondition;

class ReflectionProcessor
extends AbstractProcessor {
    private final AccessAdvisor advisor;

    ReflectionProcessor(AccessAdvisor advisor) {
        this.advisor = advisor;
    }

    @Override
    public void processEntry(EconomicMap<String, ?> entry, ConfigurationSet configurationSet) {
        String clazz;
        boolean invalidResult = Boolean.FALSE.equals(entry.get((Object)"result"));
        ConfigurationCondition condition = ConfigurationCondition.alwaysTrue();
        if (invalidResult) {
            return;
        }
        String function = (String)entry.get((Object)"function");
        List args = (List)entry.get((Object)"args");
        ResourceConfiguration resourceConfiguration = configurationSet.getResourceConfiguration();
        switch (function) {
            case "findResource": 
            case "findResourceAsStream": {
                ReflectionProcessor.expectSize(args, 2);
                String module = (String)args.get(0);
                String resource = (String)args.get(1);
                resourceConfiguration.addResourcePattern(condition, (String)(module == null ? "" : module + ":") + Pattern.quote(resource));
                return;
            }
            case "getResource": 
            case "getResourceAsStream": 
            case "getSystemResource": 
            case "getSystemResourceAsStream": 
            case "getResources": 
            case "getSystemResources": {
                String literal = (String)ReflectionProcessor.singleElement(args);
                String regex = Pattern.quote(literal);
                resourceConfiguration.addResourcePattern(condition, regex);
                return;
            }
        }
        TypeConfiguration configuration = configurationSet.getReflectionConfiguration();
        String callerClass = (String)entry.get((Object)"caller_class");
        boolean isLoadClass = function.equals("loadClass");
        if (isLoadClass || function.equals("forName") || function.equals("findClass")) {
            String name = (String)ReflectionProcessor.singleElement(args);
            if (isLoadClass) {
                name = MetaUtil.internalNameToJava((String)MetaUtil.toInternalName((String)name), (boolean)true, (boolean)true);
            }
            if (!(this.advisor.shouldIgnore(LazyValueUtils.lazyValue(name), LazyValueUtils.lazyValue(callerClass)) || isLoadClass && this.advisor.shouldIgnoreLoadClass(LazyValueUtils.lazyValue(name), LazyValueUtils.lazyValue(callerClass)))) {
                configuration.getOrCreateType(condition, name);
            }
            return;
        }
        if (function.equals("methodTypeDescriptor")) {
            List typeNames = (List)ReflectionProcessor.singleElement(args);
            for (String type : typeNames) {
                if (this.advisor.shouldIgnore(LazyValueUtils.lazyValue(type), LazyValueUtils.lazyValue(callerClass))) continue;
                configuration.getOrCreateType(condition, type);
            }
        }
        if (this.advisor.shouldIgnore(LazyValueUtils.lazyValue(clazz = (String)entry.get((Object)"class")), LazyValueUtils.lazyValue(callerClass))) {
            return;
        }
        ConfigurationMemberInfo.ConfigurationMemberDeclaration declaration = ConfigurationMemberInfo.ConfigurationMemberDeclaration.PUBLIC;
        ConfigurationMemberInfo.ConfigurationMemberAccessibility accessibility = Boolean.TRUE.equals(entry.get((Object)"result")) ? ConfigurationMemberInfo.ConfigurationMemberAccessibility.ACCESSED : ConfigurationMemberInfo.ConfigurationMemberAccessibility.QUERIED;
        String clazzOrDeclaringClass = entry.containsKey((Object)"declaring_class") ? (String)entry.get((Object)"declaring_class") : clazz;
        switch (function) {
            case "getDeclaredFields": {
                configuration.getOrCreateType(condition, clazz).setAllDeclaredFields();
                break;
            }
            case "getFields": {
                configuration.getOrCreateType(condition, clazz).setAllPublicFields();
                break;
            }
            case "getDeclaredMethods": {
                configuration.getOrCreateType(condition, clazz).setAllDeclaredMethods(accessibility);
                break;
            }
            case "asInterfaceInstance": {
                accessibility = ConfigurationMemberInfo.ConfigurationMemberAccessibility.ACCESSED;
            }
            case "getMethods": {
                configuration.getOrCreateType(condition, clazz).setAllPublicMethods(accessibility);
                break;
            }
            case "getDeclaredConstructors": {
                configuration.getOrCreateType(condition, clazz).setAllDeclaredConstructors(accessibility);
                break;
            }
            case "getConstructors": {
                configuration.getOrCreateType(condition, clazz).setAllPublicConstructors(accessibility);
                break;
            }
            case "getDeclaredClasses": {
                configuration.getOrCreateType(condition, clazz).setAllDeclaredClasses();
                break;
            }
            case "getRecordComponents": {
                configuration.getOrCreateType(condition, clazz).setAllRecordComponents();
                break;
            }
            case "getPermittedSubclasses": {
                configuration.getOrCreateType(condition, clazz).setAllPermittedSubclasses();
                break;
            }
            case "getNestMembers": {
                configuration.getOrCreateType(condition, clazz).setAllNestMembers();
                break;
            }
            case "getSigners": {
                configuration.getOrCreateType(condition, clazz).setAllSigners();
                break;
            }
            case "getClasses": {
                configuration.getOrCreateType(condition, clazz).setAllPublicClasses();
                break;
            }
            case "objectFieldOffset": 
            case "findFieldHandle": 
            case "unreflectField": 
            case "getDeclaredField": {
                declaration = "findFieldHandle".equals(function) ? ConfigurationMemberInfo.ConfigurationMemberDeclaration.PRESENT : ConfigurationMemberInfo.ConfigurationMemberDeclaration.DECLARED;
            }
            case "getField": {
                configuration.getOrCreateType(condition, clazzOrDeclaringClass).addField((String)ReflectionProcessor.singleElement(args), declaration, false);
                if (clazzOrDeclaringClass.equals(clazz)) break;
                configuration.getOrCreateType(condition, clazz);
                break;
            }
            case "getDeclaredMethod": 
            case "findMethodHandle": 
            case "invokeMethod": {
                declaration = "getDeclaredMethod".equals(function) ? ConfigurationMemberInfo.ConfigurationMemberDeclaration.DECLARED : ConfigurationMemberInfo.ConfigurationMemberDeclaration.PRESENT;
            }
            case "getMethod": {
                accessibility = accessibility == ConfigurationMemberInfo.ConfigurationMemberAccessibility.ACCESSED || function.equals("invokeMethod") || function.equals("findMethodHandle") ? ConfigurationMemberInfo.ConfigurationMemberAccessibility.ACCESSED : ConfigurationMemberInfo.ConfigurationMemberAccessibility.QUERIED;
                ReflectionProcessor.expectSize(args, 2);
                String name = (String)args.get(0);
                List parameterTypes = (List)args.get(1);
                if (parameterTypes == null) {
                    parameterTypes = Collections.emptyList();
                }
                configuration.getOrCreateType(condition, clazzOrDeclaringClass).addMethod(name, SignatureUtil.toInternalSignature(parameterTypes), declaration, accessibility);
                if (clazzOrDeclaringClass.equals(clazz)) break;
                configuration.getOrCreateType(condition, clazz);
                break;
            }
            case "getDeclaredConstructor": 
            case "findConstructorHandle": 
            case "invokeConstructor": {
                declaration = "getDeclaredConstructor".equals(function) ? ConfigurationMemberInfo.ConfigurationMemberDeclaration.DECLARED : ConfigurationMemberInfo.ConfigurationMemberDeclaration.PRESENT;
            }
            case "getConstructor": {
                accessibility = accessibility == ConfigurationMemberInfo.ConfigurationMemberAccessibility.ACCESSED || function.equals("invokeConstructor") || function.equals("findConstructorHandle") ? ConfigurationMemberInfo.ConfigurationMemberAccessibility.ACCESSED : ConfigurationMemberInfo.ConfigurationMemberAccessibility.QUERIED;
                List parameterTypes = (List)ReflectionProcessor.singleElement(args);
                if (parameterTypes == null) {
                    parameterTypes = Collections.emptyList();
                }
                String signature = SignatureUtil.toInternalSignature(parameterTypes);
                assert (clazz.equals(clazzOrDeclaringClass)) : "Constructor can only be accessed via declaring class";
                configuration.getOrCreateType(condition, clazzOrDeclaringClass).addMethod("<init>", signature, declaration, accessibility);
                break;
            }
            case "getProxyClass": {
                ReflectionProcessor.expectSize(args, 2);
                this.addDynamicProxy((List)args.get(1), LazyValueUtils.lazyValue(callerClass), configurationSet.getProxyConfiguration());
                break;
            }
            case "newProxyInstance": {
                ReflectionProcessor.expectSize(args, 3);
                this.addDynamicProxy((List)args.get(1), LazyValueUtils.lazyValue(callerClass), configurationSet.getProxyConfiguration());
                break;
            }
            case "newMethodHandleProxyInstance": {
                ReflectionProcessor.expectSize(args, 1);
                this.addDynamicProxyUnchecked((List)args.get(0), Collections.singletonList("sun.invoke.WrapperInstance"), LazyValueUtils.lazyValue(callerClass), configurationSet.getProxyConfiguration());
                break;
            }
            case "getEnclosingConstructor": 
            case "getEnclosingMethod": {
                String result = (String)entry.get((Object)"result");
                ReflectionProcessor.addFullyQualifiedDeclaredMethod(result, configuration);
                break;
            }
            case "newInstance": {
                if (clazz.equals("java.lang.reflect.Array")) {
                    configuration.getOrCreateType(condition, (String)args.get(0));
                    break;
                }
                configuration.getOrCreateType(condition, clazz).addMethod("<init>", "()V", ConfigurationMemberInfo.ConfigurationMemberDeclaration.DECLARED, ConfigurationMemberInfo.ConfigurationMemberAccessibility.ACCESSED);
                break;
            }
            case "getBundleImpl": {
                ReflectionProcessor.expectSize(args, 7);
                String baseName = (String)args.get(2);
                List classNames = (List)args.get(5);
                List locales = (List)args.get(6);
                if (baseName == null) break;
                resourceConfiguration.addBundle(condition, classNames, locales, baseName);
                break;
            }
            case "allocateInstance": {
                configuration.getOrCreateType(condition, clazz).setUnsafeAllocated();
                break;
            }
            default: {
                System.err.println("Unsupported reflection method: " + function);
            }
        }
    }

    private static void addFullyQualifiedDeclaredMethod(String descriptor, TypeConfiguration configuration) {
        int sigbegin = descriptor.indexOf(40);
        int classend = descriptor.lastIndexOf(46, sigbegin - 1);
        String qualifiedClass = descriptor.substring(0, classend);
        String methodName = descriptor.substring(classend + 1, sigbegin);
        String signature = descriptor.substring(sigbegin);
        configuration.getOrCreateType(ConfigurationCondition.alwaysTrue(), qualifiedClass).addMethod(methodName, signature, ConfigurationMemberInfo.ConfigurationMemberDeclaration.DECLARED);
    }

    private void addDynamicProxy(List<?> interfaceList, LazyValue<String> callerClass, ProxyConfiguration proxyConfiguration) {
        List<String> interfaces = interfaceList;
        for (String iface : interfaces) {
            if (!this.advisor.shouldIgnore(LazyValueUtils.lazyValue(iface), callerClass)) continue;
            return;
        }
        proxyConfiguration.add(ConfigurationCondition.alwaysTrue(), interfaces);
    }

    private void addDynamicProxyUnchecked(List<?> checkedInterfaceList, List<?> uncheckedInterfaceList, LazyValue<String> callerClass, ProxyConfiguration proxyConfiguration) {
        List<?> checkedInterfaces = checkedInterfaceList;
        for (String iface : checkedInterfaces) {
            if (!this.advisor.shouldIgnore(LazyValueUtils.lazyValue(iface), callerClass)) continue;
            return;
        }
        List<?> uncheckedInterfaces = uncheckedInterfaceList;
        ArrayList<String> interfaces = new ArrayList<String>();
        interfaces.addAll(checkedInterfaces);
        interfaces.addAll(uncheckedInterfaces);
        proxyConfiguration.add(ConfigurationCondition.alwaysTrue(), interfaces);
    }
}

