/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.configure.config.conditional;

import com.oracle.svm.configure.ConfigurationBase;
import com.oracle.svm.configure.config.ConfigurationSet;
import com.oracle.svm.configure.config.conditional.ConditionalConfigurationPredicate;
import com.oracle.svm.configure.config.conditional.MethodCallNode;
import com.oracle.svm.configure.config.conditional.MethodInfo;
import com.oracle.svm.configure.filters.ComplexFilter;
import com.oracle.svm.core.configure.ConfigurationFile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.graalvm.nativeimage.impl.ConfigurationCondition;

public class ConditionalConfigurationComputer {
    private final MethodCallNode rootNode;
    private final ComplexFilter userCodeFilter;
    private final ConditionalConfigurationPredicate configurationFilter;

    public ConditionalConfigurationComputer(MethodCallNode rootNode, ComplexFilter userCodeFilter, ConditionalConfigurationPredicate configurationFilter) {
        this.rootNode = rootNode;
        this.userCodeFilter = userCodeFilter;
        this.configurationFilter = configurationFilter;
    }

    public ConfigurationSet computeConditionalConfiguration() {
        this.retainOnlyUserCodeMethodCallNodes();
        Map<MethodInfo, List<MethodCallNode>> methodCallNodes = this.mapMethodsToCallNodes();
        ConditionalConfigurationComputer.propagateConfiguration(methodCallNodes);
        return this.deduceConditionalConfiguration(methodCallNodes);
    }

    private void retainOnlyUserCodeMethodCallNodes() {
        this.retainOnlyUserCodeMethodCallNodes(this.rootNode);
    }

    private void retainOnlyUserCodeMethodCallNodes(MethodCallNode node) {
        ArrayList<MethodCallNode> calledMethods = new ArrayList<MethodCallNode>(node.calledMethods.values());
        for (MethodCallNode child2 : calledMethods) {
            this.retainOnlyUserCodeMethodCallNodes(child2);
        }
        node.calledMethods.values().removeIf(child -> {
            if (!this.userCodeFilter.includes(child.methodInfo.getJavaDeclaringClassName())) {
                child.parent.mergeSubTree((MethodCallNode)child, child.parent != this.rootNode);
                return true;
            }
            return false;
        });
    }

    private Map<MethodInfo, List<MethodCallNode>> mapMethodsToCallNodes() {
        HashMap<MethodInfo, List<MethodCallNode>> methodCallNodes = new HashMap<MethodInfo, List<MethodCallNode>>();
        ConfigurationSet emptyConfigurationSet = new ConfigurationSet();
        this.rootNode.visitPostOrder(node -> {
            if (node.configuration == null) {
                node.configuration = emptyConfigurationSet;
            }
            List callNodes = methodCallNodes.computeIfAbsent(node.methodInfo, info -> new ArrayList());
            callNodes.add(node);
        });
        return methodCallNodes;
    }

    private static Set<MethodInfo> maybePropagateConfiguration(List<MethodCallNode> callNodes) {
        if (callNodes.size() <= 1) {
            return Collections.emptySet();
        }
        ConfigurationSet commonConfig = ConditionalConfigurationComputer.findCommonConfigurationForMethod(callNodes);
        ArrayList<ConfigurationSet> newNodeConfiguration = new ArrayList<ConfigurationSet>();
        boolean hasNonEmptyNode = false;
        for (MethodCallNode node : callNodes) {
            ConfigurationSet callParentConfig = node.configuration.copyAndSubtract(commonConfig);
            if (!callParentConfig.isEmpty()) {
                hasNonEmptyNode = true;
            }
            newNodeConfiguration.add(callParentConfig);
        }
        if (!hasNonEmptyNode) {
            return Collections.emptySet();
        }
        HashSet<MethodInfo> affectedNodes = new HashSet<MethodInfo>();
        for (int i = 0; i < callNodes.size(); ++i) {
            MethodCallNode node = callNodes.get(i);
            ConfigurationSet uniqueNodeConfig = (ConfigurationSet)newNodeConfiguration.get(i);
            node.configuration = new ConfigurationSet(commonConfig);
            node.parent.configuration = node.parent.configuration.copyAndMerge(uniqueNodeConfig);
            affectedNodes.add(node.parent.methodInfo);
        }
        return affectedNodes;
    }

    private static ConfigurationSet findCommonConfigurationForMethod(List<MethodCallNode> callNodes) {
        ConfigurationSet config = null;
        for (MethodCallNode node : callNodes) {
            if (config == null) {
                config = node.configuration;
                continue;
            }
            config = config.copyAndIntersectWith(node.configuration);
        }
        return config;
    }

    private ConfigurationSet deduceConditionalConfiguration(Map<MethodInfo, List<MethodCallNode>> methodCallNodes) {
        ConfigurationSet configurationSet = new ConfigurationSet();
        MethodCallNode rootCallNode = methodCallNodes.remove(null).get(0);
        for (List<MethodCallNode> value : methodCallNodes.values()) {
            for (MethodCallNode node : value) {
                String className = node.methodInfo.getJavaDeclaringClassName();
                ConfigurationCondition condition = ConfigurationCondition.create((String)className);
                ConditionalConfigurationComputer.addConfigurationWithCondition(configurationSet, node.configuration, condition);
            }
        }
        ConditionalConfigurationComputer.addConfigurationWithCondition(configurationSet, rootCallNode.configuration, ConfigurationCondition.alwaysTrue());
        return configurationSet.filter(this.configurationFilter);
    }

    private static <T extends ConfigurationBase<T, ?>> void mergeWithCondition(ConfigurationSet destConfigSet, ConfigurationSet srcConfigSet, ConfigurationCondition condition, ConfigurationFile configType) {
        Object destConfig = destConfigSet.getConfiguration(configType);
        Object srcConfig = srcConfigSet.getConfiguration(configType);
        ((ConfigurationBase)destConfig).mergeConditional(condition, srcConfig);
    }

    private static void addConfigurationWithCondition(ConfigurationSet destConfigSet, ConfigurationSet srcConfigSet, ConfigurationCondition condition) {
        for (ConfigurationFile configType : ConfigurationFile.agentGeneratedFiles()) {
            ConditionalConfigurationComputer.mergeWithCondition(destConfigSet, srcConfigSet, condition, configType);
        }
    }

    private static void propagateConfiguration(Map<MethodInfo, List<MethodCallNode>> methodCallNodes) {
        Set<MethodInfo> methodsToHandle = methodCallNodes.keySet();
        while (methodsToHandle.size() != 0) {
            HashSet<MethodInfo> nextIterationMethodsToHandle = new HashSet<MethodInfo>();
            for (List<MethodCallNode> callNodes : methodCallNodes.values()) {
                Set<MethodInfo> affectedMethods = ConditionalConfigurationComputer.maybePropagateConfiguration(callNodes);
                nextIterationMethodsToHandle.addAll(affectedMethods);
            }
            methodsToHandle = nextIterationMethodsToHandle;
        }
    }
}

