/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.image.sources;

import com.oracle.svm.core.feature.AutomaticallyRegisteredFeature;
import com.oracle.svm.core.feature.InternalFeature;
import com.oracle.svm.core.option.HostedOptionKey;
import com.oracle.svm.core.option.LocatableMultiOptionValue;
import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.hosted.ImageClassLoader;
import java.nio.file.Path;
import java.util.List;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.hosted.Feature;

@AutomaticallyRegisteredFeature
class SourceCacheFeature
implements InternalFeature {
    ImageClassLoader imageClassLoader;

    SourceCacheFeature() {
    }

    public void afterAnalysis(Feature.AfterAnalysisAccess access) {
        this.imageClassLoader = ((FeatureImpl.AfterAnalysisAccessImpl)access).getImageClassLoader();
    }

    static List<Path> getClassPath() {
        return ((SourceCacheFeature)ImageSingletons.lookup(SourceCacheFeature.class)).imageClassLoader.classpath();
    }

    static List<Path> getModulePath() {
        return ((SourceCacheFeature)ImageSingletons.lookup(SourceCacheFeature.class)).imageClassLoader.modulepath();
    }

    static List<Path> getSourceSearchPath() {
        return Options.DebugInfoSourceSearchPath.getValue().values();
    }

    public static class Options {
        static final HostedOptionKey<LocatableMultiOptionValue.Paths> DebugInfoSourceSearchPath = new HostedOptionKey<LocatableMultiOptionValue.Paths>(LocatableMultiOptionValue.Paths.buildWithCommaDelimiter());
    }
}

