/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.c.info;

import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.c.info.AccessorInfo;
import com.oracle.svm.hosted.c.info.ElementInfo;
import com.oracle.svm.hosted.c.info.InfoTreeVisitor;
import com.oracle.svm.hosted.c.info.PropertyInfo;
import com.oracle.svm.hosted.c.info.SizableInfo;
import org.graalvm.word.LocationIdentity;

public class StructFieldInfo
extends SizableInfo {
    private final PropertyInfo<Integer> offset = this.adoptChild(new PropertyInfo("offset"));
    private LocationIdentity locationIdentity;

    public StructFieldInfo(String name, SizableInfo.ElementKind kind) {
        super(name, kind);
    }

    public PropertyInfo<Integer> getOffsetInfo() {
        return this.offset;
    }

    public AccessorInfo getAnyAccessorInfo() {
        return this.getAccessorInfo(false);
    }

    public AccessorInfo getAccessorInfoWithSize() {
        return this.getAccessorInfo(true);
    }

    private AccessorInfo getAccessorInfo(boolean withSize) {
        for (ElementInfo child : this.getChildren()) {
            AccessorInfo.AccessorKind kind;
            if (!(child instanceof AccessorInfo) || withSize && (kind = ((AccessorInfo)child).getAccessorKind()) != AccessorInfo.AccessorKind.GETTER && kind != AccessorInfo.AccessorKind.SETTER) continue;
            return (AccessorInfo)child;
        }
        throw VMError.shouldNotReachHere("must have at least one accessor method that defines the field with a type for: " + String.valueOf(this));
    }

    @Override
    public void accept(InfoTreeVisitor visitor) {
        visitor.visitStructFieldInfo(this);
    }

    @Override
    public Object getAnnotatedElement() {
        for (ElementInfo child : this.getChildren()) {
            if (!(child instanceof AccessorInfo)) continue;
            return child.getAnnotatedElement();
        }
        throw VMError.shouldNotReachHere("must have at least one accessor method that defined the field");
    }

    public LocationIdentity getLocationIdentity() {
        return this.locationIdentity;
    }

    public void setLocationIdentity(LocationIdentity locationIdentity) {
        assert (this.locationIdentity == null);
        this.locationIdentity = locationIdentity;
    }
}

