/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.analysis.flow;

import com.oracle.graal.pointsto.AbstractAnalysisEngine;
import com.oracle.graal.pointsto.BigBang;
import com.oracle.graal.pointsto.PointsToAnalysis;
import com.oracle.graal.pointsto.flow.MethodFlowsGraph;
import com.oracle.graal.pointsto.flow.MethodTypeFlowBuilder;
import com.oracle.graal.pointsto.flow.TypeFlow;
import com.oracle.graal.pointsto.flow.builder.TypeFlowBuilder;
import com.oracle.graal.pointsto.heap.ImageHeapConstant;
import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.meta.PointsToAnalysisMethod;
import com.oracle.svm.core.graal.nodes.InlinedInvokeArgumentsNode;
import com.oracle.svm.core.graal.thread.CompareAndSetVMThreadLocalNode;
import com.oracle.svm.core.graal.thread.StoreVMThreadLocalNode;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.hosted.NativeImageOptions;
import com.oracle.svm.hosted.SVMHost;
import com.oracle.svm.hosted.substitute.ComputedValueField;
import jdk.vm.ci.code.BytecodePosition;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.compiler.core.common.type.ObjectStamp;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.nodes.CallTargetNode;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.FixedNode;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.java.LoadFieldNode;

public class SVMMethodTypeFlowBuilder
extends MethodTypeFlowBuilder {
    public SVMMethodTypeFlowBuilder(PointsToAnalysis bb, PointsToAnalysisMethod method, MethodFlowsGraph flowsGraph, MethodFlowsGraph.GraphKind graphKind) {
        super(bb, method, flowsGraph, graphKind);
    }

    protected SVMHost getHostVM() {
        return (SVMHost)this.bb.getHostVM();
    }

    public static void registerUsedElements(PointsToAnalysis bb, StructuredGraph graph, boolean registerEmbeddedRoots) {
        MethodTypeFlowBuilder.registerUsedElements((PointsToAnalysis)bb, (StructuredGraph)graph, (boolean)registerEmbeddedRoots);
        for (Node n : graph.getNodes()) {
            Object replaced;
            Object value;
            if (!(n instanceof ConstantNode)) continue;
            ConstantNode cn = (ConstantNode)n;
            JavaConstant constant = cn.asJavaConstant();
            if (!cn.hasUsages() || !cn.isJavaConstant() || constant.getJavaKind() != JavaKind.Object || !constant.isNonNull() || constant instanceof ImageHeapConstant || SVMMethodTypeFlowBuilder.ignoreConstant((PointsToAnalysis)bb, (ConstantNode)cn) || (value = bb.getSnippetReflectionProvider().asObject(Object.class, constant)) == (replaced = bb.getUniverse().replaceObject(value))) continue;
            throw GraalError.shouldNotReachHere((String)("Missed object replacement during graph building: " + String.valueOf(value) + " (" + String.valueOf(value.getClass()) + ") != " + String.valueOf(replaced) + " (" + String.valueOf(replaced.getClass()) + ")"));
        }
    }

    protected void checkUnsafeOffset(ValueNode base, ValueNode offsetNode) {
        if (!NativeImageOptions.ThrowUnsafeOffsetErrors.getValue().booleanValue()) {
            return;
        }
        BytecodePosition pos = AbstractAnalysisEngine.sourcePosition((ValueNode)offsetNode);
        if (offsetNode instanceof LoadFieldNode) {
            LoadFieldNode offsetLoadNode = (LoadFieldNode)offsetNode;
            AnalysisField field = (AnalysisField)offsetLoadNode.field();
            if (!(!field.isStatic() || !this.getHostVM().getClassInitializationSupport().maybeInitializeAtBuildTime((ResolvedJavaType)field.getDeclaringClass()) || field.getDeclaringClass().unsafeFieldsRecomputed() || field.wrapped instanceof ComputedValueField || base.isConstant() && base.asConstant().isDefaultForKind())) {
                Object message = String.format("Field %s is used as an offset in an unsafe operation, but no value recomputation found.%n Wrapped field: %s", field, field.wrapped);
                message = (String)message + String.format("%n Location: %s", pos);
                UnsafeOffsetError.report((String)message);
            }
        } else if (NativeImageOptions.ReportUnsafeOffsetWarnings.getValue().booleanValue()) {
            Object message = "Offset used in an unsafe operation. Cannot determine if the offset value is recomputed.";
            message = (String)message + String.format("%nNode class: %s", offsetNode.getClass().getName());
            message = (String)message + String.format("%n Location: %s", pos);
            if (NativeImageOptions.UnsafeOffsetWarningsAreFatal.getValue().booleanValue()) {
                UnsafeOffsetError.report((String)message);
            } else {
                System.out.println((String)message);
            }
        }
    }

    protected boolean delegateNodeProcessing(FixedNode n, MethodTypeFlowBuilder.TypeFlowsOfNodes state) {
        if (n instanceof StoreVMThreadLocalNode) {
            StoreVMThreadLocalNode node = (StoreVMThreadLocalNode)n;
            this.storeVMThreadLocal(state, (ValueNode)node, node.getValue());
            return true;
        }
        if (n instanceof CompareAndSetVMThreadLocalNode) {
            CompareAndSetVMThreadLocalNode node = (CompareAndSetVMThreadLocalNode)n;
            this.storeVMThreadLocal(state, (ValueNode)node, node.getUpdate());
            return true;
        }
        if (n instanceof InlinedInvokeArgumentsNode) {
            InlinedInvokeArgumentsNode node = (InlinedInvokeArgumentsNode)n;
            this.processInlinedInvokeArgumentsNode(state, node);
            return true;
        }
        return super.delegateNodeProcessing(n, state);
    }

    private void storeVMThreadLocal(MethodTypeFlowBuilder.TypeFlowsOfNodes state, ValueNode storeNode, ValueNode value) {
        Stamp stamp = value.stamp(NodeView.DEFAULT);
        if (stamp instanceof ObjectStamp) {
            TypeFlowBuilder valueBuilder = state.lookup(value);
            ObjectStamp valueStamp = (ObjectStamp)stamp;
            AnalysisType valueType = (AnalysisType)(valueStamp.type() == null ? this.bb.getObjectType() : valueStamp.type());
            TypeFlowBuilder storeBuilder = TypeFlowBuilder.create((PointsToAnalysis)this.bb, (Object)storeNode, TypeFlow.class, () -> {
                TypeFlow proxy = this.bb.analysisPolicy().proxy(AbstractAnalysisEngine.sourcePosition((ValueNode)storeNode), (TypeFlow)valueType.getTypeFlow((BigBang)this.bb, false));
                this.flowsGraph.addMiscEntryFlow(proxy);
                return proxy;
            });
            storeBuilder.addUseDependency(valueBuilder);
            this.typeFlowGraphBuilder.registerSinkBuilder(storeBuilder);
        }
    }

    private void processInlinedInvokeArgumentsNode(MethodTypeFlowBuilder.TypeFlowsOfNodes state, InlinedInvokeArgumentsNode node) {
        PointsToAnalysisMethod targetMethod = (PointsToAnalysisMethod)node.getInvokeTarget();
        BytecodePosition position = AbstractAnalysisEngine.syntheticSourcePosition((Node)node, (ResolvedJavaMethod)this.method);
        CallTargetNode.InvokeKind invokeKind = targetMethod.isStatic() ? CallTargetNode.InvokeKind.Static : CallTargetNode.InvokeKind.Special;
        this.processMethodInvocation(state, (ValueNode)node, invokeKind, targetMethod, node.getArguments(), true, position, true);
    }

    public static class UnsafeOffsetError
    extends UserError.UserException {
        UnsafeOffsetError(String message) {
            super(message);
        }

        static void report(String message) {
            throw new UnsafeOffsetError(message);
        }
    }
}

