/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.graal.hosted;

import com.oracle.graal.pointsto.BigBang;
import com.oracle.graal.pointsto.infrastructure.UniverseMetaAccess;
import com.oracle.graal.pointsto.meta.AnalysisMetaAccess;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.HostedProviders;
import com.oracle.graal.pointsto.util.GraalAccess;
import com.oracle.svm.core.ParsingReason;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.graal.GraalConfiguration;
import com.oracle.svm.core.graal.RuntimeCompilationCanaryFeature;
import com.oracle.svm.core.graal.code.SubstrateBackend;
import com.oracle.svm.core.graal.code.SubstratePlatformConfigurationProvider;
import com.oracle.svm.core.graal.meta.RuntimeConfiguration;
import com.oracle.svm.core.graal.meta.SubstrateReplacements;
import com.oracle.svm.core.graal.nodes.ThrowBytecodeExceptionNode;
import com.oracle.svm.core.heap.BarrierSetProvider;
import com.oracle.svm.core.jdk.RuntimeSupport;
import com.oracle.svm.core.option.HostedOptionKey;
import com.oracle.svm.core.option.LocatableMultiOptionValue;
import com.oracle.svm.core.option.RuntimeOptionValues;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.graal.GraalSupport;
import com.oracle.svm.graal.SubstrateGraalRuntime;
import com.oracle.svm.graal.hosted.DeoptimizationFeature;
import com.oracle.svm.graal.hosted.FieldsOffsetsFeature;
import com.oracle.svm.graal.hosted.GraalGraphObjectReplacer;
import com.oracle.svm.graal.hosted.GraphPrepareMetaAccessExtensionProvider;
import com.oracle.svm.graal.hosted.LegacyRuntimeCompilationFeature;
import com.oracle.svm.graal.hosted.ParseOnceRuntimeCompilationFeature;
import com.oracle.svm.graal.hosted.SubstrateGraalCompilerSetup;
import com.oracle.svm.graal.hosted.SubstrateProviders;
import com.oracle.svm.graal.meta.SubstrateMethod;
import com.oracle.svm.graal.meta.SubstrateUniverseFactory;
import com.oracle.svm.hosted.FeatureHandler;
import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.hosted.NativeImageGenerator;
import com.oracle.svm.hosted.ProgressReporter;
import com.oracle.svm.hosted.analysis.Inflation;
import com.oracle.svm.hosted.classinitialization.ClassInitializationSupport;
import com.oracle.svm.hosted.meta.HostedMetaAccess;
import com.oracle.svm.hosted.meta.HostedUniverse;
import com.oracle.svm.hosted.phases.SubstrateClassInitializationPlugin;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.collections.EconomicMap;
import org.graalvm.compiler.api.runtime.GraalRuntime;
import org.graalvm.compiler.core.common.spi.ConstantFieldProvider;
import org.graalvm.compiler.core.common.spi.MetaAccessExtensionProvider;
import org.graalvm.compiler.core.gen.NodeMatchRules;
import org.graalvm.compiler.core.match.MatchStatement;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.lir.phases.LIRSuites;
import org.graalvm.compiler.nodes.GraphEncoder;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.extended.BytecodeExceptionNode;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderConfiguration;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderContext;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.phases.OptimisticOptimizations;
import org.graalvm.compiler.phases.tiers.Suites;
import org.graalvm.compiler.phases.util.Providers;
import org.graalvm.compiler.word.WordTypes;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.nativeimage.hosted.RuntimeReflection;

public abstract class RuntimeCompilationFeature {
    protected GraalGraphObjectReplacer objectReplacer;
    protected HostedProviders hostedProviders;
    protected GraphEncoder graphEncoder;
    private boolean initialized;
    protected GraphBuilderConfiguration graphBuilderConfig;
    protected OptimisticOptimizations optimisticOpts;
    protected RuntimeCompilationCandidatePredicate runtimeCompilationCandidatePredicate;
    private boolean runtimeCompilationCandidatePredicateUpdated = false;
    protected Predicate<ResolvedJavaMethod> deoptimizeOnExceptionPredicate;
    private SubstrateUniverseFactory universeFactory = new SubstrateUniverseFactory();

    public static boolean isEnabledAndNotLibgraal() {
        return ImageSingletons.contains(RuntimeCompilationFeature.class) && !SubstrateUtil.isBuildingLibgraal();
    }

    public static RuntimeCompilationFeature singleton() {
        return (RuntimeCompilationFeature)ImageSingletons.lookup(RuntimeCompilationFeature.class);
    }

    public static Class<? extends Feature> getRuntimeCompilationFeature() {
        if (SubstrateOptions.ParseOnceJIT.getValue().booleanValue()) {
            return ParseOnceRuntimeCompilationFeature.class;
        }
        return LegacyRuntimeCompilationFeature.class;
    }

    protected abstract AbstractCallTreeNode getCallTreeNode(RuntimeCompilationCandidate var1);

    protected abstract AbstractCallTreeNode getCallTreeNode(RuntimeCompiledMethod var1);

    protected abstract AbstractCallTreeNode getCallTreeNode(ResolvedJavaMethod var1);

    public abstract Collection<RuntimeCompiledMethod> getRuntimeCompiledMethods();

    public abstract Collection<RuntimeCompilationCandidate> getAllRuntimeCompilationCandidates();

    public final Comparator<RuntimeCompilationCandidate> getRuntimeCompilationComparator() {
        return (o1, o2) -> this.getCallTreeNode((RuntimeCompilationCandidate)o1).compareTo(this.getCallTreeNode((RuntimeCompilationCandidate)o2));
    }

    public final List<String> getCallTrace(ResolvedJavaMethod method) {
        return RuntimeCompilationFeature.getCallTraceHelper(this.getCallTreeNode(method));
    }

    public final List<String> getCallTrace(RuntimeCompilationCandidate candidate) {
        return RuntimeCompilationFeature.getCallTraceHelper(this.getCallTreeNode(candidate));
    }

    private static List<String> getCallTraceHelper(AbstractCallTreeNode node) {
        ArrayList<String> trace = new ArrayList<String>();
        for (AbstractCallTreeNode cur = node; cur != null; cur = cur.getParent()) {
            trace.add(cur.getPosition());
        }
        return trace;
    }

    public HostedProviders getHostedProviders() {
        return this.hostedProviders;
    }

    public GraalGraphObjectReplacer getObjectReplacer() {
        return this.objectReplacer;
    }

    protected static List<Class<? extends Feature>> getRequiredFeaturesHelper() {
        if (SubstrateUtil.isBuildingLibgraal()) {
            return List.of(FieldsOffsetsFeature.class);
        }
        return List.of(RuntimeCompilationCanaryFeature.class, DeoptimizationFeature.class, FieldsOffsetsFeature.class);
    }

    public void setUniverseFactory(SubstrateUniverseFactory universeFactory) {
        this.universeFactory = universeFactory;
    }

    protected final void duringSetupHelper(Feature.DuringSetupAccess c) {
        if (SubstrateOptions.useLLVMBackend()) {
            throw UserError.abort("Runtime compilation is currently unimplemented on the LLVM backend (GR-43073).", new Object[0]);
        }
        ImageSingletons.add(GraalSupport.class, (Object)new GraalSupport());
        if (!ImageSingletons.contains(SubstrateGraalCompilerSetup.class)) {
            ImageSingletons.add(SubstrateGraalCompilerSetup.class, (Object)new SubstrateGraalCompilerSetup());
        }
        FeatureImpl.DuringSetupAccessImpl config = (FeatureImpl.DuringSetupAccessImpl)c;
        AnalysisMetaAccess aMetaAccess = config.getMetaAccess();
        SubstrateProviders substrateProviders = ((SubstrateGraalCompilerSetup)ImageSingletons.lookup(SubstrateGraalCompilerSetup.class)).getSubstrateProviders(aMetaAccess);
        this.objectReplacer = new GraalGraphObjectReplacer(config.getUniverse(), substrateProviders, this.universeFactory);
        config.registerObjectReplacer(this.objectReplacer);
        config.registerClassReachabilityListener(GraalSupport::registerPhaseStatistics);
    }

    private void installRuntimeConfig(FeatureImpl.BeforeAnalysisAccessImpl config) {
        Function<Providers, SubstrateBackend> backendProvider = GraalSupport.getRuntimeBackendProvider();
        ClassInitializationSupport classInitializationSupport = config.getHostVM().getClassInitializationSupport();
        Providers originalProviders = GraalAccess.getOriginalProviders();
        SubstratePlatformConfigurationProvider platformConfig = new SubstratePlatformConfigurationProvider(((BarrierSetProvider)ImageSingletons.lookup(BarrierSetProvider.class)).createBarrierSet((MetaAccessProvider)config.getMetaAccess()));
        RuntimeConfiguration runtimeConfig = ((SubstrateGraalCompilerSetup)ImageSingletons.lookup(SubstrateGraalCompilerSetup.class)).createRuntimeConfigurationBuilder((OptionValues)RuntimeOptionValues.singleton(), config.getHostVM(), config.getUniverse(), (UniverseMetaAccess)config.getMetaAccess(), backendProvider, classInitializationSupport, originalProviders.getLoopsDataProvider(), platformConfig).build();
        Providers runtimeProviders = runtimeConfig.getProviders();
        WordTypes wordTypes = runtimeConfig.getWordTypes();
        this.hostedProviders = new HostedProviders(runtimeProviders.getMetaAccess(), runtimeProviders.getCodeCache(), runtimeProviders.getConstantReflection(), runtimeProviders.getConstantFieldProvider(), runtimeProviders.getForeignCalls(), runtimeProviders.getLowerer(), runtimeProviders.getReplacements(), runtimeProviders.getStampProvider(), runtimeConfig.getSnippetReflection(), wordTypes, runtimeProviders.getPlatformConfigurationProvider(), (MetaAccessExtensionProvider)new GraphPrepareMetaAccessExtensionProvider(), runtimeProviders.getLoopsDataProvider());
        FeatureHandler featureHandler = config.getFeatureHandler();
        boolean supportsStubBasedPlugins = !SubstrateOptions.useLLVMBackend();
        NativeImageGenerator.registerGraphBuilderPlugins(featureHandler, runtimeConfig, this.hostedProviders, config.getMetaAccess(), config.getUniverse(), null, null, config.getNativeLibraries(), config.getImageClassLoader(), ParsingReason.JITCompilation, ((Inflation)config.getBigBang()).getAnnotationSubstitutionProcessor(), new SubstrateClassInitializationPlugin(config.getHostVM()), ConfigurationValues.getTarget(), supportsStubBasedPlugins);
        NativeImageGenerator.registerReplacements(DebugContext.forCurrentThread(), featureHandler, runtimeConfig, runtimeConfig.getProviders(), false, true);
        featureHandler.forEachGraalFeature(feature -> feature.registerCodeObserver(runtimeConfig));
        Suites suites = NativeImageGenerator.createSuites(featureHandler, runtimeConfig, runtimeConfig.getSnippetReflection(), false);
        LIRSuites lirSuites = NativeImageGenerator.createLIRSuites(featureHandler, runtimeConfig.getProviders(), false);
        Suites firstTierSuites = NativeImageGenerator.createFirstTierSuites(featureHandler, runtimeConfig, runtimeConfig.getSnippetReflection(), false);
        LIRSuites firstTierLirSuites = NativeImageGenerator.createFirstTierLIRSuites(featureHandler, runtimeConfig.getProviders(), false);
        GraalSupport.setRuntimeConfig(runtimeConfig, suites, lirSuites, firstTierSuites, firstTierLirSuites);
    }

    protected final void beforeAnalysisHelper(Feature.BeforeAnalysisAccess c) {
        DebugContext debug = DebugContext.forCurrentThread();
        for (JavaKind kind : new JavaKind[]{JavaKind.Boolean, JavaKind.Byte, JavaKind.Char, JavaKind.Double, JavaKind.Float, JavaKind.Int, JavaKind.Long, JavaKind.Short}) {
            RuntimeReflection.register((Class[])new Class[]{kind.toBoxedJavaClass()});
            Class<?>[] innerClasses = kind.toBoxedJavaClass().getDeclaredClasses();
            if (innerClasses == null || innerClasses.length <= 0) continue;
            RuntimeReflection.register((Class[])new Class[]{innerClasses[0]});
            try {
                RuntimeReflection.register((Field[])new Field[]{innerClasses[0].getDeclaredField("cache")});
            }
            catch (Throwable t) {
                throw debug.handle(t);
            }
        }
        FeatureImpl.BeforeAnalysisAccessImpl config = (FeatureImpl.BeforeAnalysisAccessImpl)c;
        GraalSupport.allocatePhaseStatisticsCache();
        RuntimeCompilationFeature.populateMatchRuleRegistry();
        this.installRuntimeConfig(config);
        SubstrateGraalRuntime graalRuntime = new SubstrateGraalRuntime();
        this.objectReplacer.setGraalRuntime(graalRuntime);
        this.objectReplacer.setAnalysisAccess(config);
        ImageSingletons.add(GraalRuntime.class, (Object)graalRuntime);
        RuntimeSupport.getRuntimeSupport().addShutdownHook(new GraalSupport.GraalShutdownHook());
        this.graphBuilderConfig = GraphBuilderConfiguration.getDefault((GraphBuilderConfiguration.Plugins)this.hostedProviders.getGraphBuilderPlugins()).withBytecodeExceptionMode(GraphBuilderConfiguration.BytecodeExceptionMode.ExplicitOnly);
        this.runtimeCompilationCandidatePredicate = RuntimeCompilationFeature::defaultAllowRuntimeCompilation;
        this.optimisticOpts = OptimisticOptimizations.ALL.remove(new OptimisticOptimizations.Optimization[]{OptimisticOptimizations.Optimization.UseLoopLimitChecks});
        this.graphEncoder = new GraphEncoder(ConfigurationValues.getTarget().arch);
        SubstrateReplacements replacements = (SubstrateReplacements)GraalSupport.getRuntimeConfig().getProviders().getReplacements();
        for (NodeClass<?> nodeClass : replacements.getSnippetNodeClasses()) {
            config.getMetaAccess().lookupJavaType(nodeClass.getClazz()).registerAsAllocated((Object)("All " + NodeClass.class.getName() + " classes are marked as instantiated eagerly."));
        }
        if (!SubstrateUtil.isBuildingLibgraal()) {
            NativeImageGenerator.performSnippetGraphAnalysis(config.getBigBang(), replacements, config.getBigBang().getOptions());
        }
        for (ResolvedJavaMethod method : replacements.getSnippetMethods()) {
            this.objectReplacer.apply(method);
        }
    }

    private static void populateMatchRuleRegistry() {
        GraalSupport.get().setMatchRuleRegistry(new HashMap<Class<? extends NodeMatchRules>, EconomicMap<Class<? extends Node>, List<MatchStatement>>>());
        GraalConfiguration.runtimeInstance().populateMatchRuleRegistry(GraalSupport.get().getMatchRuleRegistry());
    }

    private static boolean defaultAllowRuntimeCompilation(ResolvedJavaMethod method) {
        return false;
    }

    public void initializeRuntimeCompilationForTesting(FeatureImpl.BeforeAnalysisAccessImpl config, RuntimeCompilationCandidatePredicate newRuntimeCompilationCandidatePredicate) {
        this.initializeRuntimeCompilationConfiguration(this.hostedProviders, this.graphBuilderConfig, newRuntimeCompilationCandidatePredicate, this.deoptimizeOnExceptionPredicate);
        this.initializeRuntimeCompilationForTesting(config);
    }

    public void initializeRuntimeCompilationForTesting(FeatureImpl.BeforeAnalysisAccessImpl config) {
        this.initializeAnalysisProviders(config.getBigBang(), provider -> provider);
    }

    public void initializeRuntimeCompilationConfiguration(HostedProviders newHostedProviders, GraphBuilderConfiguration newGraphBuilderConfig, RuntimeCompilationCandidatePredicate newRuntimeCompilationCandidatePredicate, Predicate<ResolvedJavaMethod> newDeoptimizeOnExceptionPredicate) {
        VMError.guarantee(!this.initialized, "runtime compilation configuration already initialized");
        this.initialized = true;
        this.hostedProviders = newHostedProviders;
        this.graphBuilderConfig = newGraphBuilderConfig;
        assert (!this.runtimeCompilationCandidatePredicateUpdated) : "Updated compilation predicate multiple times";
        this.runtimeCompilationCandidatePredicate = newRuntimeCompilationCandidatePredicate;
        this.runtimeCompilationCandidatePredicateUpdated = true;
        this.deoptimizeOnExceptionPredicate = newDeoptimizeOnExceptionPredicate;
        if (SubstrateOptions.IncludeNodeSourcePositions.getValue().booleanValue()) {
            this.graphBuilderConfig = this.graphBuilderConfig.withNodeSourcePosition(true);
        }
    }

    public SubstrateMethod requireFrameInformationForMethod(ResolvedJavaMethod method, FeatureImpl.BeforeAnalysisAccessImpl config, boolean registerAsRoot) {
        AnalysisMethod aMethod = (AnalysisMethod)method;
        SubstrateMethod sMethod = this.objectReplacer.createMethod((ResolvedJavaMethod)aMethod);
        this.requireFrameInformationForMethodHelper(aMethod, config, registerAsRoot);
        return sMethod;
    }

    protected abstract void requireFrameInformationForMethodHelper(AnalysisMethod var1, FeatureImpl.BeforeAnalysisAccessImpl var2, boolean var3);

    public SubstrateMethod prepareMethodForRuntimeCompilation(Executable method, FeatureImpl.BeforeAnalysisAccessImpl config) {
        return this.prepareMethodForRuntimeCompilation((ResolvedJavaMethod)config.getMetaAccess().lookupJavaMethod(method), config);
    }

    public abstract void initializeAnalysisProviders(BigBang var1, Function<ConstantFieldProvider, ConstantFieldProvider> var2);

    public abstract void registerAllowInliningPredicate(AllowInliningPredicate var1);

    public abstract SubstrateMethod prepareMethodForRuntimeCompilation(ResolvedJavaMethod var1, FeatureImpl.BeforeAnalysisAccessImpl var2);

    protected final void afterAnalysisHelper() {
        ProgressReporter.singleton().setNumRuntimeCompiledMethods(this.getRuntimeCompiledMethods().size());
    }

    protected static boolean verifyNodes(StructuredGraph graph) {
        for (Node node : graph.getNodes()) {
            boolean invalidNodeKind;
            boolean bl = invalidNodeKind = node instanceof BytecodeExceptionNode || node instanceof ThrowBytecodeExceptionNode;
            assert (!invalidNodeKind) : "illegal node in graph: " + String.valueOf(node) + " method: " + String.valueOf(graph.method());
        }
        return true;
    }

    protected final void beforeCompilationHelper() {
        if (Options.PrintRuntimeCompileMethods.getValue().booleanValue()) {
            System.out.println("****Start Print Runtime Compile Methods***");
            this.getRuntimeCompiledMethods().stream().map(m -> m.getMethod().format("%H.%n(%p)")).sorted().collect(Collectors.toList()).forEach(System.out::println);
            System.out.println("****End Print Runtime Compile Methods***");
        }
        if (Options.PrintRuntimeCompilationCallTree.getValue().booleanValue()) {
            System.out.println("****Start Print Runtime Compile Call Tree***");
            this.printCallTree();
            System.out.println("****End Print Runtime Compile Call Tree***");
        }
        int maxMethods = 0;
        for (String value : Options.MaxRuntimeCompileMethods.getValue().values()) {
            String numberStr = null;
            try {
                numberStr = value.split("#")[0];
                maxMethods += Integer.parseInt(numberStr);
            }
            catch (NumberFormatException ex) {
                throw UserError.abort("Invalid value for option 'MaxRuntimeCompileMethods': '%s' is not a valid number", numberStr);
            }
        }
        if (Options.EnforceMaxRuntimeCompileMethods.getValue().booleanValue() && maxMethods != 0 && this.getRuntimeCompiledMethods().size() > maxMethods) {
            this.printDeepestLevelPath();
            throw VMError.shouldNotReachHere("Number of methods for runtime compilation exceeds the allowed limit: " + this.getRuntimeCompiledMethods().size() + " > " + maxMethods);
        }
    }

    private void printDeepestLevelPath() {
        AbstractCallTreeNode maxLevelCallTreeNode = null;
        for (RuntimeCompiledMethod method : this.getRuntimeCompiledMethods()) {
            AbstractCallTreeNode callTreeNode = this.getCallTreeNode(method);
            if (maxLevelCallTreeNode != null && maxLevelCallTreeNode.getLevel() >= callTreeNode.getLevel()) continue;
            maxLevelCallTreeNode = callTreeNode;
        }
        System.out.println(String.format("Deepest level call tree path (%d calls):", maxLevelCallTreeNode.getLevel()));
        for (AbstractCallTreeNode node = maxLevelCallTreeNode; node != null; node = node.getParent()) {
            AnalysisMethod implementationMethod = node.getImplementationMethod();
            AnalysisMethod targetMethod = node.getTargetMethod();
            System.out.format("%5d ; %s ; %s", node.getNodeCount(), node.getPosition(), implementationMethod == null ? "" : implementationMethod.format("%H.%n(%p)"));
            if (targetMethod != null && !targetMethod.equals((Object)implementationMethod)) {
                System.out.print(" ; " + targetMethod.format("%H.%n(%p)"));
            }
            System.out.println();
        }
    }

    private void printCallTree() {
        System.out.println("depth;method;Graal nodes;invoked from source;full method name;full name of invoked virtual method");
        for (RuntimeCompiledMethod method : this.getRuntimeCompiledMethods()) {
            AbstractCallTreeNode node = this.getCallTreeNode(method);
            if (node.getLevel() != 0) continue;
            this.printCallTreeNode(node);
        }
    }

    private void printCallTreeNode(AbstractCallTreeNode node) {
        AnalysisMethod implementationMethod = node.getImplementationMethod();
        AnalysisMethod targetMethod = node.getTargetMethod();
        StringBuilder indent = new StringBuilder();
        for (int i = 0; i < node.getLevel(); ++i) {
            indent.append("  ");
        }
        if (implementationMethod != null) {
            indent.append(implementationMethod.format("%h.%n"));
        }
        System.out.format("%4d ; %-80s  ;%5d ; %s ; %s", node.getLevel(), indent, node.getNodeCount(), node.getPosition(), implementationMethod == null ? "" : implementationMethod.format("%H.%n(%p)"));
        if (targetMethod != null && !targetMethod.equals((Object)implementationMethod)) {
            System.out.print(" ; " + targetMethod.format("%H.%n(%p)"));
        }
        System.out.println();
        for (AbstractCallTreeNode child : node.getChildren()) {
            this.printCallTreeNode(child);
        }
    }

    protected final void afterCompilationHelper(Feature.AfterCompilationAccess a) {
        FeatureImpl.CompilationAccessImpl config = (FeatureImpl.CompilationAccessImpl)a;
        HostedMetaAccess hMetaAccess = config.getMetaAccess();
        HostedUniverse hUniverse = hMetaAccess.getUniverse();
        this.objectReplacer.updateSubstrateDataAfterCompilation(hUniverse, config.getProviders());
        this.objectReplacer.registerImmutableObjects(config);
        GraalSupport.registerImmutableObjects(config);
        ((SubstrateReplacements)GraalSupport.getRuntimeConfig().getProviders().getReplacements()).registerImmutableObjects(config);
    }

    protected final void afterHeapLayoutHelper(Feature.AfterHeapLayoutAccess a) {
        FeatureImpl.AfterHeapLayoutAccessImpl config = (FeatureImpl.AfterHeapLayoutAccessImpl)a;
        HostedMetaAccess hMetaAccess = config.getMetaAccess();
        HostedUniverse hUniverse = hMetaAccess.getUniverse();
        this.objectReplacer.updateSubstrateDataAfterHeapLayout(hUniverse);
    }

    public static abstract class AbstractCallTreeNode
    implements Comparable<AbstractCallTreeNode> {
        private final AnalysisMethod implementationMethod;
        private final AnalysisMethod targetMethod;
        private final AbstractCallTreeNode parent;
        private final int level;
        private Set<AbstractCallTreeNode> children;

        protected AbstractCallTreeNode(AbstractCallTreeNode parent, AnalysisMethod targetMethod, AnalysisMethod implementationMethod) {
            this.implementationMethod = implementationMethod;
            this.targetMethod = targetMethod;
            this.parent = parent;
            this.children = null;
            this.level = parent != null ? parent.level + 1 : 0;
        }

        public AnalysisMethod getImplementationMethod() {
            return this.implementationMethod;
        }

        public AnalysisMethod getTargetMethod() {
            return this.targetMethod;
        }

        protected AbstractCallTreeNode getParent() {
            return this.parent;
        }

        protected void linkAsChild() {
            if (this.parent != null) {
                if (this.parent.children == null) {
                    this.parent.children = new LinkedHashSet<AbstractCallTreeNode>();
                }
                boolean added = this.parent.children.add(this);
                assert (added) : "child linked to parent multiple times.";
            }
        }

        private Collection<AbstractCallTreeNode> getChildren() {
            return this.children == null ? List.of() : this.children;
        }

        protected int getLevel() {
            return this.level;
        }

        public abstract String getPosition();

        public abstract int getNodeCount();

        @Override
        public int compareTo(AbstractCallTreeNode o) {
            int result = this.implementationMethod.getQualifiedName().compareTo(o.implementationMethod.getQualifiedName());
            if (result != 0) {
                return result;
            }
            result = this.targetMethod.getQualifiedName().compareTo(o.targetMethod.getQualifiedName());
            if (result != 0) {
                return result;
            }
            result = Integer.compare(this.level, o.level);
            if (result != 0) {
                return result;
            }
            if (this.parent != null && o.parent != null) {
                return this.parent.compareTo(o.parent);
            }
            assert (this.parent == null && o.parent == null);
            return 0;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AbstractCallTreeNode that = (AbstractCallTreeNode)o;
            return this.implementationMethod.equals((Object)that.implementationMethod) && this.targetMethod.equals((Object)that.targetMethod);
        }

        public int hashCode() {
            return Objects.hash(this.implementationMethod, this.targetMethod);
        }
    }

    public static interface RuntimeCompilationCandidate {
        public AnalysisMethod getImplementationMethod();

        public AnalysisMethod getTargetMethod();
    }

    public static interface RuntimeCompilationCandidatePredicate {
        public boolean allowRuntimeCompilation(ResolvedJavaMethod var1);
    }

    public static class Options {
        public static final HostedOptionKey<Boolean> PrintRuntimeCompileMethods = new HostedOptionKey<Boolean>(false);
        public static final HostedOptionKey<Boolean> PrintRuntimeCompilationCallTree = new HostedOptionKey<Boolean>(false);
        public static final HostedOptionKey<LocatableMultiOptionValue.Strings> MaxRuntimeCompileMethods = new HostedOptionKey<LocatableMultiOptionValue.Strings>(LocatableMultiOptionValue.Strings.build());
        public static final HostedOptionKey<Boolean> EnforceMaxRuntimeCompileMethods = new HostedOptionKey<Boolean>(false);
    }

    public static interface RuntimeCompiledMethod {
        public AnalysisMethod getMethod();

        public Collection<ResolvedJavaMethod> getInlinedMethods();

        public Collection<ResolvedJavaMethod> getInvokeTargets();
    }

    public static interface AllowInliningPredicate {
        public InlineDecision allowInlining(GraphBuilderContext var1, ResolvedJavaMethod var2);

        public static enum InlineDecision {
            INLINE,
            INLINING_DISALLOWED,
            NO_DECISION;

        }
    }

    public static final class IsEnabledAndNotLibgraal
    implements BooleanSupplier {
        @Override
        public boolean getAsBoolean() {
            return RuntimeCompilationFeature.isEnabledAndNotLibgraal();
        }
    }

    public static final class IsEnabled
    implements BooleanSupplier {
        @Override
        public boolean getAsBoolean() {
            return ImageSingletons.contains(RuntimeCompilationFeature.class);
        }
    }
}

