/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.posix.jvmstat;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.headers.LibC;
import com.oracle.svm.core.jdk.DirectByteBufferUtil;
import com.oracle.svm.core.jvmstat.PerfManager;
import com.oracle.svm.core.jvmstat.PerfMemoryPrologue;
import com.oracle.svm.core.jvmstat.PerfMemoryProvider;
import com.oracle.svm.core.os.RawFileOperationSupport;
import com.oracle.svm.core.os.VirtualMemoryProvider;
import com.oracle.svm.core.posix.PosixStat;
import com.oracle.svm.core.posix.PosixUtils;
import com.oracle.svm.core.posix.headers.Dirent;
import com.oracle.svm.core.posix.headers.Errno;
import com.oracle.svm.core.posix.headers.Fcntl;
import com.oracle.svm.core.posix.headers.Mman;
import com.oracle.svm.core.posix.headers.Signal;
import com.oracle.svm.core.posix.headers.Unistd;
import com.oracle.svm.core.posix.jvmstat.Target_jdk_internal_vm_VMSupport;
import java.nio.ByteBuffer;
import org.graalvm.compiler.core.common.NumUtil;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.nativeimage.c.type.CTypeConversion;
import org.graalvm.word.Pointer;
import org.graalvm.word.WordFactory;

class PosixPerfMemoryProvider
implements PerfMemoryProvider {
    private static final String PERFDATA_NAME = "hsperfdata";
    private String backingFilePath;

    @Platforms(value={Platform.HOSTED_ONLY.class})
    PosixPerfMemoryProvider() {
    }

    @Override
    public ByteBuffer create() {
        int fd;
        assert (this.backingFilePath == null);
        int size = NumUtil.roundUp((int)PerfManager.Options.PerfDataMemorySize.getValue(), (int)Unistd.getpagesize());
        if (size <= PerfMemoryPrologue.getPrologueSize()) {
            return null;
        }
        int vmId = Unistd.getpid();
        String userName = PosixUtils.getUserName(Unistd.NoTransitions.geteuid());
        if (userName == null) {
            return null;
        }
        String dirName = PosixPerfMemoryProvider.getUserTmpDir(userName, vmId, -1);
        String fileName = PosixPerfMemoryProvider.getSharedMemFileName(vmId, -1);
        try (CTypeConversion.CCharPointerHolder d = CTypeConversion.toCString((CharSequence)dirName);){
            PosixPerfMemoryProvider.cleanupSharedMemResources(d.get(), vmId);
            try (CTypeConversion.CCharPointerHolder f = CTypeConversion.toCString((CharSequence)fileName);){
                fd = PosixPerfMemoryProvider.createSharedMemResources(d.get(), f.get(), size);
            }
        }
        if (fd == -1) {
            return null;
        }
        Pointer mapAddress = Mman.mmap(WordFactory.nullPointer(), WordFactory.unsigned((int)size), Mman.PROT_READ() | Mman.PROT_WRITE(), Mman.MAP_SHARED(), fd, 0L);
        int result = Unistd.NoTransitions.close(fd);
        assert (result != -1);
        String filePath = dirName + "/" + fileName;
        if (mapAddress == Mman.MAP_FAILED()) {
            PosixPerfMemoryProvider.restartableUnlink(filePath);
            return null;
        }
        this.backingFilePath = filePath;
        LibC.memset(mapAddress, WordFactory.signed((int)0), WordFactory.unsigned((int)size));
        return DirectByteBufferUtil.allocate(mapAddress.rawValue(), size);
    }

    private static String getUserTmpDir(String user, int vmId, int nsPid) {
        Object tmpDir = Target_jdk_internal_vm_VMSupport.getVMTemporaryDirectory();
        if (Platform.includedIn(Platform.LINUX.class) && nsPid != -1) {
            tmpDir = "/proc/" + vmId + "/root" + (String)tmpDir;
        }
        return (String)tmpDir + "/hsperfdata_" + user;
    }

    private static String getSharedMemFileName(int vmId, int nspid) {
        int pid = vmId;
        if (Platform.includedIn(Platform.LINUX.class) && nspid != -1) {
            pid = nspid;
        }
        return Integer.toString(pid);
    }

    private static void cleanupSharedMemResources(CCharPointer directoryPath, int selfPid) {
        try (SecureDirectory s = PosixPerfMemoryProvider.openDirectorySecure(directoryPath);){
            Dirent.dirent entry;
            if (s == null) {
                return;
            }
            while ((entry = Dirent.readdir(s.dir)).isNonNull()) {
                String name = CTypeConversion.toJavaString((CCharPointer)entry.d_name());
                int pid = PosixPerfMemoryProvider.filenameToPid(name);
                if (pid == 0) {
                    if (".".equals(name) || "..".equals(name)) continue;
                    Fcntl.NoTransitions.unlinkat(s.fd, entry.d_name(), 0);
                    continue;
                }
                if (pid != selfPid && !PosixPerfMemoryProvider.canFileBeDeleted(pid)) continue;
                Fcntl.NoTransitions.unlinkat(s.fd, entry.d_name(), 0);
            }
        }
    }

    private static int createSharedMemResources(CCharPointer directoryPath, CCharPointer filename, int size) {
        if (!PosixPerfMemoryProvider.makeUserTmpDir(directoryPath)) {
            return -1;
        }
        int fd = PosixPerfMemoryProvider.tryCreatePerfFile(directoryPath, filename);
        if (fd == -1) {
            return -1;
        }
        if (!PosixPerfMemoryProvider.isFileSecure(fd)) {
            Unistd.NoTransitions.close(fd);
            return -1;
        }
        int result = PosixPerfMemoryProvider.restartableFtruncate(fd, 0);
        if (result == -1) {
            Unistd.NoTransitions.close(fd);
            return -1;
        }
        result = PosixPerfMemoryProvider.restartableFtruncate(fd, size);
        if (result == -1) {
            Unistd.NoTransitions.close(fd);
            return -1;
        }
        RawFileOperationSupport fs = RawFileOperationSupport.nativeByteOrder();
        RawFileOperationSupport.RawFileDescriptor rawFd = (RawFileOperationSupport.RawFileDescriptor)WordFactory.signed((int)fd);
        int pageSize = NumUtil.safeToInt((long)VirtualMemoryProvider.get().getGranularity().rawValue());
        boolean success = true;
        for (int pos = 0; pos < size && (success = fs.seek(rawFd, pos)) && (success = fs.writeInt(rawFd, 0)); pos += pageSize) {
        }
        if (!success) {
            Unistd.NoTransitions.close(fd);
            return -1;
        }
        return fd;
    }

    private static int tryCreatePerfFile(CCharPointer directoryPath, CCharPointer filename) {
        try (SecureDirectory s = PosixPerfMemoryProvider.openDirectorySecure(directoryPath);){
            if (s == null) {
                int n = -1;
                return n;
            }
            int n = PosixPerfMemoryProvider.restartableOpenat(s.fd, filename, Fcntl.O_RDWR() | Fcntl.O_CREAT() | Fcntl.O_NOFOLLOW(), PosixStat.S_IRUSR() | PosixStat.S_IWUSR());
            return n;
        }
    }

    private static int filenameToPid(String filename) {
        try {
            return Integer.parseInt(filename);
        }
        catch (NumberFormatException ex) {
            return 0;
        }
    }

    @Uninterruptible(reason="LibC.errno() must not be overwritten accidentally.")
    private static boolean makeUserTmpDir(CCharPointer directory) {
        if (PosixStat.NoTransitions.mkdir(directory, PosixStat.S_IRWXU() | PosixStat.S_IRGRP() | PosixStat.S_IXGRP() | PosixStat.S_IROTH() | PosixStat.S_IXOTH()) == -1) {
            if (LibC.errno() == Errno.EEXIST()) {
                return PosixPerfMemoryProvider.isDirectorySecure(directory);
            }
            return false;
        }
        return true;
    }

    private static SecureDirectory openDirectorySecure(CCharPointer directory) {
        int fd = PosixPerfMemoryProvider.restartableOpen(directory, Fcntl.O_RDONLY() | Fcntl.O_NOFOLLOW(), 0);
        if (fd == -1) {
            return null;
        }
        if (!PosixPerfMemoryProvider.isDirFdSecure(fd)) {
            Unistd.NoTransitions.close(fd);
            return null;
        }
        Dirent.DIR dir = Dirent.fdopendir(fd);
        if (dir.isNull()) {
            Unistd.NoTransitions.close(fd);
            return null;
        }
        return new SecureDirectory(fd, dir);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static boolean isDirectorySecure(CCharPointer directory) {
        PosixStat.stat buf = (PosixStat.stat)StackValue.get((int)PosixStat.sizeOfStatStruct());
        int result = PosixPerfMemoryProvider.restartableLstat(directory, buf);
        if (result == -1) {
            return false;
        }
        return PosixPerfMemoryProvider.isStatBufSecure(buf);
    }

    private static boolean isDirFdSecure(int dirFd) {
        PosixStat.stat buf = (PosixStat.stat)StackValue.get((int)PosixStat.sizeOfStatStruct());
        int result = PosixPerfMemoryProvider.restartableFstat(dirFd, buf);
        if (result == -1) {
            return false;
        }
        return PosixPerfMemoryProvider.isStatBufSecure(buf);
    }

    private static boolean isFileSecure(int fd) {
        PosixStat.stat buf = (PosixStat.stat)StackValue.get((int)PosixStat.sizeOfStatStruct());
        int result = PosixPerfMemoryProvider.restartableFstat(fd, buf);
        if (result == -1) {
            return false;
        }
        return !PosixStat.st_nlink(buf).aboveThan(1);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static boolean isStatBufSecure(PosixStat.stat statp) {
        if (PosixStat.S_ISLNK(statp) || !PosixStat.S_ISDIR(statp)) {
            return false;
        }
        if (PosixStat.st_mode(statp).and(PosixStat.S_IWGRP() | PosixStat.S_IWOTH()).notEqual(0)) {
            return false;
        }
        int euid = Unistd.NoTransitions.geteuid();
        return euid == 0 || PosixStat.st_uid(statp) == euid;
    }

    @Uninterruptible(reason="LibC.errno() must not be overwritten accidentally.")
    private static boolean canFileBeDeleted(int pid) {
        int ret = Signal.NoTransitions.kill(pid, 0);
        if (ret == -1) {
            int errno = LibC.errno();
            return errno == Errno.ESRCH() || errno == Errno.EPERM();
        }
        return false;
    }

    @Uninterruptible(reason="LibC.errno() must not be overwritten accidentally.")
    private static int restartableOpen(CCharPointer directory, int flags, int mode) {
        int result;
        while ((result = Fcntl.NoTransitions.open(directory, flags, mode)) == -1 && LibC.errno() == Errno.EINTR()) {
        }
        return result;
    }

    @Uninterruptible(reason="LibC.errno() must not be overwritten accidentally.")
    private static int restartableOpenat(int fd, CCharPointer filename, int flags, int mode) {
        int result;
        while ((result = Fcntl.NoTransitions.openat(fd, filename, flags, mode)) == -1 && LibC.errno() == Errno.EINTR()) {
        }
        return result;
    }

    private static int restartableUnlink(String pathname) {
        try (CTypeConversion.CCharPointerHolder f = CTypeConversion.toCString((CharSequence)pathname);){
            int n = PosixPerfMemoryProvider.restartableUnlink(f.get());
            return n;
        }
    }

    @Uninterruptible(reason="LibC.errno() must not be overwritten accidentally.")
    private static int restartableUnlink(CCharPointer pathname) {
        int result;
        while ((result = Fcntl.NoTransitions.unlink(pathname)) == -1 && LibC.errno() == Errno.EINTR()) {
        }
        return result;
    }

    @Uninterruptible(reason="LibC.errno() must not be overwritten accidentally.")
    private static int restartableFtruncate(int fd, int size) {
        int result;
        while ((result = Unistd.NoTransitions.ftruncate(fd, WordFactory.signed((int)size))) == -1 && LibC.errno() == Errno.EINTR()) {
        }
        return result;
    }

    @Uninterruptible(reason="LibC.errno() must not be overwritten accidentally.")
    private static int restartableFstat(int fd, PosixStat.stat buf) {
        int result;
        while ((result = PosixStat.NoTransitions.fstat(fd, buf)) == -1 && LibC.errno() == Errno.EINTR()) {
        }
        return result;
    }

    @Uninterruptible(reason="LibC.errno() must not be overwritten accidentally.")
    private static int restartableLstat(CCharPointer directory, PosixStat.stat buf) {
        int result;
        while ((result = PosixStat.NoTransitions.lstat(directory, buf)) == -1 && LibC.errno() == Errno.EINTR()) {
        }
        return result;
    }

    @Override
    public void teardown() {
        if (this.backingFilePath != null) {
            PosixPerfMemoryProvider.restartableUnlink(this.backingFilePath);
            this.backingFilePath = null;
        }
    }

    private static class SecureDirectory
    implements AutoCloseable {
        private final int fd;
        private final Dirent.DIR dir;

        SecureDirectory(int fd, Dirent.DIR dir) {
            this.fd = fd;
            this.dir = dir;
        }

        @Override
        public void close() {
            Dirent.closedir(this.dir);
        }
    }
}

