/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jni.headers;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.jni.headers.JNIHeaderDirectives;
import com.oracle.svm.core.jni.headers.JNIVersionJDK19OrLater;
import com.oracle.svm.core.jni.headers.JNIVersionJDK20OrLater;
import com.oracle.svm.core.jni.headers.JNIVersionJDK21OrLater;
import org.graalvm.compiler.serviceprovider.JavaVersionUtil;
import org.graalvm.nativeimage.c.CContext;
import org.graalvm.nativeimage.c.constant.CConstant;

@CContext(value=JNIHeaderDirectives.class)
public final class JNIVersion {
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static boolean isSupported(int version) {
        return JavaVersionUtil.JAVA_SPEC >= 21 && version == JNIVersionJDK21OrLater.JNI_VERSION_21() || JavaVersionUtil.JAVA_SPEC >= 20 && version == JNIVersionJDK20OrLater.JNI_VERSION_20() || JavaVersionUtil.JAVA_SPEC >= 19 && version == JNIVersionJDK19OrLater.JNI_VERSION_19() || version == JNIVersion.JNI_VERSION_10() || version == JNIVersion.JNI_VERSION_9() || version == JNIVersion.JNI_VERSION_1_8() || version == JNIVersion.JNI_VERSION_1_6() || version == JNIVersion.JNI_VERSION_1_4() || version == JNIVersion.JNI_VERSION_1_2() || version == JNIVersion.JNI_VERSION_1_1();
    }

    @CConstant
    public static native int JNI_VERSION_1_1();

    @CConstant
    public static native int JNI_VERSION_1_2();

    @CConstant
    public static native int JNI_VERSION_1_4();

    @CConstant
    public static native int JNI_VERSION_1_6();

    @CConstant
    public static native int JNI_VERSION_1_8();

    @CConstant
    public static native int JNI_VERSION_9();

    @CConstant
    public static native int JNI_VERSION_10();

    private JNIVersion() {
    }
}

