/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.snippets;

import com.oracle.svm.core.FrameAccess;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.code.CodeInfoTable;
import com.oracle.svm.core.graal.code.SubstrateBackend;
import com.oracle.svm.core.graal.code.SubstrateCallingConventionType;
import com.oracle.svm.core.graal.meta.KnownOffsets;
import com.oracle.svm.core.graal.meta.RuntimeConfiguration;
import com.oracle.svm.core.graal.nodes.LoweredDeadEndNode;
import com.oracle.svm.core.graal.nodes.ThrowBytecodeExceptionNode;
import com.oracle.svm.core.graal.snippets.NodeLoweringProvider;
import com.oracle.svm.core.meta.SharedMethod;
import com.oracle.svm.core.meta.SubstrateObjectConstant;
import com.oracle.svm.core.snippets.ImplicitExceptions;
import com.oracle.svm.core.snippets.SnippetRuntime;
import com.oracle.svm.core.snippets.SubstrateForeignCallTarget;
import com.oracle.svm.core.util.VMError;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import jdk.vm.ci.code.CallingConvention;
import jdk.vm.ci.meta.DeoptimizationAction;
import jdk.vm.ci.meta.DeoptimizationReason;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.compiler.core.common.memory.BarrierType;
import org.graalvm.compiler.core.common.memory.MemoryOrderMode;
import org.graalvm.compiler.core.common.spi.ForeignCallDescriptor;
import org.graalvm.compiler.core.common.type.StampPair;
import org.graalvm.compiler.core.common.type.TypeReference;
import org.graalvm.compiler.graph.Graph;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeInputList;
import org.graalvm.compiler.nodes.AbstractBeginNode;
import org.graalvm.compiler.nodes.BeginNode;
import org.graalvm.compiler.nodes.CallTargetNode;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.DirectCallTargetNode;
import org.graalvm.compiler.nodes.FixedGuardNode;
import org.graalvm.compiler.nodes.FixedNode;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.IfNode;
import org.graalvm.compiler.nodes.IndirectCallTargetNode;
import org.graalvm.compiler.nodes.Invoke;
import org.graalvm.compiler.nodes.InvokeNode;
import org.graalvm.compiler.nodes.InvokeWithExceptionNode;
import org.graalvm.compiler.nodes.LogicConstantNode;
import org.graalvm.compiler.nodes.LogicNode;
import org.graalvm.compiler.nodes.LoweredCallTargetNode;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.PiNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.calc.IsNullNode;
import org.graalvm.compiler.nodes.extended.BranchProbabilityNode;
import org.graalvm.compiler.nodes.extended.BytecodeExceptionNode;
import org.graalvm.compiler.nodes.extended.FixedValueAnchorNode;
import org.graalvm.compiler.nodes.extended.ForeignCallNode;
import org.graalvm.compiler.nodes.extended.GetClassNode;
import org.graalvm.compiler.nodes.extended.LoadHubNode;
import org.graalvm.compiler.nodes.extended.OpaqueValueNode;
import org.graalvm.compiler.nodes.java.InstanceOfNode;
import org.graalvm.compiler.nodes.java.MethodCallTargetNode;
import org.graalvm.compiler.nodes.memory.ReadNode;
import org.graalvm.compiler.nodes.memory.address.AddressNode;
import org.graalvm.compiler.nodes.memory.address.OffsetAddressNode;
import org.graalvm.compiler.nodes.spi.LoweringTool;
import org.graalvm.compiler.nodes.spi.StampProvider;
import org.graalvm.compiler.nodes.type.StampTool;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.phases.util.Providers;
import org.graalvm.word.LocationIdentity;

public abstract class NonSnippetLowerings {
    public static final SnippetRuntime.SubstrateForeignCallDescriptor REPORT_VERIFY_TYPES_ERROR = SnippetRuntime.findForeignCall(NonSnippetLowerings.class, "reportVerifyTypesError", false, LocationIdentity.any());
    private final Predicate<ResolvedJavaMethod> mustNotAllocatePredicate;
    final boolean verifyTypes = SubstrateOptions.VerifyTypes.getValue();
    private static final EnumMap<BytecodeExceptionNode.BytecodeExceptionKind, ForeignCallDescriptor> getCachedExceptionDescriptors = new EnumMap(BytecodeExceptionNode.BytecodeExceptionKind.class);
    private static final EnumMap<BytecodeExceptionNode.BytecodeExceptionKind, ForeignCallDescriptor> createExceptionDescriptors;
    private static final EnumMap<BytecodeExceptionNode.BytecodeExceptionKind, ForeignCallDescriptor> throwCachedExceptionDescriptors;
    private static final EnumMap<BytecodeExceptionNode.BytecodeExceptionKind, ForeignCallDescriptor> throwNewExceptionDescriptors;

    protected NonSnippetLowerings(RuntimeConfiguration runtimeConfig, Predicate<ResolvedJavaMethod> mustNotAllocatePredicate, OptionValues options, Providers providers, Map<Class<? extends Node>, NodeLoweringProvider<?>> lowerings, boolean hosted) {
        this.mustNotAllocatePredicate = mustNotAllocatePredicate;
        if (hosted) {
            lowerings.put(BytecodeExceptionNode.class, new BytecodeExceptionLowering());
            lowerings.put(ThrowBytecodeExceptionNode.class, new ThrowBytecodeExceptionLowering());
        }
        lowerings.put(GetClassNode.class, new GetClassLowering());
        InvokeLowering invokeLowering = new InvokeLowering(runtimeConfig, this.verifyTypes, KnownOffsets.singleton());
        lowerings.put(InvokeNode.class, invokeLowering);
        lowerings.put(InvokeWithExceptionNode.class, invokeLowering);
    }

    private ForeignCallDescriptor lookupBytecodeException(BytecodeExceptionNode.BytecodeExceptionKind exceptionKind, NodeInputList<ValueNode> exceptionArguments, StructuredGraph graph, LoweringTool tool, EnumMap<BytecodeExceptionNode.BytecodeExceptionKind, ForeignCallDescriptor> withoutAllocationDescriptors, EnumMap<BytecodeExceptionNode.BytecodeExceptionKind, ForeignCallDescriptor> withAllocationDescriptors, List<ValueNode> outArguments) {
        ForeignCallDescriptor descriptor;
        if (this.mustNotAllocatePredicate != null && this.mustNotAllocatePredicate.test(graph.method())) {
            descriptor = withoutAllocationDescriptors.get(exceptionKind);
        } else {
            descriptor = withAllocationDescriptors.get(exceptionKind);
            if (exceptionKind.getExceptionMessage() != null) {
                outArguments.add((ValueNode)ConstantNode.forConstant((JavaConstant)tool.getConstantReflection().forString(exceptionKind.getExceptionMessage()), (MetaAccessProvider)tool.getMetaAccess(), (StructuredGraph)graph));
            }
            outArguments.addAll((Collection<ValueNode>)exceptionArguments);
        }
        VMError.guarantee(descriptor != null, "No ForeignCallDescriptor for ByteCodeExceptionKind %s", exceptionKind);
        assert (descriptor.getArgumentTypes().length == outArguments.size());
        return descriptor;
    }

    @SubstrateForeignCallTarget(stubCallingConvention=true)
    private static void reportVerifyTypesError(Object object, String message) {
        throw VMError.shouldNotReachHere("VerifyTypes: object=" + (object == null ? "null" : object.getClass().getTypeName()) + System.lineSeparator() + message + System.lineSeparator() + "VerifyTypes found a type error");
    }

    static {
        getCachedExceptionDescriptors.put(BytecodeExceptionNode.BytecodeExceptionKind.NULL_POINTER, ImplicitExceptions.GET_CACHED_NULL_POINTER_EXCEPTION);
        getCachedExceptionDescriptors.put(BytecodeExceptionNode.BytecodeExceptionKind.OUT_OF_BOUNDS, ImplicitExceptions.GET_CACHED_OUT_OF_BOUNDS_EXCEPTION);
        getCachedExceptionDescriptors.put(BytecodeExceptionNode.BytecodeExceptionKind.INTRINSIC_OUT_OF_BOUNDS, ImplicitExceptions.GET_CACHED_OUT_OF_BOUNDS_EXCEPTION);
        getCachedExceptionDescriptors.put(BytecodeExceptionNode.BytecodeExceptionKind.CLASS_CAST, ImplicitExceptions.GET_CACHED_CLASS_CAST_EXCEPTION);
        getCachedExceptionDescriptors.put(BytecodeExceptionNode.BytecodeExceptionKind.ARRAY_STORE, ImplicitExceptions.GET_CACHED_ARRAY_STORE_EXCEPTION);
        getCachedExceptionDescriptors.put(BytecodeExceptionNode.BytecodeExceptionKind.INCOMPATIBLE_CLASS_CHANGE, ImplicitExceptions.GET_CACHED_INCOMPATIBLE_CLASS_CHANGE_ERROR);
        getCachedExceptionDescriptors.put(BytecodeExceptionNode.BytecodeExceptionKind.ILLEGAL_ARGUMENT_EXCEPTION_NEGATIVE_LENGTH, ImplicitExceptions.GET_CACHED_ILLEGAL_ARGUMENT_EXCEPTION);
        getCachedExceptionDescriptors.put(BytecodeExceptionNode.BytecodeExceptionKind.ILLEGAL_ARGUMENT_EXCEPTION_ARGUMENT_IS_NOT_AN_ARRAY, ImplicitExceptions.GET_CACHED_ILLEGAL_ARGUMENT_EXCEPTION);
        getCachedExceptionDescriptors.put(BytecodeExceptionNode.BytecodeExceptionKind.NEGATIVE_ARRAY_SIZE, ImplicitExceptions.GET_CACHED_NEGATIVE_ARRAY_SIZE_EXCEPTION);
        getCachedExceptionDescriptors.put(BytecodeExceptionNode.BytecodeExceptionKind.DIVISION_BY_ZERO, ImplicitExceptions.GET_CACHED_ARITHMETIC_EXCEPTION);
        getCachedExceptionDescriptors.put(BytecodeExceptionNode.BytecodeExceptionKind.INTEGER_EXACT_OVERFLOW, ImplicitExceptions.GET_CACHED_ARITHMETIC_EXCEPTION);
        getCachedExceptionDescriptors.put(BytecodeExceptionNode.BytecodeExceptionKind.LONG_EXACT_OVERFLOW, ImplicitExceptions.GET_CACHED_ARITHMETIC_EXCEPTION);
        getCachedExceptionDescriptors.put(BytecodeExceptionNode.BytecodeExceptionKind.ASSERTION_ERROR_NULLARY, ImplicitExceptions.GET_CACHED_ASSERTION_ERROR);
        getCachedExceptionDescriptors.put(BytecodeExceptionNode.BytecodeExceptionKind.ASSERTION_ERROR_OBJECT, ImplicitExceptions.GET_CACHED_ASSERTION_ERROR);
        createExceptionDescriptors = new EnumMap(BytecodeExceptionNode.BytecodeExceptionKind.class);
        createExceptionDescriptors.put(BytecodeExceptionNode.BytecodeExceptionKind.NULL_POINTER, ImplicitExceptions.CREATE_NULL_POINTER_EXCEPTION);
        createExceptionDescriptors.put(BytecodeExceptionNode.BytecodeExceptionKind.OUT_OF_BOUNDS, ImplicitExceptions.CREATE_OUT_OF_BOUNDS_EXCEPTION);
        createExceptionDescriptors.put(BytecodeExceptionNode.BytecodeExceptionKind.INTRINSIC_OUT_OF_BOUNDS, ImplicitExceptions.CREATE_INTRINSIC_OUT_OF_BOUNDS_EXCEPTION);
        createExceptionDescriptors.put(BytecodeExceptionNode.BytecodeExceptionKind.CLASS_CAST, ImplicitExceptions.CREATE_CLASS_CAST_EXCEPTION);
        createExceptionDescriptors.put(BytecodeExceptionNode.BytecodeExceptionKind.ARRAY_STORE, ImplicitExceptions.CREATE_ARRAY_STORE_EXCEPTION);
        createExceptionDescriptors.put(BytecodeExceptionNode.BytecodeExceptionKind.INCOMPATIBLE_CLASS_CHANGE, ImplicitExceptions.CREATE_INCOMPATIBLE_CLASS_CHANGE_ERROR);
        createExceptionDescriptors.put(BytecodeExceptionNode.BytecodeExceptionKind.ILLEGAL_ARGUMENT_EXCEPTION_NEGATIVE_LENGTH, ImplicitExceptions.CREATE_ILLEGAL_ARGUMENT_EXCEPTION);
        createExceptionDescriptors.put(BytecodeExceptionNode.BytecodeExceptionKind.ILLEGAL_ARGUMENT_EXCEPTION_ARGUMENT_IS_NOT_AN_ARRAY, ImplicitExceptions.CREATE_ILLEGAL_ARGUMENT_EXCEPTION);
        createExceptionDescriptors.put(BytecodeExceptionNode.BytecodeExceptionKind.NEGATIVE_ARRAY_SIZE, ImplicitExceptions.CREATE_NEGATIVE_ARRAY_SIZE_EXCEPTION);
        createExceptionDescriptors.put(BytecodeExceptionNode.BytecodeExceptionKind.DIVISION_BY_ZERO, ImplicitExceptions.CREATE_DIVISION_BY_ZERO_EXCEPTION);
        createExceptionDescriptors.put(BytecodeExceptionNode.BytecodeExceptionKind.INTEGER_EXACT_OVERFLOW, ImplicitExceptions.CREATE_INTEGER_OVERFLOW_EXCEPTION);
        createExceptionDescriptors.put(BytecodeExceptionNode.BytecodeExceptionKind.LONG_EXACT_OVERFLOW, ImplicitExceptions.CREATE_LONG_OVERFLOW_EXCEPTION);
        createExceptionDescriptors.put(BytecodeExceptionNode.BytecodeExceptionKind.ASSERTION_ERROR_NULLARY, ImplicitExceptions.CREATE_ASSERTION_ERROR_NULLARY);
        createExceptionDescriptors.put(BytecodeExceptionNode.BytecodeExceptionKind.ASSERTION_ERROR_OBJECT, ImplicitExceptions.CREATE_ASSERTION_ERROR_OBJECT);
        throwCachedExceptionDescriptors = new EnumMap(BytecodeExceptionNode.BytecodeExceptionKind.class);
        throwCachedExceptionDescriptors.put(BytecodeExceptionNode.BytecodeExceptionKind.NULL_POINTER, ImplicitExceptions.THROW_CACHED_NULL_POINTER_EXCEPTION);
        throwCachedExceptionDescriptors.put(BytecodeExceptionNode.BytecodeExceptionKind.OUT_OF_BOUNDS, ImplicitExceptions.THROW_CACHED_OUT_OF_BOUNDS_EXCEPTION);
        throwCachedExceptionDescriptors.put(BytecodeExceptionNode.BytecodeExceptionKind.INTRINSIC_OUT_OF_BOUNDS, ImplicitExceptions.THROW_CACHED_OUT_OF_BOUNDS_EXCEPTION);
        throwCachedExceptionDescriptors.put(BytecodeExceptionNode.BytecodeExceptionKind.CLASS_CAST, ImplicitExceptions.THROW_CACHED_CLASS_CAST_EXCEPTION);
        throwCachedExceptionDescriptors.put(BytecodeExceptionNode.BytecodeExceptionKind.ARRAY_STORE, ImplicitExceptions.THROW_CACHED_ARRAY_STORE_EXCEPTION);
        throwCachedExceptionDescriptors.put(BytecodeExceptionNode.BytecodeExceptionKind.INCOMPATIBLE_CLASS_CHANGE, ImplicitExceptions.THROW_CACHED_INCOMPATIBLE_CLASS_CHANGE_ERROR);
        throwCachedExceptionDescriptors.put(BytecodeExceptionNode.BytecodeExceptionKind.ILLEGAL_ARGUMENT_EXCEPTION_NEGATIVE_LENGTH, ImplicitExceptions.THROW_CACHED_ILLEGAL_ARGUMENT_EXCEPTION);
        throwCachedExceptionDescriptors.put(BytecodeExceptionNode.BytecodeExceptionKind.ILLEGAL_ARGUMENT_EXCEPTION_ARGUMENT_IS_NOT_AN_ARRAY, ImplicitExceptions.THROW_CACHED_ILLEGAL_ARGUMENT_EXCEPTION);
        throwCachedExceptionDescriptors.put(BytecodeExceptionNode.BytecodeExceptionKind.NEGATIVE_ARRAY_SIZE, ImplicitExceptions.THROW_CACHED_NEGATIVE_ARRAY_SIZE_EXCEPTION);
        throwCachedExceptionDescriptors.put(BytecodeExceptionNode.BytecodeExceptionKind.DIVISION_BY_ZERO, ImplicitExceptions.THROW_CACHED_ARITHMETIC_EXCEPTION);
        throwCachedExceptionDescriptors.put(BytecodeExceptionNode.BytecodeExceptionKind.INTEGER_EXACT_OVERFLOW, ImplicitExceptions.THROW_CACHED_ARITHMETIC_EXCEPTION);
        throwCachedExceptionDescriptors.put(BytecodeExceptionNode.BytecodeExceptionKind.LONG_EXACT_OVERFLOW, ImplicitExceptions.THROW_CACHED_ARITHMETIC_EXCEPTION);
        throwCachedExceptionDescriptors.put(BytecodeExceptionNode.BytecodeExceptionKind.ASSERTION_ERROR_NULLARY, ImplicitExceptions.THROW_CACHED_ASSERTION_ERROR);
        throwCachedExceptionDescriptors.put(BytecodeExceptionNode.BytecodeExceptionKind.ASSERTION_ERROR_OBJECT, ImplicitExceptions.THROW_CACHED_ASSERTION_ERROR);
        throwNewExceptionDescriptors = new EnumMap(BytecodeExceptionNode.BytecodeExceptionKind.class);
        throwNewExceptionDescriptors.put(BytecodeExceptionNode.BytecodeExceptionKind.NULL_POINTER, ImplicitExceptions.THROW_NEW_NULL_POINTER_EXCEPTION);
        throwNewExceptionDescriptors.put(BytecodeExceptionNode.BytecodeExceptionKind.OUT_OF_BOUNDS, ImplicitExceptions.THROW_NEW_OUT_OF_BOUNDS_EXCEPTION_WITH_ARGS);
        throwNewExceptionDescriptors.put(BytecodeExceptionNode.BytecodeExceptionKind.INTRINSIC_OUT_OF_BOUNDS, ImplicitExceptions.THROW_NEW_INTRINSIC_OUT_OF_BOUNDS_EXCEPTION);
        throwNewExceptionDescriptors.put(BytecodeExceptionNode.BytecodeExceptionKind.CLASS_CAST, ImplicitExceptions.THROW_NEW_CLASS_CAST_EXCEPTION_WITH_ARGS);
        throwNewExceptionDescriptors.put(BytecodeExceptionNode.BytecodeExceptionKind.ARRAY_STORE, ImplicitExceptions.THROW_NEW_ARRAY_STORE_EXCEPTION_WITH_ARGS);
        throwNewExceptionDescriptors.put(BytecodeExceptionNode.BytecodeExceptionKind.INCOMPATIBLE_CLASS_CHANGE, ImplicitExceptions.THROW_NEW_INCOMPATIBLE_CLASS_CHANGE_ERROR);
        throwNewExceptionDescriptors.put(BytecodeExceptionNode.BytecodeExceptionKind.ILLEGAL_ARGUMENT_EXCEPTION_NEGATIVE_LENGTH, ImplicitExceptions.THROW_NEW_ILLEGAL_ARGUMENT_EXCEPTION_WITH_ARGS);
        throwNewExceptionDescriptors.put(BytecodeExceptionNode.BytecodeExceptionKind.ILLEGAL_ARGUMENT_EXCEPTION_ARGUMENT_IS_NOT_AN_ARRAY, ImplicitExceptions.THROW_NEW_ILLEGAL_ARGUMENT_EXCEPTION_WITH_ARGS);
        throwNewExceptionDescriptors.put(BytecodeExceptionNode.BytecodeExceptionKind.NEGATIVE_ARRAY_SIZE, ImplicitExceptions.THROW_NEW_NEGATIVE_ARRAY_SIZE_EXCEPTION);
        throwNewExceptionDescriptors.put(BytecodeExceptionNode.BytecodeExceptionKind.DIVISION_BY_ZERO, ImplicitExceptions.THROW_NEW_DIVISION_BY_ZERO_EXCEPTION);
        throwNewExceptionDescriptors.put(BytecodeExceptionNode.BytecodeExceptionKind.INTEGER_EXACT_OVERFLOW, ImplicitExceptions.THROW_NEW_INTEGER_OVERFLOW_EXCEPTION);
        throwNewExceptionDescriptors.put(BytecodeExceptionNode.BytecodeExceptionKind.LONG_EXACT_OVERFLOW, ImplicitExceptions.THROW_NEW_LONG_OVERFLOW_EXCEPTION);
        throwNewExceptionDescriptors.put(BytecodeExceptionNode.BytecodeExceptionKind.ASSERTION_ERROR_NULLARY, ImplicitExceptions.THROW_NEW_ASSERTION_ERROR_NULLARY);
        throwNewExceptionDescriptors.put(BytecodeExceptionNode.BytecodeExceptionKind.ASSERTION_ERROR_OBJECT, ImplicitExceptions.THROW_NEW_ASSERTION_ERROR_OBJECT);
    }

    private class BytecodeExceptionLowering
    implements NodeLoweringProvider<BytecodeExceptionNode> {
        private BytecodeExceptionLowering() {
        }

        @Override
        public void lower(BytecodeExceptionNode node, LoweringTool tool) {
            if (tool.getLoweringStage() == LoweringTool.StandardLoweringStage.HIGH_TIER) {
                return;
            }
            StructuredGraph graph = node.graph();
            ArrayList<ValueNode> arguments = new ArrayList<ValueNode>();
            ForeignCallDescriptor descriptor = NonSnippetLowerings.this.lookupBytecodeException(node.getExceptionKind(), (NodeInputList<ValueNode>)node.getArguments(), graph, tool, getCachedExceptionDescriptors, createExceptionDescriptors, arguments);
            ForeignCallNode foreignCallNode = (ForeignCallNode)graph.add((Node)new ForeignCallNode(descriptor, node.stamp(NodeView.DEFAULT), arguments));
            foreignCallNode.setValidateDeoptFrameStates(false);
            foreignCallNode.setStateDuring(node.createStateDuring());
            foreignCallNode.setStateAfter(node.stateAfter());
            graph.replaceFixedWithFixed((FixedWithNextNode)node, (FixedWithNextNode)foreignCallNode);
        }
    }

    private class ThrowBytecodeExceptionLowering
    implements NodeLoweringProvider<ThrowBytecodeExceptionNode> {
        private ThrowBytecodeExceptionLowering() {
        }

        @Override
        public void lower(ThrowBytecodeExceptionNode node, LoweringTool tool) {
            if (tool.getLoweringStage() == LoweringTool.StandardLoweringStage.HIGH_TIER) {
                return;
            }
            StructuredGraph graph = node.graph();
            ArrayList<ValueNode> arguments = new ArrayList<ValueNode>();
            ForeignCallDescriptor descriptor = NonSnippetLowerings.this.lookupBytecodeException(node.getExceptionKind(), node.getArguments(), graph, tool, throwCachedExceptionDescriptors, throwNewExceptionDescriptors, arguments);
            ForeignCallNode foreignCallNode = (ForeignCallNode)graph.add((Node)new ForeignCallNode(descriptor, node.stamp(NodeView.DEFAULT), arguments));
            foreignCallNode.setValidateDeoptFrameStates(false);
            foreignCallNode.setStateDuring(node.stateBefore());
            node.replaceAndDelete((Node)foreignCallNode);
            LoweredDeadEndNode deadEnd = (LoweredDeadEndNode)graph.add((Node)new LoweredDeadEndNode());
            foreignCallNode.setNext((FixedNode)deadEnd);
        }
    }

    private static class GetClassLowering
    implements NodeLoweringProvider<GetClassNode> {
        private GetClassLowering() {
        }

        @Override
        public void lower(GetClassNode node, LoweringTool tool) {
            StampProvider stampProvider = tool.getStampProvider();
            LoadHubNode loadHub = (LoadHubNode)node.graph().unique((Node)new LoadHubNode(stampProvider, node.getObject()));
            node.replaceAtUsagesAndDelete((Node)loadHub);
            tool.getLowerer().lower((Node)loadHub, tool);
        }
    }

    public static class InvokeLowering
    implements NodeLoweringProvider<FixedNode> {
        protected final RuntimeConfiguration runtimeConfig;
        protected final boolean verifyTypes;
        protected final KnownOffsets knownOffsets;

        public InvokeLowering(RuntimeConfiguration runtimeConfig, boolean verifyTypes, KnownOffsets knownOffsets) {
            this.runtimeConfig = runtimeConfig;
            this.verifyTypes = verifyTypes;
            this.knownOffsets = knownOffsets;
        }

        @Override
        public void lower(FixedNode node, LoweringTool tool) {
            StructuredGraph graph = node.graph();
            Invoke invoke = (Invoke)node;
            if (invoke.callTarget() instanceof MethodCallTargetNode) {
                CallTargetNode loweredCallTarget;
                MethodCallTargetNode callTarget = (MethodCallTargetNode)invoke.callTarget();
                NodeInputList parameters = callTarget.arguments();
                ValueNode receiver = parameters.size() <= 0 ? null : (ValueNode)parameters.get(0);
                FixedGuardNode nullCheck = null;
                if (!callTarget.isStatic() && receiver.getStackKind() == JavaKind.Object && !StampTool.isPointerNonNull((ValueNode)receiver)) {
                    LogicNode isNull = (LogicNode)graph.unique((Node)IsNullNode.create((ValueNode)receiver));
                    nullCheck = (FixedGuardNode)graph.add((Node)new FixedGuardNode(isNull, DeoptimizationReason.NullCheckException, DeoptimizationAction.None, true));
                    graph.addBeforeFixed(node, (FixedWithNextNode)nullCheck);
                }
                SharedMethod method = (SharedMethod)callTarget.targetMethod();
                JavaType[] signature = method.getSignature().toParameterTypes((JavaType)(callTarget.isStatic() ? null : method.getDeclaringClass()));
                SubstrateCallingConventionType callType = method.getCallingConventionKind().toType(true);
                CallTargetNode.InvokeKind invokeKind = callTarget.invokeKind();
                SharedMethod[] implementations = method.getImplementations();
                if (this.verifyTypes && !callTarget.isStatic() && receiver.getStackKind() == JavaKind.Object && !((SharedMethod)graph.method()).isUninterruptible()) {
                    Object errorMessage;
                    FixedValueAnchorNode anchoredReceiver = (FixedValueAnchorNode)graph.add((Node)new FixedValueAnchorNode(receiver));
                    graph.addBeforeFixed(node, (FixedWithNextNode)anchoredReceiver);
                    ValueNode opaqueReceiver = (ValueNode)graph.unique((Node)new OpaqueValueNode((ValueNode)anchoredReceiver));
                    TypeReference declaringClass = TypeReference.createTrustedWithoutAssumptions((ResolvedJavaType)method.getDeclaringClass());
                    LogicNode instanceOf = (LogicNode)graph.addOrUniqueWithInputs((Node)InstanceOfNode.create((TypeReference)declaringClass, (ValueNode)opaqueReceiver));
                    BeginNode passingBegin = (BeginNode)graph.add((Node)new BeginNode());
                    BeginNode failingBegin = (BeginNode)graph.add((Node)new BeginNode());
                    IfNode ifNode = (IfNode)graph.add((Node)new IfNode(instanceOf, (AbstractBeginNode)passingBegin, (AbstractBeginNode)failingBegin, BranchProbabilityNode.EXTREMELY_FAST_PATH_PROFILE));
                    ((FixedWithNextNode)node.predecessor()).setNext((FixedNode)ifNode);
                    passingBegin.setNext(node);
                    if (SubstrateUtil.HOSTED) {
                        errorMessage = "Invoke " + String.valueOf(invokeKind) + " of " + method.format("%H.%n(%p)%r");
                        errorMessage = (String)errorMessage + System.lineSeparator() + "  declaringClass = " + String.valueOf(declaringClass);
                        if (implementations.length == 0 || implementations.length > 10) {
                            errorMessage = (String)errorMessage + System.lineSeparator() + "  implementations.length = " + implementations.length;
                        } else {
                            for (int i = 0; i < implementations.length; ++i) {
                                errorMessage = (String)errorMessage + System.lineSeparator() + "  implementations[" + i + "] = " + implementations[i].format("%H.%n(%p)%r");
                            }
                        }
                    } else {
                        errorMessage = "Invoke (method name not added because message must be a compile-time constant)";
                    }
                    ConstantNode errorConstant = ConstantNode.forConstant((JavaConstant)tool.getConstantReflection().forString((String)errorMessage), (MetaAccessProvider)tool.getMetaAccess(), (StructuredGraph)graph);
                    ForeignCallNode reportError = (ForeignCallNode)graph.add((Node)new ForeignCallNode((ForeignCallDescriptor)REPORT_VERIFY_TYPES_ERROR, new ValueNode[]{opaqueReceiver, errorConstant}));
                    reportError.setStateAfter(invoke.stateAfter().duplicateModifiedDuringCall(invoke.bci(), node.getStackKind()));
                    failingBegin.setNext((FixedNode)reportError);
                    reportError.setNext((FixedNode)graph.add((Node)new LoweredDeadEndNode()));
                }
                LoadHubNode hub = null;
                if (invokeKind.isDirect() || implementations.length == 1) {
                    SharedMethod targetMethod = method;
                    if (!invokeKind.isDirect()) {
                        targetMethod = implementations[0];
                    }
                    if (!SubstrateBackend.shouldEmitOnlyIndirectCalls()) {
                        loweredCallTarget = this.createDirectCall(graph, callTarget, (NodeInputList<ValueNode>)parameters, signature, callType, invokeKind, targetMethod, node);
                    } else if (!targetMethod.hasCodeOffsetInImage()) {
                        loweredCallTarget = InvokeLowering.createUnreachableCallTarget(tool, node, (NodeInputList<ValueNode>)parameters, callTarget.returnStamp(), signature, method, callType, invokeKind);
                    } else {
                        JavaConstant codeInfo = SubstrateObjectConstant.forObject(CodeInfoTable.getImageCodeCache());
                        ConstantNode codeInfoConstant = ConstantNode.forConstant((JavaConstant)codeInfo, (MetaAccessProvider)tool.getMetaAccess(), (StructuredGraph)graph);
                        ConstantNode codeStartFieldOffset = ConstantNode.forIntegerKind((JavaKind)FrameAccess.getWordKind(), (long)this.knownOffsets.getImageCodeInfoCodeStartOffset(), (StructuredGraph)graph);
                        AddressNode codeStartField = (AddressNode)graph.unique((Node)new OffsetAddressNode((ValueNode)codeInfoConstant, (ValueNode)codeStartFieldOffset));
                        ReadNode codeStart = (ReadNode)graph.add((Node)new ReadNode(codeStartField, LocationIdentity.ANY_LOCATION, FrameAccess.getWordStamp(), BarrierType.NONE, MemoryOrderMode.PLAIN));
                        ConstantNode offset = ConstantNode.forIntegerKind((JavaKind)FrameAccess.getWordKind(), (long)targetMethod.getCodeOffsetInImage(), (StructuredGraph)graph);
                        AddressNode address = (AddressNode)graph.unique((Node)new OffsetAddressNode((ValueNode)codeStart, (ValueNode)offset));
                        loweredCallTarget = (CallTargetNode)graph.add((Node)new IndirectCallTargetNode((ValueNode)address, (ValueNode[])parameters.toArray((Object[])new ValueNode[parameters.size()]), callTarget.returnStamp(), signature, (ResolvedJavaMethod)targetMethod, (CallingConvention.Type)callType, invokeKind));
                        graph.addBeforeFixed(node, (FixedWithNextNode)codeStart);
                    }
                } else if (implementations.length == 0) {
                    loweredCallTarget = InvokeLowering.createUnreachableCallTarget(tool, node, (NodeInputList<ValueNode>)parameters, callTarget.returnStamp(), signature, method, callType, invokeKind);
                } else {
                    int vtableEntryOffset = this.knownOffsets.getVTableOffset(method.getVTableIndex());
                    hub = (LoadHubNode)graph.unique((Node)new LoadHubNode(this.runtimeConfig.getProviders().getStampProvider(), (ValueNode)graph.addOrUnique((Node)PiNode.create((ValueNode)receiver, (ValueNode)nullCheck))));
                    AddressNode address = (AddressNode)graph.unique((Node)new OffsetAddressNode((ValueNode)hub, (ValueNode)ConstantNode.forIntegerKind((JavaKind)FrameAccess.getWordKind(), (long)vtableEntryOffset, (StructuredGraph)graph)));
                    ReadNode entry = (ReadNode)graph.add((Node)new ReadNode(address, SubstrateBackend.getVTableIdentity(), FrameAccess.getWordStamp(), BarrierType.NONE, MemoryOrderMode.PLAIN));
                    loweredCallTarget = (CallTargetNode)graph.add((Node)new IndirectCallTargetNode((ValueNode)entry, (ValueNode[])parameters.toArray((Object[])new ValueNode[parameters.size()]), callTarget.returnStamp(), signature, (ResolvedJavaMethod)method, (CallingConvention.Type)callType, invokeKind));
                    graph.addBeforeFixed(node, (FixedWithNextNode)entry);
                }
                callTarget.replaceAndDelete((Node)loweredCallTarget);
                if (nullCheck != null) {
                    nullCheck.lower(tool);
                }
                if (hub != null) {
                    hub.lower(tool);
                }
            }
        }

        protected LoweredCallTargetNode createDirectCall(StructuredGraph graph, MethodCallTargetNode callTarget, NodeInputList<ValueNode> parameters, JavaType[] signature, CallingConvention.Type callType, CallTargetNode.InvokeKind invokeKind, SharedMethod targetMethod, FixedNode node) {
            return (LoweredCallTargetNode)graph.add((Node)new DirectCallTargetNode((ValueNode[])parameters.toArray((Object[])ValueNode.EMPTY_ARRAY), callTarget.returnStamp(), signature, (ResolvedJavaMethod)targetMethod, callType, invokeKind));
        }

        private static CallTargetNode createUnreachableCallTarget(LoweringTool tool, FixedNode node, NodeInputList<ValueNode> parameters, StampPair returnStamp, JavaType[] signature, SharedMethod method, CallingConvention.Type callType, CallTargetNode.InvokeKind invokeKind) {
            StructuredGraph graph = node.graph();
            FixedGuardNode unreachedGuard = (FixedGuardNode)graph.add((Node)new FixedGuardNode((LogicNode)LogicConstantNode.forBoolean((boolean)true, (Graph)graph), DeoptimizationReason.UnreachedCode, DeoptimizationAction.None, true));
            graph.addBeforeFixed(node, (FixedWithNextNode)unreachedGuard);
            unreachedGuard.lower(tool);
            return (CallTargetNode)graph.add((Node)new DirectCallTargetNode((ValueNode[])parameters.toArray((Object[])ValueNode.EMPTY_ARRAY), returnStamp, signature, (ResolvedJavaMethod)method, callType, invokeKind));
        }
    }
}

