/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.genscavenge;

import com.oracle.svm.core.MemoryWalker;
import com.oracle.svm.core.NeverInline;
import com.oracle.svm.core.SubstrateDiagnostics;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.genscavenge.AlignedHeapChunk;
import com.oracle.svm.core.genscavenge.AuxiliaryImageHeap;
import com.oracle.svm.core.genscavenge.GCAccounting;
import com.oracle.svm.core.genscavenge.GCImpl;
import com.oracle.svm.core.genscavenge.HeapAccounting;
import com.oracle.svm.core.genscavenge.HeapChunk;
import com.oracle.svm.core.genscavenge.HeapChunkProvider;
import com.oracle.svm.core.genscavenge.HeapParameters;
import com.oracle.svm.core.genscavenge.ImageHeapInfo;
import com.oracle.svm.core.genscavenge.ImageHeapWalker;
import com.oracle.svm.core.genscavenge.ObjectHeaderImpl;
import com.oracle.svm.core.genscavenge.OldGeneration;
import com.oracle.svm.core.genscavenge.PinnedObjectImpl;
import com.oracle.svm.core.genscavenge.RuntimeCodeInfoGCSupportImpl;
import com.oracle.svm.core.genscavenge.SerialAndEpsilonGCOptions;
import com.oracle.svm.core.genscavenge.SerialGCOptions;
import com.oracle.svm.core.genscavenge.Space;
import com.oracle.svm.core.genscavenge.ThreadLocalAllocation;
import com.oracle.svm.core.genscavenge.UnalignedHeapChunk;
import com.oracle.svm.core.genscavenge.YoungGeneration;
import com.oracle.svm.core.genscavenge.graal.ForcedSerialPostWriteBarrier;
import com.oracle.svm.core.graal.snippets.SubstrateAllocationSnippets;
import com.oracle.svm.core.heap.GC;
import com.oracle.svm.core.heap.Heap;
import com.oracle.svm.core.heap.NoAllocationVerifier;
import com.oracle.svm.core.heap.ObjectHeader;
import com.oracle.svm.core.heap.ObjectVisitor;
import com.oracle.svm.core.heap.ReferenceHandler;
import com.oracle.svm.core.heap.ReferenceHandlerThread;
import com.oracle.svm.core.heap.ReferenceInternals;
import com.oracle.svm.core.heap.RestrictHeapAccess;
import com.oracle.svm.core.heap.RuntimeCodeInfoGCSupport;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.jdk.UninterruptibleUtils;
import com.oracle.svm.core.locks.VMCondition;
import com.oracle.svm.core.locks.VMMutex;
import com.oracle.svm.core.log.Log;
import com.oracle.svm.core.nodes.CFunctionEpilogueNode;
import com.oracle.svm.core.nodes.CFunctionPrologueNode;
import com.oracle.svm.core.option.RuntimeOptionKey;
import com.oracle.svm.core.os.CommittedMemoryProvider;
import com.oracle.svm.core.snippets.KnownIntrinsics;
import com.oracle.svm.core.thread.PlatformThreads;
import com.oracle.svm.core.thread.VMOperation;
import com.oracle.svm.core.thread.VMThreads;
import com.oracle.svm.core.util.UnsignedUtils;
import com.oracle.svm.core.util.UserError;
import java.lang.ref.Reference;
import java.util.ArrayList;
import java.util.List;
import org.graalvm.compiler.api.directives.GraalDirectives;
import org.graalvm.compiler.api.replacements.Fold;
import org.graalvm.compiler.core.common.NumUtil;
import org.graalvm.compiler.core.common.SuppressFBWarnings;
import org.graalvm.compiler.nodes.extended.MembarNode;
import org.graalvm.compiler.nodes.memory.address.OffsetAddressNode;
import org.graalvm.compiler.word.Word;
import org.graalvm.nativeimage.CurrentIsolate;
import org.graalvm.nativeimage.IsolateThread;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.word.Pointer;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordBase;

public final class HeapImpl
extends Heap {
    private static final VMMutex REF_MUTEX = new VMMutex("referencePendingList");
    private static final VMCondition REF_CONDITION = new VMCondition(REF_MUTEX);
    private final int pageSize;
    private final YoungGeneration youngGeneration = new YoungGeneration("YoungGeneration");
    private final OldGeneration oldGeneration = new OldGeneration("OldGeneration");
    private final HeapChunkProvider chunkProvider = new HeapChunkProvider();
    private final ObjectHeaderImpl objectHeaderImpl = new ObjectHeaderImpl();
    private final GCImpl gcImpl;
    private final RuntimeCodeInfoGCSupportImpl runtimeCodeInfoGcSupport;
    private final ImageHeapInfo imageHeapInfo = new ImageHeapInfo();
    private final HeapAccounting accounting = new HeapAccounting();
    private Reference<?> refPendingList;
    private volatile long refListOfferCounter;
    private volatile long refListWaiterWakeUpCounter;
    private final UninterruptibleUtils.AtomicReference<PinnedObjectImpl> pinHead = new UninterruptibleUtils.AtomicReference();
    private List<Class<?>> classList;

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public HeapImpl(int pageSize) {
        this.pageSize = pageSize;
        this.gcImpl = new GCImpl();
        this.runtimeCodeInfoGcSupport = new RuntimeCodeInfoGCSupportImpl();
        HeapParameters.initialize();
        SubstrateDiagnostics.DiagnosticThunkRegistry.singleton().register(new DumpHeapSettingsAndStatistics());
        SubstrateDiagnostics.DiagnosticThunkRegistry.singleton().register(new DumpHeapUsage());
        SubstrateDiagnostics.DiagnosticThunkRegistry.singleton().register(new DumpChunkInformation());
    }

    @Fold
    public static HeapImpl getHeapImpl() {
        Heap heap = Heap.getHeap();
        assert (heap instanceof HeapImpl) : "VMConfiguration heap is not a HeapImpl.";
        return (HeapImpl)heap;
    }

    @Fold
    public static ImageHeapInfo getImageHeapInfo() {
        return HeapImpl.getHeapImpl().imageHeapInfo;
    }

    @Fold
    static HeapChunkProvider getChunkProvider() {
        return HeapImpl.getHeapImpl().chunkProvider;
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public boolean isInImageHeap(Object obj) {
        return this.isInImageHeap((Pointer)Word.objectToUntrackedPointer((Object)obj));
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public boolean isInImageHeap(Pointer objPointer) {
        return this.isInPrimaryImageHeap(objPointer) || AuxiliaryImageHeap.isPresent() && AuxiliaryImageHeap.singleton().containsObject(objPointer);
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public boolean isInPrimaryImageHeap(Object obj) {
        return this.isInPrimaryImageHeap((Pointer)Word.objectToUntrackedPointer((Object)obj));
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public boolean isInPrimaryImageHeap(Pointer objPointer) {
        return this.imageHeapInfo.isInImageHeap(objPointer);
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public void suspendAllocation() {
        ThreadLocalAllocation.suspendInCurrentThread();
    }

    @Override
    public void resumeAllocation() {
    }

    @Override
    public boolean walkObjects(ObjectVisitor visitor) {
        VMOperation.guaranteeInProgressAtSafepoint("must only be executed at a safepoint");
        return this.walkImageHeapObjects(visitor) && this.walkCollectedHeapObjects(visitor);
    }

    @Override
    @Uninterruptible(reason="Tear-down in progress.")
    public boolean tearDown() {
        this.youngGeneration.tearDown();
        this.oldGeneration.tearDown();
        HeapImpl.getChunkProvider().tearDown();
        return true;
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public ObjectHeader getObjectHeader() {
        return this.objectHeaderImpl;
    }

    @Fold
    static ObjectHeaderImpl getObjectHeaderImpl() {
        return HeapImpl.getHeapImpl().objectHeaderImpl;
    }

    @Override
    @Fold
    public GC getGC() {
        return HeapImpl.getHeapImpl().gcImpl;
    }

    @Fold
    static GCImpl getGCImpl() {
        return HeapImpl.getHeapImpl().gcImpl;
    }

    @Override
    @Fold
    public RuntimeCodeInfoGCSupport getRuntimeCodeInfoGCSupport() {
        return this.runtimeCodeInfoGcSupport;
    }

    @Fold
    public static HeapAccounting getAccounting() {
        return HeapImpl.getHeapImpl().accounting;
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public boolean isAllocationDisallowed() {
        return NoAllocationVerifier.isActive() || VMThreads.SafepointBehavior.ignoresSafepoints();
    }

    static void exitIfAllocationDisallowed(String callSite, String typeName) {
        if (HeapImpl.getHeapImpl().isAllocationDisallowed()) {
            NoAllocationVerifier.exit(callSite, typeName);
        }
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public YoungGeneration getYoungGeneration() {
        return this.youngGeneration;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public OldGeneration getOldGeneration() {
        return this.oldGeneration;
    }

    @Fold
    UninterruptibleUtils.AtomicReference<PinnedObjectImpl> getPinHead() {
        return this.pinHead;
    }

    void logUsage(Log log) {
        this.youngGeneration.logUsage(log);
        this.oldGeneration.logUsage(log);
    }

    void logChunks(Log log) {
        this.getYoungGeneration().logChunks(log);
        this.getOldGeneration().logChunks(log);
        HeapImpl.getChunkProvider().logFreeChunks(log);
    }

    void logImageHeapPartitionBoundaries(Log log) {
        ImageHeapInfo auxHeapInfo;
        log.string("Native image heap boundaries:").indent(true);
        this.imageHeapInfo.print(log);
        log.indent(false);
        if (AuxiliaryImageHeap.isPresent() && (auxHeapInfo = AuxiliaryImageHeap.singleton().getImageHeapInfo()) != null) {
            log.string("Auxiliary image heap boundaries:").indent(true);
            auxHeapInfo.print(log);
            log.indent(false);
        }
    }

    static void logZapValues(Log log) {
        if (HeapParameters.getZapProducedHeapChunks() || HeapParameters.getZapConsumedHeapChunks()) {
            if (HeapParameters.getZapProducedHeapChunks()) {
                log.string("producedHeapChunkZapInt: ").string(" hex: ").spaces(8).hex(HeapParameters.getProducedHeapChunkZapInt()).string(" signed: ").spaces(9).signed(HeapParameters.getProducedHeapChunkZapInt()).string(" unsigned: ").spaces(10).unsigned(HeapParameters.getProducedHeapChunkZapInt()).newline();
                log.string("producedHeapChunkZapWord:").string(" hex: ").hex((WordBase)HeapParameters.getProducedHeapChunkZapWord()).string(" signed: ").signed((WordBase)HeapParameters.getProducedHeapChunkZapWord()).string(" unsigned: ").unsigned((WordBase)HeapParameters.getProducedHeapChunkZapWord()).newline();
            }
            if (HeapParameters.getZapConsumedHeapChunks()) {
                log.string("consumedHeapChunkZapInt: ").string(" hex: ").spaces(8).hex(HeapParameters.getConsumedHeapChunkZapInt()).string(" signed: ").spaces(10).signed(HeapParameters.getConsumedHeapChunkZapInt()).string(" unsigned: ").spaces(10).unsigned(HeapParameters.getConsumedHeapChunkZapInt()).newline();
                log.string("consumedHeapChunkZapWord:").string(" hex: ").hex((WordBase)HeapParameters.getConsumedHeapChunkZapWord()).string(" signed: ").signed((WordBase)HeapParameters.getConsumedHeapChunkZapWord()).string(" unsigned: ").unsigned((WordBase)HeapParameters.getConsumedHeapChunkZapWord()).newline();
            }
        }
    }

    @Override
    public int getClassCount() {
        return this.imageHeapInfo.dynamicHubCount;
    }

    @Override
    protected List<Class<?>> getAllClasses() {
        if (this.classList == null) {
            ArrayList list = new ArrayList(1024);
            ImageHeapWalker.walkRegions(this.imageHeapInfo, new ClassListBuilderVisitor(list));
            list.trimToSize();
            MembarNode.memoryBarrier((MembarNode.FenceKind)MembarNode.FenceKind.STORE_STORE);
            this.classList = list;
        }
        assert (this.classList.size() == this.imageHeapInfo.dynamicHubCount);
        return this.classList;
    }

    @Override
    public void prepareForSafepoint() {
    }

    @Override
    public void endSafepoint() {
    }

    @Override
    @Uninterruptible(reason="Called during startup.")
    public void attachThread(IsolateThread isolateThread) {
    }

    @Override
    @Uninterruptible(reason="Thread is detaching and holds the THREAD_MUTEX.")
    public void detachThread(IsolateThread isolateThread) {
        ThreadLocalAllocation.disableAndFlushForThread(isolateThread);
    }

    @Fold
    public static boolean usesImageHeapChunks() {
        return HeapImpl.usesImageHeapCardMarking();
    }

    @Fold
    public static boolean usesImageHeapCardMarking() {
        Boolean enabled = SerialGCOptions.ImageHeapCardMarking.getValue();
        if (enabled == Boolean.FALSE || enabled == null && !SubstrateOptions.useRememberedSet()) {
            return false;
        }
        if (enabled == null) {
            return CommittedMemoryProvider.get().guaranteesHeapPreferredAddressSpaceAlignment();
        }
        UserError.guarantee(CommittedMemoryProvider.get().guaranteesHeapPreferredAddressSpaceAlignment(), "Enabling option %s requires a custom image heap alignment at runtime, which cannot be ensured with the current configuration (option %s might be disabled)", SerialGCOptions.ImageHeapCardMarking, SubstrateOptions.SpawnIsolates);
        return true;
    }

    @Override
    @Fold
    public int getPreferredAddressSpaceAlignment() {
        return UnsignedUtils.safeToInt(HeapParameters.getAlignedHeapChunkAlignment());
    }

    @Override
    @Fold
    public int getImageHeapOffsetInAddressSpace() {
        if (SubstrateOptions.SpawnIsolates.getValue().booleanValue() && SubstrateOptions.UseNullRegion.getValue().booleanValue() && CommittedMemoryProvider.get().guaranteesHeapPreferredAddressSpaceAlignment()) {
            return NumUtil.safeToInt((long)SerialAndEpsilonGCOptions.AlignedHeapChunkSize.getValue());
        }
        return 0;
    }

    @Override
    @Fold
    public int getImageHeapNullRegionSize() {
        if (SubstrateOptions.SpawnIsolates.getValue().booleanValue() && SubstrateOptions.UseNullRegion.getValue().booleanValue() && !CommittedMemoryProvider.get().guaranteesHeapPreferredAddressSpaceAlignment()) {
            return this.pageSize;
        }
        return 0;
    }

    @Override
    public boolean walkImageHeapObjects(ObjectVisitor visitor) {
        VMOperation.guaranteeInProgressAtSafepoint("Must only be called at a safepoint");
        if (visitor != null) {
            return ImageHeapWalker.walkImageHeapObjects(this.imageHeapInfo, visitor) && (!AuxiliaryImageHeap.isPresent() || AuxiliaryImageHeap.singleton().walkObjects(visitor));
        }
        return true;
    }

    @Override
    public boolean walkCollectedHeapObjects(ObjectVisitor visitor) {
        VMOperation.guaranteeInProgressAtSafepoint("Must only be called at a safepoint");
        ThreadLocalAllocation.disableAndFlushForAllThreads();
        return this.getYoungGeneration().walkObjects(visitor) && this.getOldGeneration().walkObjects(visitor);
    }

    @Override
    public void doReferenceHandling() {
        if (ReferenceHandler.isExecutedManually()) {
            GCImpl.doReferenceHandling();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"VO_VOLATILE_INCREMENT"}, justification="Only the GC increments the volatile field 'refListOfferCounter'.")
    void addToReferencePendingList(Reference<?> list) {
        assert (VMOperation.isGCInProgress());
        if (list == null) {
            return;
        }
        REF_MUTEX.lock();
        try {
            if (this.refPendingList != null) {
                Reference<?> current = this.refPendingList;
                Reference<?> next = ReferenceInternals.getNextDiscovered(current);
                while (next != null) {
                    current = next;
                    next = ReferenceInternals.getNextDiscovered(current);
                }
                ReferenceInternals.setNextDiscovered(current, list);
            } else {
                this.refPendingList = list;
                ++this.refListOfferCounter;
                REF_CONDITION.broadcast();
            }
        }
        finally {
            REF_MUTEX.unlock();
        }
    }

    @Override
    @Uninterruptible(reason="Safepoint while holding the lock could lead to a deadlock in GC.")
    public boolean hasReferencePendingList() {
        REF_MUTEX.lockNoTransition();
        try {
            boolean bl = this.hasReferencePendingListUnsafe();
            return bl;
        }
        finally {
            REF_MUTEX.unlock();
        }
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    boolean hasReferencePendingListUnsafe() {
        return this.refPendingList != null;
    }

    @Override
    public void waitForReferencePendingList() throws InterruptedException {
        assert (ReferenceHandlerThread.isReferenceHandlerThread());
        long initialOffers = this.refListOfferCounter;
        long initialWakeUps = this.refListWaiterWakeUpCounter;
        if (this.hasReferencePendingList()) {
            return;
        }
        if (Thread.interrupted() || !HeapImpl.waitForPendingReferenceList(initialOffers, initialWakeUps) && Thread.interrupted()) {
            throw new InterruptedException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean waitForPendingReferenceList(long initialOffers, long initialWakeUps) {
        Thread currentThread = Thread.currentThread();
        int oldThreadStatus = PlatformThreads.getThreadStatus(currentThread);
        PlatformThreads.setThreadStatus(currentThread, 657);
        try {
            boolean bl = HeapImpl.transitionToNativeThenAwaitPendingRefs(initialOffers, initialWakeUps);
            return bl;
        }
        finally {
            PlatformThreads.setThreadStatus(currentThread, oldThreadStatus);
        }
    }

    @NeverInline(value="Must not be inlined in a caller that has an exception handler: We only support InvokeNode and not InvokeWithExceptionNode between a CFunctionPrologueNode and CFunctionEpilogueNode")
    private static boolean transitionToNativeThenAwaitPendingRefs(long initialOffers, long initialWakeUps) {
        CFunctionPrologueNode.cFunctionPrologue(3);
        boolean offered = HeapImpl.awaitPendingRefsInNative(initialOffers, initialWakeUps);
        CFunctionEpilogueNode.cFunctionEpilogue(3);
        return offered;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Uninterruptible(reason="In native.")
    @NeverInline(value="Provide a return address for the Java frame anchor.")
    private static boolean awaitPendingRefsInNative(long initialOffers, long initialWakeUps) {
        REF_MUTEX.lockNoTransition();
        try {
            while (HeapImpl.getHeapImpl().refListOfferCounter == initialOffers && HeapImpl.getHeapImpl().refListWaiterWakeUpCounter == initialWakeUps) {
                REF_CONDITION.blockNoTransition();
            }
            boolean bl = HeapImpl.getHeapImpl().refListWaiterWakeUpCounter == initialWakeUps;
            return bl;
        }
        finally {
            REF_MUTEX.unlock();
        }
    }

    @Override
    @Uninterruptible(reason="Safepoint while holding the lock could lead to a deadlock in GC.")
    @SuppressFBWarnings(value={"VO_VOLATILE_INCREMENT"}, justification="We use a lock when incrementing the volatile field 'refListWaiterWakeUpCounter'.")
    public void wakeUpReferencePendingListWaiters() {
        REF_MUTEX.lockNoTransition();
        try {
            ++this.refListWaiterWakeUpCounter;
            REF_CONDITION.broadcast();
        }
        finally {
            REF_MUTEX.unlock();
        }
    }

    @Override
    @Uninterruptible(reason="Safepoint while holding the lock could lead to a deadlock in GC.")
    public Reference<?> getAndClearReferencePendingList() {
        REF_MUTEX.lockNoTransition();
        try {
            Reference<?> list = this.refPendingList;
            if (list != null) {
                this.refPendingList = null;
            }
            Reference<?> reference = list;
            return reference;
        }
        finally {
            REF_MUTEX.unlock();
        }
    }

    @Override
    public boolean printLocationInfo(Log log, UnsignedWord value, boolean allowJavaHeapAccess, boolean allowUnsafeOperations) {
        if (SubstrateOptions.SpawnIsolates.getValue().booleanValue()) {
            Pointer heapBase = KnownIntrinsics.heapBase();
            if (value.equal((UnsignedWord)heapBase)) {
                log.string("is the heap base");
                return true;
            }
            if (value.aboveThan((UnsignedWord)heapBase) && value.belowThan((UnsignedWord)HeapImpl.getImageHeapStart())) {
                log.string("points into the protected memory between the heap base and the image heap");
                return true;
            }
        }
        if (this.objectHeaderImpl.isEncodedObjectHeader((Word)value)) {
            log.string("is the encoded object header for an object of type ");
            DynamicHub hub = this.objectHeaderImpl.dynamicHubFromObjectHeader((Word)value);
            log.string(hub.getName());
            return true;
        }
        Pointer ptr = (Pointer)value;
        if (this.printLocationInfo(log, ptr, allowJavaHeapAccess, allowUnsafeOperations)) {
            if (allowJavaHeapAccess && this.objectHeaderImpl.pointsToObjectHeader(ptr)) {
                log.indent(true);
                SubstrateDiagnostics.printObjectInfo(log, ptr.toObject());
                log.redent(false);
            }
            return true;
        }
        return false;
    }

    @Override
    public void optionValueChanged(RuntimeOptionKey<?> key) {
        if (!SubstrateUtil.HOSTED) {
            GCImpl.getPolicy().updateSizeParameters();
        }
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public long getThreadAllocatedMemory(IsolateThread thread) {
        Pointer usedTlabSize;
        Pointer start;
        UnsignedWord allocatedBytes = ThreadLocalAllocation.allocatedBytes.getVolatile(thread);
        ThreadLocalAllocation.Descriptor tlab = ThreadLocalAllocation.getTlab(thread);
        AlignedHeapChunk.AlignedHeader alignedTlab = tlab.getAlignedChunk();
        Word top = tlab.getAllocationTop(SubstrateAllocationSnippets.TLAB_TOP_IDENTITY);
        if (top.aboveThan((UnsignedWord)(start = AlignedHeapChunk.getObjectsStart(alignedTlab))) && (usedTlabSize = top.subtract((UnsignedWord)start)).belowOrEqual(HeapParameters.getAlignedHeapChunkSize())) {
            return allocatedBytes.add((UnsignedWord)usedTlabSize).rawValue();
        }
        return allocatedBytes.rawValue();
    }

    @Override
    @Uninterruptible(reason="Ensure that no GC can occur between modification of the object and this call.", callerMustBe=true)
    public void dirtyAllReferencesOf(Object obj) {
        if (SubstrateOptions.useRememberedSet() && obj != null) {
            ForcedSerialPostWriteBarrier.force(OffsetAddressNode.address((Object)obj, (long)0L), false);
        }
    }

    @Override
    public long getMillisSinceLastWholeHeapExamined() {
        return HeapImpl.getGCImpl().getMillisSinceLastWholeHeapExamined();
    }

    @Override
    @Uninterruptible(reason="Ensure that no GC can move the object to another chunk.", callerMustBe=true)
    public long getIdentityHashSalt(Object obj) {
        if (!GraalDirectives.inIntrinsic()) assert (!this.isInImageHeap(obj)) : "Image heap objects have identity hash code fields";
        HeapChunk.Header<?> chunk = HeapChunk.getEnclosingHeapChunk(obj);
        return HeapChunk.getIdentityHashSalt(chunk).rawValue();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    static Pointer getImageHeapStart() {
        int imageHeapOffsetInAddressSpace = Heap.getHeap().getImageHeapOffsetInAddressSpace();
        if (imageHeapOffsetInAddressSpace > 0) {
            return KnownIntrinsics.heapBase().add(imageHeapOffsetInAddressSpace);
        }
        int nullRegionSize = Heap.getHeap().getImageHeapNullRegionSize();
        return KnownIntrinsics.heapBase().add(nullRegionSize);
    }

    private boolean printLocationInfo(Log log, Pointer ptr, boolean allowJavaHeapAccess, boolean allowUnsafeOperations) {
        if (this.imageHeapInfo.isInReadOnlyPrimitivePartition(ptr)) {
            log.string("points into the image heap (read-only primitives)");
            return true;
        }
        if (this.imageHeapInfo.isInReadOnlyReferencePartition(ptr)) {
            log.string("points into the image heap (read-only references)");
            return true;
        }
        if (this.imageHeapInfo.isInReadOnlyRelocatablePartition(ptr)) {
            log.string("points into the image heap (read-only relocatables)");
            return true;
        }
        if (this.imageHeapInfo.isInWritablePrimitivePartition(ptr)) {
            log.string("points into the image heap (writable primitives)");
            return true;
        }
        if (this.imageHeapInfo.isInWritableReferencePartition(ptr)) {
            log.string("points into the image heap (writable references)");
            return true;
        }
        if (this.imageHeapInfo.isInWritableHugePartition(ptr)) {
            log.string("points into the image heap (writable huge)");
            return true;
        }
        if (this.imageHeapInfo.isInReadOnlyHugePartition(ptr)) {
            log.string("points into the image heap (read-only huge)");
            return true;
        }
        if (AuxiliaryImageHeap.isPresent() && AuxiliaryImageHeap.singleton().containsObject(ptr)) {
            log.string("points into the auxiliary image heap");
            return true;
        }
        if (HeapImpl.printTlabInfo(log, ptr, CurrentIsolate.getCurrentThread())) {
            return true;
        }
        if (allowJavaHeapAccess) {
            if (this.isInYoungGen(ptr)) {
                log.string("points into the young generation");
                return true;
            }
            if (this.isInOldGen(ptr)) {
                log.string("points into the old generation");
                return true;
            }
        }
        if (allowUnsafeOperations || VMOperation.isInProgressAtSafepoint()) {
            return HeapImpl.printTlabInfo(log, ptr);
        }
        return false;
    }

    boolean isInHeap(Pointer ptr) {
        return this.isInImageHeap(ptr) || this.isInYoungGen(ptr) || this.isInOldGen(ptr);
    }

    @Uninterruptible(reason="Prevent that chunks are freed.")
    private boolean isInYoungGen(Pointer ptr) {
        if (HeapImpl.findPointerInSpace(this.youngGeneration.getEden(), ptr)) {
            return true;
        }
        for (int i = 0; i < this.youngGeneration.getMaxSurvivorSpaces(); ++i) {
            if (HeapImpl.findPointerInSpace(this.youngGeneration.getSurvivorFromSpaceAt(i), ptr)) {
                return true;
            }
            if (!HeapImpl.findPointerInSpace(this.youngGeneration.getSurvivorToSpaceAt(i), ptr)) continue;
            return true;
        }
        return false;
    }

    @Uninterruptible(reason="Prevent that chunks are freed.")
    private boolean isInOldGen(Pointer ptr) {
        return HeapImpl.findPointerInSpace(this.oldGeneration.getFromSpace(), ptr) || HeapImpl.findPointerInSpace(this.oldGeneration.getToSpace(), ptr);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static boolean findPointerInSpace(Space space, Pointer p) {
        AlignedHeapChunk.AlignedHeader aChunk = space.getFirstAlignedHeapChunk();
        while (aChunk.isNonNull()) {
            Pointer start = AlignedHeapChunk.getObjectsStart(aChunk);
            if (start.belowOrEqual((UnsignedWord)p) && p.belowThan((UnsignedWord)HeapChunk.getTopPointer(aChunk))) {
                return true;
            }
            aChunk = HeapChunk.getNext(aChunk);
        }
        UnalignedHeapChunk.UnalignedHeader uChunk = space.getFirstUnalignedHeapChunk();
        while (uChunk.isNonNull()) {
            Pointer start = UnalignedHeapChunk.getObjectStart(uChunk);
            if (start.belowOrEqual((UnsignedWord)p) && p.belowThan((UnsignedWord)HeapChunk.getTopPointer(uChunk))) {
                return true;
            }
            uChunk = HeapChunk.getNext(uChunk);
        }
        return false;
    }

    private static boolean printTlabInfo(Log log, Pointer ptr) {
        IsolateThread thread = VMThreads.firstThreadUnsafe();
        while (thread.isNonNull()) {
            if (HeapImpl.printTlabInfo(log, ptr, thread)) {
                return true;
            }
            thread = VMThreads.nextThread(thread);
        }
        return false;
    }

    private static boolean printTlabInfo(Log log, Pointer ptr, IsolateThread thread) {
        ThreadLocalAllocation.Descriptor tlab = HeapImpl.getTlabUnsafe(thread);
        AlignedHeapChunk.AlignedHeader aChunk = tlab.getAlignedChunk();
        while (aChunk.isNonNull()) {
            Pointer dataStart = AlignedHeapChunk.getObjectsStart(aChunk);
            Pointer dataEnd = AlignedHeapChunk.getObjectsEnd(aChunk);
            if (ptr.aboveOrEqual((UnsignedWord)dataStart) && ptr.belowThan((UnsignedWord)dataEnd)) {
                log.string("points into an aligned TLAB chunk of thread ").zhex((WordBase)thread);
                return true;
            }
            aChunk = HeapChunk.getNext(aChunk);
        }
        UnalignedHeapChunk.UnalignedHeader uChunk = tlab.getUnalignedChunk();
        while (uChunk.isNonNull()) {
            Pointer dataStart = UnalignedHeapChunk.getObjectStart(uChunk);
            Pointer dataEnd = UnalignedHeapChunk.getObjectEnd(uChunk);
            if (ptr.aboveOrEqual((UnsignedWord)dataStart) && ptr.belowThan((UnsignedWord)dataEnd)) {
                log.string("points into an unaligned TLAB chunk of thread ").zhex((WordBase)thread);
                return true;
            }
            uChunk = HeapChunk.getNext(uChunk);
        }
        return false;
    }

    @Uninterruptible(reason="This whole method is unsafe, so it is only uninterruptible to satisfy the checks.")
    private static ThreadLocalAllocation.Descriptor getTlabUnsafe(IsolateThread thread) {
        assert (SubstrateDiagnostics.isFatalErrorHandlingThread()) : "can cause crashes, so it may only be used while printing diagnostics";
        return ThreadLocalAllocation.getTlab(thread);
    }

    private static class DumpHeapSettingsAndStatistics
    extends SubstrateDiagnostics.DiagnosticThunk {
        private DumpHeapSettingsAndStatistics() {
        }

        @Override
        public int maxInvocationCount() {
            return 1;
        }

        @Override
        @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Must not allocate while printing diagnostics.")
        public void printDiagnostics(Log log, SubstrateDiagnostics.ErrorContext context, int maxDiagnosticLevel, int invocationCount) {
            log.string("Heap settings and statistics:").indent(true);
            log.string("Supports isolates: ").bool(SubstrateOptions.SpawnIsolates.getValue()).newline();
            if (SubstrateOptions.SpawnIsolates.getValue().booleanValue()) {
                log.string("Heap base: ").zhex((WordBase)KnownIntrinsics.heapBase()).newline();
            }
            log.string("Object reference size: ").signed(ConfigurationValues.getObjectLayout().getReferenceSize()).newline();
            log.string("Reserved object header bits: 0b").number(Heap.getHeap().getObjectHeader().getReservedBitsMask(), 2, false).newline();
            log.string("Aligned chunk size: ").unsigned((WordBase)HeapParameters.getAlignedHeapChunkSize()).newline();
            log.string("Large array threshold: ").unsigned((WordBase)HeapParameters.getLargeArrayThreshold()).newline();
            GCAccounting accounting = GCImpl.getAccounting();
            log.string("Incremental collections: ").unsigned(accounting.getIncrementalCollectionCount()).newline();
            log.string("Complete collections: ").unsigned(accounting.getCompleteCollectionCount()).newline();
            HeapImpl.logZapValues(log);
            log.indent(false);
        }
    }

    private static class DumpHeapUsage
    extends SubstrateDiagnostics.DiagnosticThunk {
        private DumpHeapUsage() {
        }

        @Override
        public int maxInvocationCount() {
            return 1;
        }

        @Override
        @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Must not allocate while printing diagnostics.")
        public void printDiagnostics(Log log, SubstrateDiagnostics.ErrorContext context, int maxDiagnosticLevel, int invocationCount) {
            log.string("Heap usage:").indent(true);
            HeapImpl.getHeapImpl().logUsage(log);
            log.indent(false);
        }
    }

    private static class DumpChunkInformation
    extends SubstrateDiagnostics.DiagnosticThunk {
        private DumpChunkInformation() {
        }

        @Override
        public int maxInvocationCount() {
            return 1;
        }

        @Override
        @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Must not allocate while printing diagnostics.")
        public void printDiagnostics(Log log, SubstrateDiagnostics.ErrorContext context, int maxDiagnosticLevel, int invocationCount) {
            HeapImpl heap = HeapImpl.getHeapImpl();
            heap.logImageHeapPartitionBoundaries(log);
            log.string("Heap chunks: E=eden, S=survivor, O=old, F=free; A=aligned chunk, U=unaligned chunk; T=to space").indent(true);
            heap.logChunks(log);
            log.indent(false);
        }
    }

    private static class ClassListBuilderVisitor
    implements MemoryWalker.ImageHeapRegionVisitor,
    ObjectVisitor {
        private final List<Class<?>> list;

        ClassListBuilderVisitor(List<Class<?>> list) {
            this.list = list;
        }

        @Override
        public <T> boolean visitNativeImageHeapRegion(T region, MemoryWalker.NativeImageHeapRegionAccess<T> access) {
            if (!access.isWritable(region) && access.containsReferences(region)) {
                access.visitObjects(region, this);
            }
            return true;
        }

        @Override
        @RestrictHeapAccess(access=RestrictHeapAccess.Access.UNRESTRICTED, reason="Allocation is fine: this method traverses only the image heap.")
        public boolean visitObject(Object o) {
            if (o instanceof Class) {
                this.list.add((Class)o);
            }
            return true;
        }
    }
}

