/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.code;

import com.oracle.svm.core.code.CodeCacheManagerMXBean;
import com.oracle.svm.core.code.CodeCachePoolMXBean;
import com.oracle.svm.core.code.CodeInfoDecoderCounters;
import com.oracle.svm.core.code.CodeInfoEncoder;
import com.oracle.svm.core.code.CodeInfoTable;
import com.oracle.svm.core.code.CodeInfoTableCounters;
import com.oracle.svm.core.code.ImageCodeInfo;
import com.oracle.svm.core.code.RuntimeCodeCache;
import com.oracle.svm.core.code.RuntimeCodeInfoHistory;
import com.oracle.svm.core.code.RuntimeCodeInfoMemory;
import com.oracle.svm.core.feature.AutomaticallyRegisteredFeature;
import com.oracle.svm.core.feature.InternalFeature;
import com.oracle.svm.core.jdk.management.ManagementSupport;
import com.oracle.svm.core.util.CounterFeature;
import java.lang.management.MemoryManagerMXBean;
import java.lang.management.MemoryPoolMXBean;
import java.util.Arrays;
import java.util.List;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.hosted.Feature;

@AutomaticallyRegisteredFeature
class CodeInfoFeature
implements InternalFeature {
    CodeInfoFeature() {
    }

    public List<Class<? extends Feature>> getRequiredFeatures() {
        return Arrays.asList(CounterFeature.class);
    }

    public void duringSetup(Feature.DuringSetupAccess access) {
        ImageSingletons.add(CodeInfoTableCounters.class, (Object)new CodeInfoTableCounters());
        ImageSingletons.add(CodeInfoDecoderCounters.class, (Object)new CodeInfoDecoderCounters());
        ImageSingletons.add(CodeInfoEncoder.Counters.class, (Object)new CodeInfoEncoder.Counters());
        ImageSingletons.add(ImageCodeInfo.class, (Object)new ImageCodeInfo());
        ImageSingletons.add(RuntimeCodeInfoHistory.class, (Object)new RuntimeCodeInfoHistory());
        ImageSingletons.add(RuntimeCodeCache.class, (Object)new RuntimeCodeCache());
        ImageSingletons.add(RuntimeCodeInfoMemory.class, (Object)new RuntimeCodeInfoMemory());
        List<CodeCacheManagerMXBean> memoryManagers = List.of(new CodeCacheManagerMXBean());
        List<MemoryPoolMXBean> memoryPools = CodeCachePoolMXBean.getMemoryPools();
        ManagementSupport managementSupport = ManagementSupport.getSingleton();
        managementSupport.addPlatformManagedObjectList(MemoryManagerMXBean.class, memoryManagers);
        managementSupport.addPlatformManagedObjectList(MemoryPoolMXBean.class, memoryPools);
    }

    public void afterCompilation(Feature.AfterCompilationAccess config) {
        ImageCodeInfo imageInfo = CodeInfoTable.getImageCodeCache();
        config.registerAsImmutable((Object)imageInfo);
        config.registerAsImmutable((Object)imageInfo.codeInfoIndex);
        config.registerAsImmutable((Object)imageInfo.codeInfoEncodings);
        config.registerAsImmutable((Object)imageInfo.referenceMapEncoding);
        config.registerAsImmutable((Object)imageInfo.frameInfoEncodings);
        config.registerAsImmutable((Object)imageInfo.frameInfoObjectConstants);
        config.registerAsImmutable(imageInfo.frameInfoSourceClasses);
        config.registerAsImmutable((Object)imageInfo.frameInfoSourceMethodNames);
    }
}

