/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.reachability;

import com.oracle.graal.pointsto.BigBang;
import com.oracle.graal.pointsto.ObjectScanner;
import com.oracle.graal.pointsto.ObjectScanningObserver;
import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.graal.pointsto.meta.AnalysisMetaAccess;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.reachability.ReachabilityAnalysisEngine;
import jdk.vm.ci.meta.JavaConstant;

public class ReachabilityObjectScanner
implements ObjectScanningObserver {
    private final ReachabilityAnalysisEngine bb;
    private final AnalysisMetaAccess access;

    public ReachabilityObjectScanner(BigBang bb, AnalysisMetaAccess access) {
        this.bb = (ReachabilityAnalysisEngine)bb;
        this.access = access;
    }

    public boolean forRelocatedPointerFieldValue(JavaConstant receiver, AnalysisField field, JavaConstant fieldValue, ObjectScanner.ScanReason reason) {
        if (!field.isWritten()) {
            return field.registerAsWritten((Object)reason);
        }
        return false;
    }

    public boolean forNullFieldValue(JavaConstant receiver, AnalysisField field, ObjectScanner.ScanReason reason) {
        boolean modified = false;
        if (receiver != null) {
            modified = this.bb.registerTypeAsReachable(this.constantType(receiver), reason);
        }
        return modified || this.bb.registerTypeAsReachable(field.getType(), reason);
    }

    public boolean forNonNullFieldValue(JavaConstant receiver, AnalysisField field, JavaConstant fieldValue, ObjectScanner.ScanReason reason) {
        boolean modified = false;
        if (receiver != null) {
            this.bb.registerTypeAsInHeap(this.constantType(receiver), reason);
            modified = this.bb.registerTypeAsReachable(this.constantType(receiver), reason);
        }
        return modified || this.bb.registerTypeAsReachable(field.getType(), reason);
    }

    public boolean forNullArrayElement(JavaConstant array, AnalysisType arrayType, int elementIndex, ObjectScanner.ScanReason reason) {
        return this.bb.registerTypeAsReachable(arrayType, reason);
    }

    public boolean forNonNullArrayElement(JavaConstant array, AnalysisType arrayType, JavaConstant elementConstant, AnalysisType elementType, int elementIndex, ObjectScanner.ScanReason reason) {
        return this.bb.registerTypeAsReachable(arrayType, reason) || this.bb.registerTypeAsInHeap(elementType, reason);
    }

    public void forEmbeddedRoot(JavaConstant root, ObjectScanner.ScanReason reason) {
        this.bb.registerTypeAsReachable(this.constantType(root), reason);
        this.bb.registerTypeAsInHeap(this.constantType(root), reason);
    }

    public void forScannedConstant(JavaConstant scannedValue, ObjectScanner.ScanReason reason) {
        AnalysisType type = this.constantType(scannedValue);
        this.bb.registerTypeAsInHeap(type, reason);
    }

    private AnalysisType constantType(JavaConstant constant) {
        return this.access.lookupJavaType(constant);
    }
}

