/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.flow;

import com.oracle.graal.pointsto.PointsToAnalysis;
import com.oracle.graal.pointsto.flow.TypeFlow;
import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.graal.pointsto.typestate.TypeState;

public class FieldFilterTypeFlow
extends TypeFlow<AnalysisField> {
    public FieldFilterTypeFlow(AnalysisField field) {
        super(field, field.getType());
    }

    @Override
    public TypeState filter(PointsToAnalysis bb, TypeState update) {
        if (this.declaredType.equals(bb.getObjectType())) {
            return update;
        }
        return TypeState.forIntersection(bb, update, this.declaredType.getAssignableTypes(true));
    }

    @Override
    protected void onInputSaturated(PointsToAnalysis bb, TypeFlow<?> input) {
        this.setSaturated();
        this.swapOut(bb, this.declaredType.getTypeFlow(bb, true));
    }

    @Override
    protected void notifyUseOfSaturation(PointsToAnalysis bb, TypeFlow<?> use) {
        this.swapAtUse(bb, this.declaredType.getTypeFlow(bb, true), use);
    }

    @Override
    protected void notifyObserverOfSaturation(PointsToAnalysis bb, TypeFlow<?> observer) {
        this.swapAtObserver(bb, this.declaredType.getTypeFlow(bb, true), observer);
    }

    @Override
    public String toString() {
        return "FieldFilterTypeFlow<" + String.valueOf(this.source) + ">";
    }
}

