/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.enterprise.hosted.code.layout;

import com.oracle.graal.vector.replacements.d;
import com.oracle.svm.enterprise.hosted.code.layout.a;
import com.oracle.svm.hosted.meta.HostedMethod;
import java.util.Optional;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.Equivalence;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.nodes.GraphState;
import org.graalvm.compiler.nodes.Invoke;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.spi.CoreProviders;
import org.graalvm.compiler.phases.BasePhase;

public class CalculateCallEdgeInfoPhase
extends BasePhase<CoreProviders> {
    final a qH;

    public CalculateCallEdgeInfoPhase(a a2) {
        this.qH = a2;
    }

    public Optional<BasePhase.NotApplicable> notApplicableTo(GraphState graphState) {
        return BasePhase.NotApplicable.unlessRunAfter((BasePhase)this, (GraphState.StageFlag)GraphState.StageFlag.FINAL_PARTIAL_ESCAPE, (GraphState)graphState);
    }

    protected void run(StructuredGraph structuredGraph, CoreProviders coreProviders) {
        HostedMethod hostedMethod = (HostedMethod)structuredGraph.method();
        assert (this.qH.g(hostedMethod)) : "Caller-callee count should not be overwritten: double entry for " + String.valueOf(hostedMethod);
        EconomicMap economicMap = EconomicMap.create((Equivalence)Equivalence.IDENTITY);
        for (Node node : structuredGraph.getNodes()) {
            HostedMethod hostedMethod2 = CalculateCallEdgeInfoPhase.f(node);
            if (hostedMethod2 == null || hostedMethod2.equals(hostedMethod)) continue;
            economicMap.put((Object)hostedMethod2, (Object)1L);
        }
        this.qH.a(hostedMethod, (EconomicMap<HostedMethod, Long>)economicMap);
    }

    private static HostedMethod f(Node node) {
        if (node instanceof d) {
            return (HostedMethod)((d)node).getTargetMethod();
        }
        if (node instanceof Invoke) {
            return (HostedMethod)((Invoke)node).getTargetMethod();
        }
        return null;
    }
}

