/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.enterprise.buildreport;

import com.oracle.svm.core.BuildArtifacts;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.option.HostedOptionValues;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.enterprise.hosted.h;
import com.oracle.svm.hosted.NativeImageGenerator;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

@Platforms(value={Platform.HOSTED_ONLY.class})
public final class a
implements h.a {
    public static final Path a = NativeImageGenerator.generatedFiles((OptionValues)HostedOptionValues.singleton());

    @Override
    public Path b() {
        String string = String.format("%s-build-report.html", SubstrateOptions.Name.getValue());
        return a.resolve(string);
    }

    @Override
    public void a(BuildArtifacts buildArtifacts) {
        Path path = this.b();
        try {
            Path path2 = path.getFileName();
            if (path2 == null) {
                throw VMError.shouldNotReachHere((String)"Unable to determine file name");
            }
            b.a(path.getParent(), path2.toString());
        }
        catch (Exception exception) {
            throw VMError.shouldNotReachHere((String)"Failed to generate build report", (Throwable)exception);
        }
        BuildArtifacts.singleton().add(BuildArtifacts.ArtifactType.BUILD_INFO, path);
    }

    public static final class b {
        public static final String g = "/index.html";
        public static final String h = "/list-js.txt";
        public static final Pattern j = Pattern.compile("<!-- *@(.+) *-->");

        private static String a(Path path) {
            return "/".concat(StreamSupport.stream(path.spliterator(), false).map(Path::toString).collect(Collectors.joining("/")));
        }

        public static byte[] b(String string) {
            try {
                InputStream inputStream = a.class.getResourceAsStream(string);
                assert (inputStream != null) : "Failed to access resource: " + string;
                return inputStream.readAllBytes();
            }
            catch (IOException iOException) {
                throw VMError.shouldNotReachHere((String)"Failed to read resource", (Throwable)iOException);
            }
        }

        public static void a(String string, Consumer<String> consumer) {
            try {
                InputStream inputStream = a.class.getResourceAsStream(string);
                assert (inputStream != null) : "Failed to access resource: " + string;
                try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));){
                    String string2;
                    while ((string2 = bufferedReader.readLine()) != null) {
                        consumer.accept(string2);
                    }
                }
            }
            catch (IOException iOException) {
                throw VMError.shouldNotReachHere((String)"Failed to read resource", (Throwable)iOException);
            }
        }

        private static void a(a a2, BiConsumer<String, a> biConsumer) {
            b.a(g, (String string) -> {
                Matcher matcher = j.matcher(string.trim());
                if (matcher.find()) {
                    String string2 = matcher.group(1);
                    biConsumer.accept(string2, a2);
                } else {
                    a2.e.add((String)string);
                }
            });
        }

        private static void a(Path path, String string) throws IOException {
            a a3 = new a(path, string);
            b.a(a3, (String string2, a a2) -> {
                Object[] objectArray = string2.split(" ");
                switch (objectArray[0]) {
                    case "INCLUDE_JS_FILES": {
                        String string3;
                        b.a(h, (String string) -> {
                            Path path = Path.of(string, new String[0]);
                            String string2 = b.a(path);
                            a2.a("<script>");
                            b.a(string2, a2::a);
                            a2.a("</script>");
                        });
                        try {
                            string3 = com.oracle.svm.enterprise.buildreport.data.a.instance().e();
                        }
                        catch (IOException iOException) {
                            throw VMError.shouldNotReachHere((String)"Failed to dump build report data", (Throwable)iOException);
                        }
                        a2.a("<script>");
                        a2.a(string3);
                        a2.a("</script>");
                        break;
                    }
                    case "INCLUDE_CSS": {
                        assert (objectArray.length == 2) : "INCLUDE_CSS requires exactly one argument, found = " + Arrays.toString(objectArray);
                        String string4 = objectArray[1].trim();
                        String string5 = b.a(Path.of(g, new String[0]).resolveSibling(string4));
                        a2.a("<style>");
                        b.a(string5, a2::a);
                        a2.a("</style>");
                    }
                }
            });
            a3.c();
        }
    }

    private static class a {
        private final Path b;
        private final String c;
        static final boolean d = true;
        private final List<String> e = new ArrayList<String>();
        private final Map<String, byte[]> f = new HashMap<String, byte[]>();

        a(Path path, String string) {
            this.b = path;
            this.c = string;
        }

        void a(String string) {
            this.e.add(string);
        }

        void a(String string, byte[] byArray) {
            assert (!string.startsWith("/")) : "Resource path should be relative to target directory, found = " + string;
            this.f.put(string, byArray);
        }

        void c() throws IOException {
            Files.createDirectories(this.b, new FileAttribute[0]);
            Path path = this.b.resolve(this.c);
            try (PrintWriter printWriter = new PrintWriter(path.toFile());){
                for (String string2 : this.e) {
                    printWriter.println(string2);
                }
            }
            assert (this.f.isEmpty()) : "EMBED_RESOURCE = true, resources.size = " + this.f.size();
            this.f.forEach((string, byArray) -> {
                Path path = this.b.resolve((String)string);
                try {
                    Files.createDirectories(path.getParent(), new FileAttribute[0]);
                    Files.write(path, byArray, new OpenOption[0]);
                }
                catch (IOException iOException) {
                    throw VMError.shouldNotReachHere((String)"Failed write build report", (Throwable)iOException);
                }
            });
        }
    }
}

