/*
 * Decompiled with CFR 0.152.
 */
package ai.onnxruntime;

import ai.onnxruntime.MapInfo;
import ai.onnxruntime.OnnxJavaType;
import ai.onnxruntime.OnnxRuntime;
import ai.onnxruntime.OnnxValue;
import ai.onnxruntime.OrtException;
import ai.onnxruntime.OrtUtil;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class OnnxMap
implements OnnxValue {
    final long nativeHandle;
    final long allocatorHandle;
    private final MapInfo info;
    private final boolean stringKeys;
    private final OnnxMapValueType valueType;

    OnnxMap(long l2, long l3, MapInfo mapInfo) {
        this.nativeHandle = l2;
        this.allocatorHandle = l3;
        this.info = mapInfo;
        this.stringKeys = mapInfo.keyType == OnnxJavaType.STRING;
        this.valueType = OnnxMapValueType.mapFromOnnxJavaType(mapInfo.valueType);
    }

    public int size() {
        return this.info.size;
    }

    @Override
    public OnnxValue.OnnxValueType getType() {
        return OnnxValue.OnnxValueType.ONNX_TYPE_MAP;
    }

    @Override
    public Map<? extends Object, ? extends Object> getValue() throws OrtException {
        Object[] objectArray = this.getMapKeys();
        Object[] objectArray2 = this.getMapValues();
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>(OrtUtil.capacityFromSize(objectArray.length));
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            hashMap.put(objectArray[i2], objectArray2[i2]);
        }
        return hashMap;
    }

    private Object[] getMapKeys() throws OrtException {
        if (this.stringKeys) {
            return this.getStringKeys(OnnxRuntime.ortApiHandle, this.nativeHandle, this.allocatorHandle);
        }
        return Arrays.stream(this.getLongKeys(OnnxRuntime.ortApiHandle, this.nativeHandle, this.allocatorHandle)).boxed().toArray();
    }

    private Object[] getMapValues() throws OrtException {
        switch (this.valueType) {
            case STRING: {
                return this.getStringValues(OnnxRuntime.ortApiHandle, this.nativeHandle, this.allocatorHandle);
            }
            case LONG: {
                return Arrays.stream(this.getLongValues(OnnxRuntime.ortApiHandle, this.nativeHandle, this.allocatorHandle)).boxed().toArray();
            }
            case FLOAT: {
                float[] fArray = this.getFloatValues(OnnxRuntime.ortApiHandle, this.nativeHandle, this.allocatorHandle);
                Object[] objectArray = new Float[fArray.length];
                for (int i2 = 0; i2 < fArray.length; ++i2) {
                    objectArray[i2] = Float.valueOf(fArray[i2]);
                }
                return objectArray;
            }
            case DOUBLE: {
                return Arrays.stream(this.getDoubleValues(OnnxRuntime.ortApiHandle, this.nativeHandle, this.allocatorHandle)).boxed().toArray();
            }
        }
        throw new RuntimeException("Invalid or unknown valueType: " + (Object)((Object)this.valueType));
    }

    @Override
    public MapInfo getInfo() {
        return this.info;
    }

    public String toString() {
        return "ONNXMap(size=" + this.size() + ",info=" + this.info.toString() + ")";
    }

    @Override
    public void close() {
        this.close(OnnxRuntime.ortApiHandle, this.nativeHandle);
    }

    private native String[] getStringKeys(long var1, long var3, long var5) throws OrtException;

    private native long[] getLongKeys(long var1, long var3, long var5) throws OrtException;

    private native String[] getStringValues(long var1, long var3, long var5) throws OrtException;

    private native long[] getLongValues(long var1, long var3, long var5) throws OrtException;

    private native float[] getFloatValues(long var1, long var3, long var5) throws OrtException;

    private native double[] getDoubleValues(long var1, long var3, long var5) throws OrtException;

    private native void close(long var1, long var3);

    static {
        try {
            OnnxRuntime.init();
        }
        catch (IOException iOException) {
            throw new RuntimeException("Failed to load onnx-runtime library", iOException);
        }
    }

    public static enum OnnxMapValueType {
        INVALID(0),
        STRING(1),
        LONG(2),
        FLOAT(3),
        DOUBLE(4);

        final int value;
        private static final OnnxMapValueType[] values;

        private OnnxMapValueType(int n3) {
            this.value = n3;
        }

        public static OnnxMapValueType mapFromInt(int n2) {
            if (n2 > 0 && n2 < values.length) {
                return values[n2];
            }
            return INVALID;
        }

        public static OnnxMapValueType mapFromOnnxJavaType(OnnxJavaType onnxJavaType) {
            switch (onnxJavaType) {
                case FLOAT: {
                    return FLOAT;
                }
                case DOUBLE: {
                    return DOUBLE;
                }
                case INT64: {
                    return LONG;
                }
                case STRING: {
                    return STRING;
                }
            }
            return INVALID;
        }

        static {
            values = new OnnxMapValueType[5];
            OnnxMapValueType[] onnxMapValueTypeArray = OnnxMapValueType.values();
            int n2 = onnxMapValueTypeArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                OnnxMapValueType onnxMapValueType;
                OnnxMapValueType.values[onnxMapValueType.value] = onnxMapValueType = onnxMapValueTypeArray[i2];
            }
        }
    }
}

