/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jipher.internal.spi;

import com.oracle.jipher.internal.common.MultiRelease;
import com.oracle.jipher.internal.common.Util;
import com.oracle.jipher.internal.openssl.CipherCtx;
import com.oracle.jipher.internal.spi.CipherAlg;
import com.oracle.jipher.internal.spi.CipherMode;
import com.oracle.jipher.internal.spi.WrapUtil;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.ProviderException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Arrays;
import javax.crypto.BadPaddingException;
import javax.crypto.CipherSpi;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;

public abstract class WrapCipher
extends CipherSpi {
    private State state;
    private Object cleanable;
    private final CipherMode mode;
    private final CipherAlg cipherAlg;

    WrapCipher(CipherAlg ciph, CipherMode mode) {
        this.cipherAlg = ciph;
        this.mode = mode;
    }

    @Override
    protected void engineSetMode(String s) throws NoSuchAlgorithmException {
        if (!s.equalsIgnoreCase("ECB")) {
            throw new NoSuchAlgorithmException(s + " cannot be used");
        }
    }

    @Override
    protected void engineSetPadding(String s) throws NoSuchPaddingException {
        if (!s.equalsIgnoreCase("NoPadding")) {
            throw new NoSuchPaddingException(s + " cannot be used");
        }
    }

    @Override
    protected int engineGetKeySize(Key key) {
        byte[] encoded = key.getEncoded();
        Util.clearArray(encoded);
        return encoded.length * 8;
    }

    @Override
    protected void engineInit(int cipherMode, Key key, SecureRandom secureRandom) throws InvalidKeyException {
        this.initInternal(key);
    }

    @Override
    protected void engineInit(int cipherMode, Key key, AlgorithmParameters algorithmParameters, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (algorithmParameters != null) {
            throw new InvalidAlgorithmParameterException("Parameters not expected for key wrap cipher");
        }
        this.engineInit(cipherMode, key, secureRandom);
    }

    @Override
    protected AlgorithmParameters engineGetParameters() {
        return null;
    }

    @Override
    protected void engineInit(int cipherMode, Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (algorithmParameterSpec != null) {
            throw new InvalidAlgorithmParameterException("Parameters not expected for key wrap cipher");
        }
        this.initInternal(key);
    }

    @Override
    protected byte[] engineWrap(Key toWrap) throws IllegalBlockSizeException {
        byte[] keyBytes = toWrap.getEncoded();
        try {
            byte[] byArray = this.doCipherOp(true, keyBytes);
            return byArray;
        }
        catch (InvalidAlgorithmParameterException | ProviderException | BadPaddingException e) {
            throw new IllegalBlockSizeException(e.getMessage());
        }
        finally {
            Util.clearArray(keyBytes);
        }
    }

    @Override
    protected Key engineUnwrap(byte[] wrappedKey, String keyAlg, int wrappedKeyType) throws InvalidKeyException, NoSuchAlgorithmException {
        try {
            byte[] unwrapped = this.doCipherOp(false, wrappedKey);
            return WrapUtil.createKey(keyAlg, wrappedKeyType, unwrapped);
        }
        catch (InvalidAlgorithmParameterException | ProviderException | BadPaddingException | IllegalBlockSizeException e) {
            throw new InvalidKeyException(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] doCipherOp(boolean wrap, byte[] data) throws BadPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException {
        if (this.state == null) {
            throw new IllegalStateException("Not initialized");
        }
        CipherCtx ctx = new CipherCtx();
        try {
            ctx.init(this.cipherAlg.getAlg(this.state.keyData.length * 8, this.mode), false, wrap, this.state.keyData, null);
            MultiRelease.reachabilityFence(this);
            byte[] out = new byte[this.engineGetOutputSize(data.length)];
            int outLen = ctx.update(data, 0, data.length, out, 0);
            outLen += ctx.doFinal(out, outLen);
            byte[] ret = Arrays.copyOf(out, outLen);
            Util.clearArray(out);
            byte[] byArray = ret;
            return byArray;
        }
        finally {
            ctx.free();
        }
    }

    private void initInternal(Key key) throws InvalidKeyException {
        this.clear();
        this.state = new State(this.verifyKeyData(key));
        this.cleanable = MultiRelease.CLEANER_INSTANCE.register(this, this.state);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] verifyKeyData(Key key) throws InvalidKeyException {
        if (!(key instanceof SecretKey)) {
            throw new InvalidKeyException("Only SecretKey permitted.");
        }
        byte[] encoded = key.getEncoded();
        try {
            this.cipherAlg.validateKeySize(encoded.length);
            byte[] tmp = encoded;
            encoded = null;
            byte[] byArray = tmp;
            return byArray;
        }
        finally {
            Util.clearArray(encoded);
        }
    }

    @Override
    protected int engineUpdate(byte[] input, int inOffset, int len, byte[] out, int outOffset) {
        throw new IllegalStateException("update,doFinal not applicable to key wrap cipher, use wrap,unwrap");
    }

    @Override
    protected byte[] engineUpdate(byte[] bytes, int i, int i1) {
        throw new IllegalStateException("update,doFinal not applicable to key wrap cipher, use wrap,unwrap");
    }

    @Override
    protected byte[] engineDoFinal(byte[] bytes, int i, int i1) {
        throw new IllegalStateException("update,doFinal not applicable to key wrap cipher, use wrap,unwrap");
    }

    @Override
    protected int engineDoFinal(byte[] bytes, int off, int len, byte[] out, int outOff) {
        throw new IllegalStateException("update,doFinal not applicable to key wrap cipher, use wrap,unwrap");
    }

    @Override
    protected byte[] engineGetIV() {
        return null;
    }

    @Override
    protected int engineGetBlockSize() {
        return this.cipherAlg.getBlockSize();
    }

    @Override
    protected int engineGetOutputSize(int inputLen) {
        return inputLen + 8 + 7 & 0xFFFFFFF8;
    }

    private void clear() {
        if (this.state != null) {
            MultiRelease.clean(this.cleanable);
            this.state = null;
            this.cleanable = null;
        }
    }

    public static class AesWrapPad256
    extends WrapCipher {
        public AesWrapPad256() {
            super(new CipherAlg.AesKeyWrap(256), CipherMode.KWP);
        }
    }

    public static class AesWrapPad192
    extends WrapCipher {
        public AesWrapPad192() {
            super(new CipherAlg.AesKeyWrap(192), CipherMode.KWP);
        }
    }

    public static class AesWrapPad128
    extends WrapCipher {
        public AesWrapPad128() {
            super(new CipherAlg.AesKeyWrap(128), CipherMode.KWP);
        }
    }

    public static class AesWrapPad
    extends WrapCipher {
        public AesWrapPad() {
            super(new CipherAlg.AesKeyWrap(), CipherMode.KWP);
        }
    }

    public static class AesWrap256
    extends WrapCipher {
        public AesWrap256() {
            super(new CipherAlg.AesKeyWrap(256), CipherMode.KW);
        }
    }

    public static class AesWrap192
    extends WrapCipher {
        public AesWrap192() {
            super(new CipherAlg.AesKeyWrap(192), CipherMode.KW);
        }
    }

    public static class AesWrap128
    extends WrapCipher {
        public AesWrap128() {
            super(new CipherAlg.AesKeyWrap(128), CipherMode.KW);
        }
    }

    public static class AesWrap
    extends WrapCipher {
        public AesWrap() {
            super(new CipherAlg.AesKeyWrap(), CipherMode.KW);
        }
    }

    static final class State
    implements Runnable {
        final byte[] keyData;

        State(byte[] keyData) {
            this.keyData = keyData;
        }

        @Override
        public final void run() {
            Util.clearArray(this.keyData);
        }
    }
}

