/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jipher.internal.spi;

import com.oracle.jipher.internal.common.Util;
import com.oracle.jipher.internal.openssl.EvpKdf;
import com.oracle.jipher.internal.openssl.MdAlg;
import com.oracle.jipher.internal.openssl.Rand;
import com.oracle.jipher.internal.spi.CipherAlg;
import com.oracle.jipher.internal.spi.CipherMode;
import com.oracle.jipher.internal.spi.CipherPadding;
import com.oracle.jipher.internal.spi.FeedbackCipher;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public abstract class PbeCipher
extends FeedbackCipher {
    private static final int DEFAULT_SALT_SIZE_BYTES = 20;
    private static final int DEFAULT_ITER_COUNT = 50000;
    private final String algorithm;
    final MdAlg digest;
    final int keySizeBits;

    PbeCipher(String algorithm, CipherAlg cipherAlg, MdAlg digest, int keySizeBits) throws NoSuchAlgorithmException, NoSuchPaddingException {
        super(cipherAlg);
        this.algorithm = algorithm;
        this.digest = digest;
        this.keySizeBits = keySizeBits;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void engineInit(int cipherMode, Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        AlgorithmParameterSpec innerAlgParamSpec;
        int iter;
        byte[] salt;
        PBEParameterSpec pbeParamSpec;
        try {
            pbeParamSpec = (PBEParameterSpec)algorithmParameterSpec;
            if (pbeParamSpec == null && this.paramSpec != null) {
                pbeParamSpec = (PBEParameterSpec)this.paramSpec;
            }
        }
        catch (ClassCastException ex) {
            throw new InvalidAlgorithmParameterException("Invalid parameters, expected PBE parameters");
        }
        if (pbeParamSpec != null) {
            salt = pbeParamSpec.getSalt();
            if (salt.length < 8) {
                throw new InvalidAlgorithmParameterException("Salt must be at least 8 bytes long");
            }
            iter = pbeParamSpec.getIterationCount();
            if (iter < 0) {
                throw new InvalidAlgorithmParameterException("IterationCount must be a positive number");
            }
            if (iter == 0) {
                iter = 50000;
            }
            innerAlgParamSpec = pbeParamSpec.getParameterSpec();
        } else {
            if (cipherMode == 2 || cipherMode == 4) {
                throw new InvalidAlgorithmParameterException("Parameters missing");
            }
            salt = Rand.generate(20);
            iter = 50000;
            innerAlgParamSpec = null;
        }
        if (!(key instanceof SecretKey)) {
            throw new InvalidKeyException("Only SecretKey permitted");
        }
        byte[] pwBytes = key.getEncoded();
        byte[] dk = null;
        SecretKeySpec dKey = null;
        try {
            dk = this.deriveKey(pwBytes, salt, iter);
            dKey = new SecretKeySpec(dk, this.cipherAlg.getName());
            innerAlgParamSpec = this.deriveIv(pwBytes, salt, iter, innerAlgParamSpec);
            pbeParamSpec = new PBEParameterSpec(salt, iter, innerAlgParamSpec);
            super.engineInit(cipherMode, (Key)dKey, pbeParamSpec, secureRandom);
        }
        catch (Throwable throwable) {
            Util.clearArray(pwBytes);
            Util.clearArray(dk);
            Util.destroyKey(dKey);
            throw throwable;
        }
        Util.clearArray(pwBytes);
        Util.clearArray(dk);
        Util.destroyKey(dKey);
    }

    abstract AlgorithmParameterSpec deriveIv(byte[] var1, byte[] var2, int var3, AlgorithmParameterSpec var4);

    abstract byte[] deriveKey(byte[] var1, byte[] var2, int var3);

    @Override
    Class<? extends AlgorithmParameterSpec> getParameterSpecClass() {
        return PBEParameterSpec.class;
    }

    @Override
    String getAlgorithmParametersAlg() {
        return this.algorithm;
    }

    public static final class PBEWithHmacSHA512AndAES256
    extends Pbes2Cipher {
        public PBEWithHmacSHA512AndAES256() throws NoSuchAlgorithmException, NoSuchPaddingException {
            super("PBEWithHmacSHA512AndAES_256", MdAlg.SHA512, 256);
        }
    }

    public static final class PBEWithHmacSHA384AndAES256
    extends Pbes2Cipher {
        public PBEWithHmacSHA384AndAES256() throws NoSuchAlgorithmException, NoSuchPaddingException {
            super("PBEWithHmacSHA384AndAES_256", MdAlg.SHA384, 256);
        }
    }

    public static final class PBEWithHmacSHA256AndAES256
    extends Pbes2Cipher {
        public PBEWithHmacSHA256AndAES256() throws NoSuchAlgorithmException, NoSuchPaddingException {
            super("PBEWithHmacSHA256AndAES_256", MdAlg.SHA256, 256);
        }
    }

    public static final class PBEWithHmacSHA224AndAES256
    extends Pbes2Cipher {
        public PBEWithHmacSHA224AndAES256() throws NoSuchAlgorithmException, NoSuchPaddingException {
            super("PBEWithHmacSHA224AndAES_256", MdAlg.SHA224, 256);
        }
    }

    public static final class PBEWithHmacSHA1AndAES256
    extends Pbes2Cipher {
        public PBEWithHmacSHA1AndAES256() throws NoSuchAlgorithmException, NoSuchPaddingException {
            super("PBEWithHmacSHA1AndAES_256", MdAlg.SHA1, 256);
        }
    }

    public static final class PBEWithHmacSHA512AndAES128
    extends Pbes2Cipher {
        public PBEWithHmacSHA512AndAES128() throws NoSuchAlgorithmException, NoSuchPaddingException {
            super("PBEWithHmacSHA512AndAES_128", MdAlg.SHA512, 128);
        }
    }

    public static final class PBEWithHmacSHA384AndAES128
    extends Pbes2Cipher {
        public PBEWithHmacSHA384AndAES128() throws NoSuchAlgorithmException, NoSuchPaddingException {
            super("PBEWithHmacSHA384AndAES_128", MdAlg.SHA384, 128);
        }
    }

    public static final class PBEWithHmacSHA256AndAES128
    extends Pbes2Cipher {
        public PBEWithHmacSHA256AndAES128() throws NoSuchAlgorithmException, NoSuchPaddingException {
            super("PBEWithHmacSHA256AndAES_128", MdAlg.SHA256, 128);
        }
    }

    public static final class PBEWithHmacSHA224AndAES128
    extends Pbes2Cipher {
        public PBEWithHmacSHA224AndAES128() throws NoSuchAlgorithmException, NoSuchPaddingException {
            super("PBEWithHmacSHA224AndAES_128", MdAlg.SHA224, 128);
        }
    }

    public static final class PBEWithHmacSHA1AndAES128
    extends Pbes2Cipher {
        public PBEWithHmacSHA1AndAES128() throws NoSuchAlgorithmException, NoSuchPaddingException {
            super("PBEWithHmacSHA1AndAES_128", MdAlg.SHA1, 128);
        }
    }

    static abstract class Pbes2Cipher
    extends PbeCipher {
        Pbes2Cipher(String algorithm, MdAlg digest, int keySizeBits) throws NoSuchAlgorithmException, NoSuchPaddingException {
            super(algorithm, new CipherAlg.AesFixed(keySizeBits, CipherMode.CBC, CipherPadding.PKCS5PADDING), digest, keySizeBits);
        }

        @Override
        AlgorithmParameterSpec deriveIv(byte[] pwBytes, byte[] salt, int iter, AlgorithmParameterSpec innerAlgParamSpec) {
            return innerAlgParamSpec;
        }

        @Override
        byte[] deriveKey(byte[] pwBytes, byte[] salt, int iter) {
            return EvpKdf.pbkdf2Derive(pwBytes, pwBytes.length, salt, iter, this.digest, this.keySizeBits / 8);
        }

        @Override
        AlgorithmParameterSpec getParamSpec(byte[] iv, AlgorithmParameterSpec spec) {
            PBEParameterSpec pbeParamSpec = (PBEParameterSpec)spec;
            return new PBEParameterSpec(pbeParamSpec.getSalt(), pbeParamSpec.getIterationCount(), new IvParameterSpec(iv));
        }

        @Override
        byte[] verifyParams(AlgorithmParameterSpec spec, boolean encrypt) throws InvalidAlgorithmParameterException {
            PBEParameterSpec pbeParamSpec = (PBEParameterSpec)spec;
            IvParameterSpec ivParamSpec = (IvParameterSpec)pbeParamSpec.getParameterSpec();
            return super.verifyParams(ivParamSpec, encrypt);
        }
    }

    public static final class PBEWithSHA1AndDESede
    extends Pkcs12PbeCipher {
        public PBEWithSHA1AndDESede() throws NoSuchAlgorithmException, NoSuchPaddingException {
            super("PBEWithSHA1AndDESede", new CipherAlg.DesEdeFixed(CipherMode.CBC, CipherPadding.PKCS5PADDING), MdAlg.SHA1, 192);
        }
    }

    static abstract class Pkcs12PbeCipher
    extends PbeCipher {
        Pkcs12PbeCipher(String algorithm, CipherAlg cipherAlg, MdAlg digest, int keySizeBits) throws NoSuchAlgorithmException, NoSuchPaddingException {
            super(algorithm, cipherAlg, digest, keySizeBits);
        }

        @Override
        AlgorithmParameterSpec deriveIv(byte[] pwBytes, byte[] salt, int iter, AlgorithmParameterSpec innerAlgParamSpec) {
            byte[] iv = EvpKdf.pkcs12Derive(pwBytes, pwBytes.length, salt, EvpKdf.Pkcs12KdfId.IV, iter, this.digest, this.cipherAlg.getBlockSize());
            return new IvParameterSpec(iv);
        }

        @Override
        byte[] deriveKey(byte[] pwBytes, byte[] salt, int iter) {
            return EvpKdf.pkcs12Derive(pwBytes, pwBytes.length, salt, EvpKdf.Pkcs12KdfId.KEY, iter, this.digest, this.keySizeBits / 8);
        }

        @Override
        AlgorithmParameterSpec getParamSpec(byte[] iv, AlgorithmParameterSpec spec) {
            return spec;
        }

        @Override
        byte[] verifyParams(AlgorithmParameterSpec spec, boolean encrypt) {
            PBEParameterSpec pbeParamSpec = (PBEParameterSpec)spec;
            IvParameterSpec ivParamSpec = (IvParameterSpec)pbeParamSpec.getParameterSpec();
            return ivParamSpec.getIV();
        }
    }
}

