/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jipher.internal.spi;

import com.oracle.jipher.internal.common.Util;
import com.oracle.jipher.internal.tools.asn1.Asn1;
import com.oracle.jipher.internal.tools.asn1.Asn1BerValue;
import com.oracle.jipher.internal.tools.asn1.Asn1DecodeException;
import java.io.IOException;
import java.security.AlgorithmParametersSpi;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import java.util.List;
import javax.crypto.spec.DHParameterSpec;

public final class DhParameters
extends AlgorithmParametersSpi {
    private DHParameterSpec spec;

    @Override
    protected <T extends AlgorithmParameterSpec> T engineGetParameterSpec(Class<T> paramSpec) throws InvalidParameterSpecException {
        if (paramSpec == DHParameterSpec.class) {
            return (T)((AlgorithmParameterSpec)paramSpec.cast(this.spec));
        }
        throw new InvalidParameterSpecException("Invalid parameter spec class");
    }

    @Override
    protected void engineInit(byte[] params) throws IOException {
        try {
            Asn1BerValue dhParams = Asn1.decodeOne(params);
            Util.assertAllUniversal(dhParams);
            List<Asn1BerValue> dhPValues = dhParams.count(2, 3).sequence();
            this.spec = new DHParameterSpec(dhPValues.get(0).getInteger(), dhPValues.get(1).getInteger(), dhPValues.size() == 3 ? dhPValues.get(2).getInteger().intValueExact() : 0);
        }
        catch (Asn1DecodeException | ArithmeticException ex) {
            throw new IOException("Invalid DH parameters", ex);
        }
    }

    @Override
    protected void engineInit(byte[] params, String format) throws IOException {
        this.engineInit(params);
    }

    @Override
    protected void engineInit(AlgorithmParameterSpec paramSpec) throws InvalidParameterSpecException {
        if (!(paramSpec instanceof DHParameterSpec)) {
            throw new InvalidParameterSpecException("Invalid parameter spec for DSA parameters");
        }
        this.spec = (DHParameterSpec)paramSpec;
    }

    @Override
    protected String engineToString() {
        return "DH Parameters (P=" + Util.bytesToHex(this.spec.getP().toByteArray()) + ",G =" + Util.bytesToHex(this.spec.getG().toByteArray()) + ")";
    }

    @Override
    protected byte[] engineGetEncoded() {
        int l = this.spec.getL();
        Asn1BerValue dhParams = Asn1.newSequence(Asn1.newInteger(this.spec.getP()), Asn1.newInteger(this.spec.getG()), l > 0 ? Asn1.newInteger(l) : null);
        return dhParams.encodeDerOctets();
    }

    @Override
    protected byte[] engineGetEncoded(String format) {
        return this.engineGetEncoded();
    }
}

